/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.log;

import com.eviware.soapui.impl.wsdl.testcase.TestCaseLogItem;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.security.log.FunctionalTestLogModel;
import com.eviware.soapui.security.log.JSecurityTestRunLog;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.ActionSupport;
import com.eviware.soapui.support.components.JHyperlinkLabel;
import com.eviware.soapui.support.components.JXToolBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.apache.log4j.Logger;

public class JFunctionalTestRunLog
extends JPanel {
    private FunctionalTestLogModel logListModel;
    private JList testLogList;
    private Set<String> boldTexts = new HashSet<String>();
    protected int selectedIndex;
    private Logger log = Logger.getLogger(JSecurityTestRunLog.class);
    private boolean follow = true;

    public JFunctionalTestRunLog(SecurityTest securityTest) {
        super(new BorderLayout());
        this.logListModel = new FunctionalTestLogModel();
        this.buildUI();
    }

    private void buildUI() {
        this.testLogList = new JList(this.logListModel);
        this.testLogList.setCellRenderer(new FunctionalLogCellRenderer());
        this.testLogList.addMouseListener(new LogListMouseListener());
        JScrollPane scrollPane = new JScrollPane(this.testLogList);
        this.add((Component)scrollPane, "Center");
        this.add(this.buildToolbar(), "North");
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        this.addToolbarButtons(toolbar);
        return toolbar;
    }

    protected JList getTestLogList() {
        return this.testLogList;
    }

    protected void addToolbarButtons(JXToolBar toolbar) {
        toolbar.addFixed(UISupport.createToolbarButton(new ClearLogAction()));
        toolbar.addFixed(UISupport.createToolbarButton(new ExportLogAction()));
    }

    public synchronized void clear() {
        this.logListModel.clear();
        this.boldTexts.clear();
    }

    public synchronized void addSecurityTestFunctionalStepResult(TestStepResult testStepResult) {
        this.logListModel.addSecurityTestFunctionalStepResult(testStepResult);
        if (this.follow) {
            try {
                this.testLogList.ensureIndexIsVisible(this.logListModel.getSize() - 1);
            }
            catch (RuntimeException e) {
                this.log.error((Object)e.getMessage());
            }
        }
    }

    public void printLog(PrintWriter out) {
        for (int c = 0; c < this.logListModel.getSize(); ++c) {
            Object value = this.logListModel.getElementAt(c);
            if (!(value instanceof String)) continue;
            out.println(value.toString());
        }
    }

    public synchronized void addText(String string) {
        this.logListModel.addText(string);
        if (this.follow) {
            this.testLogList.ensureIndexIsVisible(this.logListModel.getSize() - 1);
        }
    }

    public void release() {
        this.logListModel = null;
        this.testLogList.setModel(new DefaultListModel());
    }

    private final class FunctionalLogCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private Font boldFont;
        private Font normalFont;
        private JHyperlinkLabel hyperlinkLabel = new JHyperlinkLabel("");

        public FunctionalLogCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.setIcon(null);
            this.boldFont = this.getFont().deriveFont(1);
            this.normalFont = this.getFont();
            this.hyperlinkLabel.setOpaque(true);
            this.hyperlinkLabel.setForeground(Color.BLUE.darker().darker().darker());
            this.hyperlinkLabel.setUnderlineColor(Color.GRAY);
            this.hyperlinkLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 3, 3));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof String) {
                this.setText(value.toString());
            } else if (value instanceof TestCaseLogItem) {
                TestCaseLogItem logItem = (TestCaseLogItem)value;
                String msg = logItem.getMsg();
                this.setText(msg == null ? "" : msg);
            }
            TestStepResult result = JFunctionalTestRunLog.this.logListModel.getTestStepResultAt(index);
            if (result != null && !this.getText().startsWith(" ->")) {
                this.hyperlinkLabel.setText(this.getText());
                this.hyperlinkLabel.setBackground(this.getBackground());
                this.hyperlinkLabel.setEnabled(list.isEnabled());
                if (result.getStatus() == TestStepResult.TestStepStatus.OK) {
                    this.hyperlinkLabel.setIcon(UISupport.createImageIcon("/valid_assertion.gif"));
                } else if (result.getStatus() == TestStepResult.TestStepStatus.FAILED) {
                    this.hyperlinkLabel.setIcon(UISupport.createImageIcon("/failed_assertion.gif"));
                } else {
                    this.hyperlinkLabel.setIcon(UISupport.createImageIcon("/unknown_assertion.gif"));
                }
                return this.hyperlinkLabel;
            }
            this.setEnabled(list.isEnabled());
            if (JFunctionalTestRunLog.this.boldTexts.contains(this.getText())) {
                this.setFont(this.boldFont);
            } else {
                this.setFont(this.normalFont);
            }
            return this;
        }
    }

    private final class LogListMouseListener
    extends MouseAdapter {
        private LogListMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            TestStepResult result;
            int index = JFunctionalTestRunLog.this.testLogList.getSelectedIndex();
            if (index != -1 && (index == JFunctionalTestRunLog.this.selectedIndex || e.getClickCount() > 1) && (result = JFunctionalTestRunLog.this.logListModel.getTestStepResultAt(index)) != null && result.getActions() != null) {
                result.getActions().performDefaultAction(new ActionEvent(this, 0, null));
            }
            JFunctionalTestRunLog.this.selectedIndex = index;
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        public void showPopup(MouseEvent e) {
            TestStepResult result;
            int row = JFunctionalTestRunLog.this.testLogList.locationToIndex(e.getPoint());
            if (row == -1) {
                return;
            }
            if (JFunctionalTestRunLog.this.testLogList.getSelectedIndex() != row) {
                JFunctionalTestRunLog.this.testLogList.setSelectedIndex(row);
            }
            if ((result = JFunctionalTestRunLog.this.logListModel.getTestStepResultAt(row)) == null) {
                return;
            }
            ActionList actions = result.getActions();
            if (actions == null || actions.getActionCount() == 0) {
                return;
            }
            JPopupMenu popup = ActionSupport.buildPopup(actions);
            UISupport.showPopup(popup, JFunctionalTestRunLog.this.testLogList, e.getPoint());
        }
    }

    private class ExportLogAction
    extends AbstractAction {
        public ExportLogAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/export.gif"));
            this.putValue("ShortDescription", "Exports this log to a file");
        }

        public void actionPerformed(ActionEvent e) {
            File file = UISupport.getFileDialogs().saveAs(this, "Save Log");
            if (file != null) {
                try {
                    PrintWriter out = new PrintWriter(file);
                    JFunctionalTestRunLog.this.printLog(out);
                    out.close();
                }
                catch (FileNotFoundException e1) {
                    UISupport.showErrorMessage(e1);
                }
            }
        }
    }

    private class ClearLogAction
    extends AbstractAction {
        public ClearLogAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/clear_loadtest.gif"));
            this.putValue("ShortDescription", "Clears the log");
        }

        public void actionPerformed(ActionEvent e) {
            JFunctionalTestRunLog.this.logListModel.clear();
        }
    }
}

