/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.scan;

import com.eviware.soapui.config.SecurityScanConfig;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.security.SecurityCheckedParameter;
import com.eviware.soapui.model.support.XPathReference;
import com.eviware.soapui.model.support.XPathReferenceContainer;
import com.eviware.soapui.model.support.XPathReferenceImpl;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.security.scan.AbstractSecurityScan;
import com.eviware.soapui.security.support.SecurityCheckedParameterHolder;
import com.eviware.soapui.security.support.SecurityCheckedParameterImpl;
import com.eviware.soapui.support.types.StringToStringMap;
import java.util.ArrayList;

public abstract class AbstractSecurityScanWithProperties
extends AbstractSecurityScan
implements XPathReferenceContainer {
    public static final String SECURITY_CHANGED_PARAMETERS = "SecurityChangedParameters";
    private SecurityCheckedParameterHolder parameterHolder;

    public AbstractSecurityScanWithProperties(TestStep testStep, SecurityScanConfig config, ModelItem parent, String icon) {
        super(testStep, config, parent, icon);
        this.setParameterHolder(new SecurityCheckedParameterHolder(this, ((SecurityScanConfig)this.getConfig()).getCheckedParameters()));
    }

    public SecurityCheckedParameterHolder getParameterHolder() {
        return this.parameterHolder;
    }

    protected void setParameterHolder(SecurityCheckedParameterHolder parameterHolder) {
        this.parameterHolder = parameterHolder;
    }

    public void copyConfig(SecurityScanConfig config) {
        super.copyConfig(config);
        ((SecurityScanConfig)this.getConfig()).setCheckedParameters(config.getCheckedParameters());
        if (this.parameterHolder != null) {
            this.parameterHolder.release();
        }
        this.parameterHolder = new SecurityCheckedParameterHolder(this, config.getCheckedParameters());
    }

    public XPathReference[] getXPathReferences() {
        ArrayList<XPathReferenceImpl> result = new ArrayList<XPathReferenceImpl>();
        for (SecurityCheckedParameter param : this.getParameterHolder().getParameterList()) {
            TestStep t = this.getTestStep();
            if (!(t instanceof WsdlTestRequestStep) || param == null) continue;
            result.add(new XPathReferenceImpl("SecurityScan Parameter " + param.getLabel() + " in \"" + this.getTestStep().getName() + "\"", ((WsdlTestRequestStep)t).getOperation(), true, param, "xpath"));
        }
        return result.toArray(new XPathReference[result.size()]);
    }

    public void updateSecurityConfig(SecurityScanConfig config) {
        super.updateSecurityConfig(config);
        if (this.getParameterHolder() != null && ((SecurityScanConfig)this.getConfig()).getCheckedParameters() != null) {
            this.getParameterHolder().updateConfig(config.getCheckedParameters());
        }
    }

    public SecurityCheckedParameter getParameterAt(int i) {
        if (!this.getParameterHolder().getParameterList().isEmpty() && this.getParameterHolder().getParameterList().size() > i) {
            return this.getParameterHolder().getParameterList().get(i);
        }
        return null;
    }

    public SecurityCheckedParameter getParameterByLabel(String label) {
        return this.parameterHolder.getParametarByLabel(label);
    }

    public boolean importParameter(SecurityCheckedParameter source, boolean overwrite2, String newLabel) {
        SecurityCheckedParameterImpl param = (SecurityCheckedParameterImpl)this.getParameterHolder().getParametarByLabel(newLabel);
        if (param != null) {
            if (overwrite2) {
                param.setName(source.getName());
                param.setXpath(source.getXpath());
                param.setChecked(source.isChecked());
                return true;
            }
            return false;
        }
        return this.getParameterHolder().addParameter(newLabel, source.getName(), source.getXpath(), source.isChecked());
    }

    protected void createMessageExchange(StringToStringMap updatedParams, MessageExchange message, SecurityTestRunContext context) {
        for (String param : updatedParams.keySet()) {
            String value = context.expand((String)updatedParams.get(param));
            updatedParams.put(param, value);
        }
        message.getProperties().put(SECURITY_CHANGED_PARAMETERS, updatedParams.toXml());
        this.getSecurityScanRequestResult().setMessageExchange(message);
    }

    public void release() {
        if (this.parameterHolder != null) {
            this.parameterHolder.release();
        }
        super.release();
    }
}

