/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.scan;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.SQLInjectionScanConfig;
import com.eviware.soapui.config.SecurityScanConfig;
import com.eviware.soapui.config.StrategyTypeConfig;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.security.SecurityCheckedParameter;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.security.scan.AbstractSecurityScanWithProperties;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.StringListFormComponent;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectTreeModel;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.impl.swing.JFormDialog;
import com.eviware.x.impl.swing.JStringListFormField;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.xmlbeans.XmlException;

public class SQLInjectionScan
extends AbstractSecurityScanWithProperties {
    public static final String TYPE = "SQLInjectionScan";
    public static final String NAME = "SQL Injection";
    private SQLInjectionScanConfig sqlInjectionConfig;
    private Map<SecurityCheckedParameter, ArrayList<String>> parameterMutations = new HashMap<SecurityCheckedParameter, ArrayList<String>>();
    String[] defaultSqlInjectionStrings = new String[]{"' or '1'='1", "'--", "1'", "admin'--", "/*!10000%201/0%20*/", "/*!10000 1/0 */", "1/0", "'%20o/**/r%201/0%20--", "' o/**/r 1/0 --", ";", "'%20and%201=2%20--", "' and 1=2 --", "test\ufffd%20UNION%20select%201,%20@@version,%201,%201;\ufffd", "test\ufffd UNION select 1, @@version, 1, 1;\ufffd"};
    private boolean mutation;
    private JFormDialog dialog;

    public SQLInjectionScan(TestStep testStep, SecurityScanConfig config, ModelItem parent, String icon) {
        super(testStep, config, parent, icon);
        if (config.getConfig() == null || !(config.getConfig() instanceof SQLInjectionScanConfig)) {
            this.initSqlInjectionConfig();
        } else {
            this.sqlInjectionConfig = (SQLInjectionScanConfig)((SecurityScanConfig)this.getConfig()).getConfig();
        }
    }

    private void initSqlInjectionConfig() {
        ((SecurityScanConfig)this.getConfig()).setConfig(SQLInjectionScanConfig.Factory.newInstance());
        this.sqlInjectionConfig = (SQLInjectionScanConfig)((SecurityScanConfig)this.getConfig()).getConfig();
        this.sqlInjectionConfig.setSqlInjectionStringsArray(this.defaultSqlInjectionStrings);
    }

    public void updateSecurityConfig(SecurityScanConfig config) {
        super.updateSecurityConfig(config);
        if (this.sqlInjectionConfig != null) {
            this.sqlInjectionConfig = (SQLInjectionScanConfig)((SecurityScanConfig)this.getConfig()).getConfig();
        }
    }

    public JComponent getComponent() {
        JPanel p = UISupport.createEmptyPanel(5, 75, 0, 5);
        p.add(new JLabel("Strings for SQL injection can be changed under advanced settings"));
        return p;
    }

    public String getType() {
        return TYPE;
    }

    protected void execute(SecurityTestRunner securityTestRunner, TestStep testStep, SecurityTestRunContext context) {
        try {
            StringToStringMap updatedParams = this.update(testStep, context);
            MessageExchange message = (MessageExchange)((Object)testStep.run((TestCaseRunner)((Object)securityTestRunner), context));
            this.createMessageExchange(updatedParams, message, context);
        }
        catch (XmlException e) {
            SoapUI.logError(e, "[SqlInjectionSecurityScan]XPath seems to be invalid!");
            this.reportSecurityScanException("Property value is not XML or XPath is wrong!");
        }
        catch (Exception e) {
            SoapUI.logError(e, "[SqlInjectionSecurityScan]Property value is not valid xml!");
            this.reportSecurityScanException("Property value is not XML or XPath is wrong!");
        }
    }

    private StringToStringMap update(TestStep testStep, SecurityTestRunContext context) throws XmlException, Exception {
        StringToStringMap params = new StringToStringMap();
        if (this.parameterMutations.size() == 0) {
            this.mutateParameters(testStep, context);
        }
        if (this.getExecutionStrategy().getStrategy() == StrategyTypeConfig.ONE_BY_ONE) {
            for (SecurityCheckedParameter param : this.getParameterHolder().getParameterList()) {
                if (!this.parameterMutations.containsKey(param) || this.parameterMutations.get(param).size() <= 0) continue;
                TestProperty property = this.getTestStep().getProperties().get(param.getName());
                String value = context.expand(property.getValue());
                if (param.getXpath() == null || param.getXpath().trim().length() == 0) {
                    testStep.getProperties().get(param.getName()).setValue(this.parameterMutations.get(param).get(0));
                    params.put(param.getLabel(), this.parameterMutations.get(param).get(0));
                    this.parameterMutations.get(param).remove(0);
                } else {
                    XmlObjectTreeModel.XmlTreeNode[] nodes;
                    if (value == null || value.trim().equals("")) continue;
                    XmlObjectTreeModel model = new XmlObjectTreeModel(property.getSchemaType().getTypeSystem(), XmlUtils.createXmlObject(value));
                    for (XmlObjectTreeModel.XmlTreeNode node : nodes = model.selectTreeNodes(context.expand(param.getXpath()))) {
                        node.setValue(1, this.parameterMutations.get(param).get(0));
                    }
                    params.put(param.getLabel(), this.parameterMutations.get(param).get(0));
                    this.parameterMutations.get(param).remove(0);
                    testStep.getProperties().get(param.getName()).setValue(model.getXmlObject().toString());
                }
                break;
            }
        } else {
            for (TestProperty property : testStep.getPropertyList()) {
                String value = context.expand(property.getValue());
                if (!XmlUtils.seemsToBeXml(value)) continue;
                XmlObjectTreeModel model = null;
                model = new XmlObjectTreeModel(property.getSchemaType().getTypeSystem(), XmlUtils.createXmlObject(value));
                for (SecurityCheckedParameter param : this.getParameterHolder().getParameterList()) {
                    if (!param.isChecked()) continue;
                    if (param.getXpath() == null || param.getXpath().trim().length() == 0) {
                        if (!this.parameterMutations.containsKey(param)) continue;
                        testStep.getProperties().get(param.getName()).setValue(this.parameterMutations.get(param).get(0));
                        params.put(param.getLabel(), this.parameterMutations.get(param).get(0));
                        this.parameterMutations.get(param).remove(0);
                        continue;
                    }
                    if (value == null || value.trim().equals("") || !param.getName().equals(property.getName())) continue;
                    XmlObjectTreeModel.XmlTreeNode[] nodes = model.selectTreeNodes(context.expand(param.getXpath()));
                    if (!this.parameterMutations.containsKey(param) || this.parameterMutations.get(param).size() <= 0) continue;
                    for (XmlObjectTreeModel.XmlTreeNode node : nodes) {
                        node.setValue(1, this.parameterMutations.get(param).get(0));
                    }
                    params.put(param.getLabel(), this.parameterMutations.get(param).get(0));
                    this.parameterMutations.get(param).remove(0);
                }
                if (model == null) continue;
                property.setValue(model.getXmlObject().toString());
            }
        }
        return params;
    }

    private void mutateParameters(TestStep testStep, SecurityTestRunContext context) throws XmlException, Exception {
        this.mutation = true;
        for (SecurityCheckedParameter parameter : this.getParameterHolder().getParameterList()) {
            if (!parameter.isChecked()) continue;
            TestProperty property = testStep.getProperties().get(parameter.getName());
            if (parameter.getXpath() == null || parameter.getXpath().trim().length() == 0) {
                for (String sqlInjectionString : this.sqlInjectionConfig.getSqlInjectionStringsList()) {
                    if (!this.parameterMutations.containsKey(parameter)) {
                        this.parameterMutations.put(parameter, new ArrayList());
                    }
                    this.parameterMutations.get(parameter).add(sqlInjectionString);
                }
                continue;
            }
            if (property.getValue() == null && property.getDefaultValue() == null) continue;
            String value = context.expand(property.getValue());
            XmlObjectTreeModel model = null;
            model = new XmlObjectTreeModel(property.getSchemaType().getTypeSystem(), XmlUtils.createXmlObject(value));
            XmlObjectTreeModel.XmlTreeNode[] nodes = model.selectTreeNodes(context.expand(parameter.getXpath()));
            for (String sqlInjectionString : this.sqlInjectionConfig.getSqlInjectionStringsList()) {
                if (nodes.length <= 0) continue;
                if (!this.parameterMutations.containsKey(parameter)) {
                    this.parameterMutations.put(parameter, new ArrayList());
                }
                this.parameterMutations.get(parameter).add(sqlInjectionString);
            }
        }
    }

    protected boolean hasNext(TestStep testStep, SecurityTestRunContext context) {
        boolean hasNext = false;
        if (!(this.parameterMutations != null && this.parameterMutations.size() != 0 || this.mutation)) {
            hasNext = this.getParameterHolder().getParameterList().size() > 0;
        } else {
            for (SecurityCheckedParameter param : this.parameterMutations.keySet()) {
                if (this.parameterMutations.get(param).size() <= 0) continue;
                hasNext = true;
                break;
            }
        }
        if (!hasNext) {
            this.parameterMutations.clear();
            this.mutation = false;
        }
        return hasNext;
    }

    public String getConfigDescription() {
        return "Configures SQL injection security scan";
    }

    public String getConfigName() {
        return "SQL Injection Security Scan";
    }

    public String getHelpURL() {
        return "http://soapui.org/Security/sql-injection.html";
    }

    public JComponent getAdvancedSettingsPanel() {
        this.dialog = (JFormDialog)ADialogBuilder.buildDialog(AdvancedSettings.class);
        JStringListFormField stringField = (JStringListFormField)this.dialog.getFormField("###Injection Strings");
        stringField.setOptions(this.sqlInjectionConfig.getSqlInjectionStringsList().toArray());
        stringField.setProperty("dimension", new Dimension(470, 150));
        ((StringListFormComponent)stringField.getComponent()).addPropertyChangeListener("options", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String[] newOptions = (String[])evt.getNewValue();
                String[] oldOptions = (String[])evt.getOldValue();
                SQLInjectionScan.this.sqlInjectionConfig.setSqlInjectionStringsArray(newOptions);
            }
        });
        return this.dialog.getPanel();
    }

    public void release() {
        if (this.dialog != null) {
            this.dialog.release();
        }
        super.release();
    }

    protected void clear() {
        this.parameterMutations.clear();
        this.mutation = false;
    }

    @AForm(description="SQL Injection Strings", name="SQL Injection Strings")
    protected static interface AdvancedSettings {
        @AField(description="SQL Strings", name="###Injection Strings", type=AField.AFieldType.STRINGLIST)
        public static final String INJECTION_STRINGS = "###Injection Strings";
    }
}

