/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.ui;

import com.eviware.soapui.config.InvalidSecurityScanConfig;
import com.eviware.soapui.config.SchemaTypeForSecurityScanConfig;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.impl.swing.JComboBoxFormField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.swingx.JXTable;

public class InvalidTypesTable
extends JPanel {
    private InvalidTypeTableModel model;
    private JXTable table;
    private JXToolBar toolbar;
    private Map<String, Integer> typeMap = new HashMap<String, Integer>(){
        {
            this.put("STRING", 12);
            this.put("NORMALIZED_STRING", 35);
            this.put("TOKEN", 36);
            this.put("BASE_64_BINARY", 4);
            this.put("HEX_BINARY", 5);
            this.put("INTEGER", 22);
            this.put("POSITIVE_INTEGER", 30);
            this.put("NEGATIVE_INTEGER", 28);
            this.put("NON_NEGATIVE_INTEGER", 29);
            this.put("NON_POSITIVE_INTEGER", 30);
            this.put("LONG", 23);
            this.put("UNSIGNED_LONG", 31);
            this.put("UNSIGNED_INT", 32);
            this.put("SHORT", 25);
            this.put("UNSIGNED_SHORT", 33);
            this.put("BYTE", 26);
            this.put("UNSIGNED_BYTE", 34);
            this.put("DECIMAL", 11);
            this.put("FLOAT", 9);
            this.put("BOOLEAN", 3);
            this.put("DURATION", 13);
            this.put("DATE_TIME", 14);
            this.put("DATE", 16);
            this.put("TIME", 15);
            this.put("G_YEAR", 18);
            this.put("G_YEAR_MONTH", 17);
            this.put("G_MONTH", 21);
            this.put("G_MONTH_DAY", 19);
            this.put("G_DAY", 20);
        }
    };

    public InvalidTypesTable(InvalidSecurityScanConfig invalidTypeConfig) {
        this.model = new InvalidTypeTableModel(invalidTypeConfig);
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.toolbar = UISupport.createToolbar();
        this.toolbar.add(UISupport.createToolbarButton(new AddNewTypeAction()));
        this.toolbar.add(UISupport.createToolbarButton(new RemoveTypeAction()));
        this.toolbar.addGlue();
        this.add((Component)this.toolbar, "North");
        this.table = new JXTable((TableModel)this.model);
        TableRowSorter<InvalidTypeTableModel> sorter = new TableRowSorter<InvalidTypeTableModel>(this.model);
        this.table.setRowSorter(sorter);
        this.table.toggleSortOrder(0);
        this.add((Component)new JScrollPane((Component)this.table), "Center");
        this.setPreferredSize(new Dimension(100, 200));
    }

    @AForm(description="Add new type", name="Add new type", helpUrl="http://www.soapui.org/Security/security-scans-overview.html")
    protected static interface AddParameterActionDialog {
        @AField(description="Choose Type", name="Choose type", type=AField.AFieldType.ENUMERATION)
        public static final String TYPE = "Choose type";
        @AField(description="Set a value", name="Value", type=AField.AFieldType.STRING)
        public static final String VALUE = "Value";
    }

    private class InvalidTypeTableModel
    extends AbstractTableModel {
        private InvalidSecurityScanConfig data;
        private String[] columns = new String[]{"Type Name", "Type Value"};

        public InvalidTypeTableModel(InvalidSecurityScanConfig invalidTypeConfig) {
            this.data = invalidTypeConfig;
        }

        public void removeRows(int[] selectedRows) {
            ArrayList<SchemaTypeForSecurityScanConfig> toRemove = new ArrayList<SchemaTypeForSecurityScanConfig>();
            for (int i = 0; i < selectedRows.length; ++i) {
                selectedRows[i] = InvalidTypesTable.this.table.convertRowIndexToModel(selectedRows[i]);
            }
            for (int index : selectedRows) {
                toRemove.add(this.data.getTypesListList().get(index));
            }
            this.data.getTypesListList().removeAll(toRemove);
            this.fireTableDataChanged();
        }

        public void addNewType(int type, String value) {
            SchemaTypeForSecurityScanConfig newtype = this.data.addNewTypesList();
            newtype.setType(type);
            newtype.setValue(value);
            this.fireTableDataChanged();
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            SchemaTypeForSecurityScanConfig paramType = this.data.getTypesListList().get(rowIndex);
            paramType.setValue((String)aValue);
            this.fireTableDataChanged();
        }

        public String getColumnName(int column) {
            return this.columns[column];
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            if (this.data.getTypesListList() == null) {
                return 0;
            }
            return this.data.getTypesListList().size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.getTypeName(this.data.getTypesListList().get(rowIndex).getType());
            }
            return this.data.getTypesListList().get(rowIndex).getValue();
        }

        private String getTypeName(int type) {
            String result = "UNKNOWN";
            switch (type) {
                case 12: {
                    return "STRING";
                }
                case 35: {
                    return "NORMALIZED_STRING";
                }
                case 36: {
                    return "TOKEN";
                }
                case 4: {
                    return "BASE_64_BINARY";
                }
                case 5: {
                    return "HEX_BINARY";
                }
                case 22: {
                    return "INTEGER";
                }
                case 30: {
                    return "POSITIVE_INTEGER";
                }
                case 28: {
                    return "NEGATIVE_INTEGER";
                }
                case 29: {
                    return "NON_NEGATIVE_INTEGER";
                }
                case 27: {
                    return "NON_POSITIVE_INTEGER";
                }
                case 23: {
                    return "LONG";
                }
                case 31: {
                    return "UNSIGNED_LONG";
                }
                case 24: {
                    return "INT";
                }
                case 32: {
                    return "UNSIGNED_INT";
                }
                case 25: {
                    return "SHORT";
                }
                case 33: {
                    return "UNSIGNED_SHORT";
                }
                case 26: {
                    return "BYTE";
                }
                case 34: {
                    return "UNSIGNED_BYTE";
                }
                case 11: {
                    return "DECIMAL";
                }
                case 9: {
                    return "FLOAT";
                }
                case 10: {
                    return "DOUBLE";
                }
                case 3: {
                    return "BOOLEAN";
                }
                case 13: {
                    return "DURATION";
                }
                case 14: {
                    return "DATE_TIME";
                }
                case 16: {
                    return "DATE";
                }
                case 15: {
                    return "TIME";
                }
                case 18: {
                    return "G_YEAR";
                }
                case 17: {
                    return "G_YEAR_MONTH";
                }
            }
            return result;
        }
    }

    private class AddNewTypeAction
    extends AbstractAction {
        public AddNewTypeAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
            this.putValue("ShortDescription", "Adds new type to use in security scan");
        }

        public void actionPerformed(ActionEvent arg0) {
            XFormDialog dialog = ADialogBuilder.buildDialog(AddParameterActionDialog.class);
            JComboBoxFormField chooser = (JComboBoxFormField)dialog.getFormField("Choose type");
            chooser.setOptions(InvalidTypesTable.this.typeMap.keySet().toArray(new String[0]));
            if (dialog.show()) {
                InvalidTypesTable.this.model.addNewType((Integer)InvalidTypesTable.this.typeMap.get(chooser.getValue()), dialog.getValue("Value"));
            }
        }
    }

    private class RemoveTypeAction
    extends AbstractAction {
        public RemoveTypeAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_property.gif"));
            this.putValue("ShortDescription", "Removes type from security scan");
        }

        public void actionPerformed(ActionEvent e) {
            InvalidTypesTable.this.model.removeRows(InvalidTypesTable.this.table.getSelectedRows());
        }
    }
}

