/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.action.swing;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.action.SoapUIAction;
import com.eviware.soapui.support.action.SoapUIActionGroup;
import com.eviware.soapui.support.action.SoapUIActionMapping;
import com.eviware.soapui.support.action.SoapUIActionRegistry;
import com.eviware.soapui.support.action.SoapUIMultiAction;
import com.eviware.soapui.support.action.support.SoapUIActionMappingList;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.ActionSupport;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.action.swing.SwingMultiActionDelegate;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionListBuilder {
    public static <T extends ModelItem> ActionList buildActions(T modelItem) {
        return ActionListBuilder.buildActions(modelItem, "");
    }

    public static <T extends ModelItem> ActionList buildActions(T modelItem, String suffix) {
        Class<?> clazz = modelItem.getClass();
        ActionList actions = ActionListBuilder.buildActions(clazz.getSimpleName() + suffix + "Actions", modelItem);
        if (actions.getActionCount() == 0) {
            for (clazz = clazz.getSuperclass(); actions.getActionCount() == 0 && clazz != null && ModelItem.class.isAssignableFrom(clazz); clazz = clazz.getSuperclass()) {
                actions = ActionListBuilder.buildActions(clazz.getSimpleName() + suffix + "Actions", modelItem);
            }
        }
        return actions;
    }

    public static <T extends ModelItem> ActionList buildActions(String actionGroup, T modelItem) {
        DefaultActionList actions = new DefaultActionList();
        SoapUIActionGroup group = SoapUI.getActionRegistry().getActionGroup(actionGroup);
        if (group != null) {
            ActionListBuilder.addActions(modelItem, actions, group);
        }
        return actions;
    }

    protected static <T extends ModelItem> void addActions(T modelItem, ActionList actions, SoapUIActionGroup<T> actionGroup) {
        boolean prevWasSeparator = false;
        for (SoapUIActionMapping soapUIActionMapping : actionGroup.getActionMappings(modelItem)) {
            if (soapUIActionMapping == null) continue;
            SoapUIActionMapping actionMapping = soapUIActionMapping;
            SoapUIAction<T> action = soapUIActionMapping.getAction();
            if (action != null && !action.applies(modelItem)) {
                System.out.println(action + " does not apply to " + modelItem);
                continue;
            }
            if (action instanceof SoapUIActionRegistry.SeperatorAction) {
                if (!prevWasSeparator) {
                    actions.addAction(ActionSupport.SEPARATOR_ACTION);
                }
                prevWasSeparator = true;
                continue;
            }
            if (action instanceof SoapUIActionRegistry.SoapUIActionGroupAction) {
                DefaultActionList subActions = new DefaultActionList(soapUIActionMapping.getName());
                SoapUIActionGroup subGroup = ((SoapUIActionRegistry.SoapUIActionGroupAction)action).getActionGroup();
                ActionListBuilder.addActions(modelItem, subActions, subGroup);
                ActionSupport.ActionListAction actionListAction = new ActionSupport.ActionListAction(subActions);
                actions.addAction(actionListAction);
                actionListAction.setEnabled(soapUIActionMapping.isEnabled());
                prevWasSeparator = false;
                continue;
            }
            if (action == null) continue;
            SwingActionDelegate<T> actionDelegate = new SwingActionDelegate<T>(actionMapping, modelItem);
            actions.addAction(actionDelegate);
            if (soapUIActionMapping.isDefault()) {
                actions.setDefaultAction(actionDelegate);
            }
            actionDelegate.setEnabled(soapUIActionMapping.isEnabled());
            prevWasSeparator = false;
        }
    }

    public static ActionList buildMultiActions(ModelItem[] modelItems) {
        DefaultActionList actions = new DefaultActionList();
        SoapUIActionGroup group = SoapUI.getActionRegistry().getActionGroup("SoapUIMultiActions");
        if (group != null) {
            ActionListBuilder.addMultiActions(modelItems, actions, group);
        }
        return actions;
    }

    protected static void addMultiActions(ModelItem[] modelItems, ActionList actions, SoapUIActionGroup actionGroup) {
        boolean prevWasSeparator = false;
        SoapUIActionMappingList<Object> actionMappings = actionGroup.getActionMappings(null);
        for (int c = 0; c < actionMappings.size(); ++c) {
            SoapUIActionMapping mapping = (SoapUIActionMapping)actionMappings.get(c);
            if (mapping == null) continue;
            SoapUIAction<ModelItem> action = mapping.getAction();
            if (action instanceof SoapUIActionRegistry.SeperatorAction) {
                if (!prevWasSeparator) {
                    actions.addAction(ActionSupport.SEPARATOR_ACTION);
                }
                prevWasSeparator = true;
                continue;
            }
            if (action instanceof SoapUIActionRegistry.SoapUIActionGroupAction) {
                DefaultActionList subActions = new DefaultActionList(mapping.getName());
                SoapUIActionGroup subGroup = ((SoapUIActionRegistry.SoapUIActionGroupAction)action).getActionGroup();
                ActionListBuilder.addMultiActions(modelItems, subActions, subGroup);
                ActionSupport.ActionListAction actionListAction = new ActionSupport.ActionListAction(subActions);
                actions.addAction(actionListAction);
                actionListAction.setEnabled(mapping.isEnabled());
                prevWasSeparator = false;
                continue;
            }
            if (!(action instanceof SoapUIMultiAction)) continue;
            ArrayList<ModelItem> targets = new ArrayList<ModelItem>();
            for (ModelItem target : modelItems) {
                if (!action.applies(target)) continue;
                targets.add(target);
            }
            if (targets.size() <= 0) continue;
            SwingMultiActionDelegate actionDelegate = new SwingMultiActionDelegate(mapping, modelItems);
            actions.addAction(actionDelegate);
            if (mapping.isDefault()) {
                actions.setDefaultAction(actionDelegate);
            }
            actionDelegate.setEnabled(mapping.isEnabled());
            prevWasSeparator = false;
        }
    }
}

