/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.attachments;

import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.wsdl.AttachmentContainer;
import com.eviware.soapui.impl.wsdl.HttpAttachmentPart;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.support.MessageExchangeModelItem;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.MessagePart;
import com.eviware.soapui.support.editor.Editor;
import com.eviware.soapui.support.editor.EditorInspector;
import com.eviware.soapui.support.editor.inspectors.attachments.AttachmentsInspector;
import com.eviware.soapui.support.editor.registry.RequestInspectorFactory;
import com.eviware.soapui.support.editor.registry.ResponseInspectorFactory;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentsInspectorFactory
implements RequestInspectorFactory,
ResponseInspectorFactory {
    public static final String INSPECTOR_ID = "Attachments";

    @Override
    public String getInspectorId() {
        return INSPECTOR_ID;
    }

    @Override
    public EditorInspector<?> createRequestInspector(Editor<?> editor, ModelItem modelItem) {
        if (modelItem instanceof AbstractHttpRequestInterface) {
            return new AttachmentsInspector((AttachmentContainer)((Object)modelItem));
        }
        if (modelItem instanceof WsdlMockResponse) {
            return new AttachmentsInspector(new MockRequestAttachmentsContainer((WsdlMockResponse)modelItem));
        }
        if (modelItem instanceof MessageExchangeModelItem) {
            return new AttachmentsInspector(new WsdlMessageExchangeRequestAttachmentsContainer((MessageExchangeModelItem)modelItem));
        }
        return null;
    }

    @Override
    public EditorInspector<?> createResponseInspector(Editor<?> editor, ModelItem modelItem) {
        if (modelItem instanceof AbstractHttpRequestInterface) {
            return new AttachmentsInspector(new ResponseAttachmentsContainer((AbstractHttpRequest)modelItem));
        }
        if (modelItem instanceof WsdlMockResponse) {
            return new AttachmentsInspector((WsdlMockResponse)modelItem);
        }
        if (modelItem instanceof MessageExchangeModelItem) {
            return new AttachmentsInspector(new WsdlMessageExchangeResponseAttachmentsContainer((MessageExchangeModelItem)modelItem));
        }
        return null;
    }

    protected static class MockRequestAttachmentsContainer
    implements AttachmentContainer {
        private final WsdlMockResponse mockResponse;

        public MockRequestAttachmentsContainer(WsdlMockResponse mockResponse) {
            this.mockResponse = mockResponse;
        }

        public void addAttachmentsChangeListener(PropertyChangeListener listener) {
            this.mockResponse.addPropertyChangeListener(WsdlMockResponse.MOCKRESULT_PROPERTY, listener);
        }

        public Attachment getAttachmentAt(int index) {
            return this.mockResponse.getMockResult() == null ? null : this.mockResponse.getMockResult().getMockRequest().getRequestAttachments()[index];
        }

        public int getAttachmentCount() {
            return this.mockResponse.getMockResult() == null ? 0 : this.mockResponse.getMockResult().getMockRequest().getRequestAttachments().length;
        }

        public HttpAttachmentPart getAttachmentPart(String partName) {
            return null;
        }

        public Attachment[] getAttachments() {
            return this.mockResponse.getMockResult() == null ? null : this.mockResponse.getMockResult().getMockRequest().getRequestAttachments();
        }

        public Attachment[] getAttachmentsForPart(String partName) {
            return null;
        }

        public ModelItem getModelItem() {
            return this.mockResponse;
        }

        public HttpAttachmentPart[] getDefinedAttachmentParts() {
            MessagePart[] responseParts = this.mockResponse.getRequestParts();
            ArrayList<HttpAttachmentPart> result = new ArrayList<HttpAttachmentPart>();
            for (MessagePart part : responseParts) {
                if (!(part instanceof HttpAttachmentPart)) continue;
                result.add((HttpAttachmentPart)part);
            }
            return result.toArray(new HttpAttachmentPart[result.size()]);
        }

        public boolean isMultipartEnabled() {
            return this.mockResponse.isMultipartEnabled();
        }

        public void removeAttachmentsChangeListener(PropertyChangeListener listener) {
            this.mockResponse.removePropertyChangeListener(WsdlMockResponse.MOCKRESULT_PROPERTY, listener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ResponseAttachmentsContainer
    implements AttachmentContainer {
        private final AbstractHttpRequest<?> request;

        public ResponseAttachmentsContainer(AbstractHttpRequest<?> abstractHttpRequest) {
            this.request = abstractHttpRequest;
        }

        @Override
        public void addAttachmentsChangeListener(PropertyChangeListener listener) {
            this.request.addPropertyChangeListener(WsdlRequest.RESPONSE_PROPERTY, listener);
        }

        @Override
        public Attachment getAttachmentAt(int index) {
            return this.request.getResponse() == null ? null : this.request.getResponse().getAttachments()[index];
        }

        @Override
        public int getAttachmentCount() {
            return this.request.getResponse() == null ? 0 : this.request.getResponse().getAttachments().length;
        }

        @Override
        public HttpAttachmentPart getAttachmentPart(String partName) {
            return null;
        }

        @Override
        public ModelItem getModelItem() {
            return this.request;
        }

        @Override
        public Attachment[] getAttachments() {
            return this.request.getResponse() == null ? null : this.request.getResponse().getAttachments();
        }

        @Override
        public Attachment[] getAttachmentsForPart(String partName) {
            return this.request.getResponse() == null ? null : this.request.getResponse().getAttachmentsForPart(partName);
        }

        public HttpAttachmentPart[] getDefinedAttachmentParts() {
            MessagePart[] responseParts = this.request.getResponseParts();
            ArrayList<HttpAttachmentPart> result = new ArrayList<HttpAttachmentPart>();
            for (MessagePart part : responseParts) {
                if (!(part instanceof HttpAttachmentPart)) continue;
                result.add((HttpAttachmentPart)part);
            }
            return result.toArray(new HttpAttachmentPart[result.size()]);
        }

        @Override
        public boolean isMultipartEnabled() {
            return this.request.isMultipartEnabled();
        }

        @Override
        public void removeAttachmentsChangeListener(PropertyChangeListener listener) {
            this.request.removePropertyChangeListener(WsdlRequest.RESPONSE_PROPERTY, listener);
        }
    }

    protected static class WsdlMessageExchangeResponseAttachmentsContainer
    implements AttachmentContainer {
        private final MessageExchangeModelItem response;

        public WsdlMessageExchangeResponseAttachmentsContainer(MessageExchangeModelItem response) {
            this.response = response;
        }

        public void addAttachmentsChangeListener(PropertyChangeListener listener) {
            this.response.addPropertyChangeListener(listener);
        }

        public Attachment getAttachmentAt(int index) {
            return this.response.getMessageExchange() == null || this.response.getMessageExchange().getResponseAttachments() == null ? null : this.response.getMessageExchange().getResponseAttachments()[index];
        }

        public int getAttachmentCount() {
            return this.response.getMessageExchange() == null || this.response.getMessageExchange().getResponseAttachments() == null ? 0 : this.response.getMessageExchange().getResponseAttachments().length;
        }

        public HttpAttachmentPart getAttachmentPart(String partName) {
            return null;
        }

        public ModelItem getModelItem() {
            return this.response.getParent();
        }

        public Attachment[] getAttachments() {
            return this.response.getMessageExchange() == null ? null : this.response.getMessageExchange().getResponseAttachments();
        }

        public Attachment[] getAttachmentsForPart(String partName) {
            return this.response.getMessageExchange() == null ? null : this.response.getMessageExchange().getResponseAttachmentsForPart(partName);
        }

        public HttpAttachmentPart[] getDefinedAttachmentParts() {
            if (this.response.getMessageExchange() == null || this.response.getMessageExchange().getOperation() == null) {
                return new HttpAttachmentPart[0];
            }
            MessagePart[] responseParts = this.response.getMessageExchange().getOperation().getDefaultResponseParts();
            ArrayList<HttpAttachmentPart> result = new ArrayList<HttpAttachmentPart>();
            for (MessagePart part : responseParts) {
                if (!(part instanceof HttpAttachmentPart)) continue;
                result.add((HttpAttachmentPart)part);
            }
            return result.toArray(new HttpAttachmentPart[result.size()]);
        }

        public boolean isMultipartEnabled() {
            return false;
        }

        public void removeAttachmentsChangeListener(PropertyChangeListener listener) {
            this.response.removePropertyChangeListener(listener);
        }
    }

    protected static class WsdlMessageExchangeRequestAttachmentsContainer
    implements AttachmentContainer {
        private final MessageExchangeModelItem request;

        public WsdlMessageExchangeRequestAttachmentsContainer(MessageExchangeModelItem request) {
            this.request = request;
        }

        public void addAttachmentsChangeListener(PropertyChangeListener listener) {
            this.request.addPropertyChangeListener(listener);
        }

        public Attachment getAttachmentAt(int index) {
            return this.request.getMessageExchange() == null ? null : this.request.getMessageExchange().getRequestAttachments()[index];
        }

        public int getAttachmentCount() {
            return this.request.getMessageExchange() == null ? 0 : (this.request.getMessageExchange().getRequestAttachments() == null ? 0 : this.request.getMessageExchange().getRequestAttachments().length);
        }

        public HttpAttachmentPart getAttachmentPart(String partName) {
            return null;
        }

        public ModelItem getModelItem() {
            return this.request.getParent();
        }

        public Attachment[] getAttachments() {
            return this.request.getMessageExchange() == null ? null : this.request.getMessageExchange().getRequestAttachments();
        }

        public Attachment[] getAttachmentsForPart(String partName) {
            return this.request.getMessageExchange() == null ? null : this.request.getMessageExchange().getRequestAttachmentsForPart(partName);
        }

        public HttpAttachmentPart[] getDefinedAttachmentParts() {
            if (this.request.getMessageExchange() == null || this.request.getMessageExchange().getOperation() == null) {
                return new HttpAttachmentPart[0];
            }
            MessagePart[] responseParts = this.request.getMessageExchange().getOperation().getDefaultRequestParts();
            ArrayList<HttpAttachmentPart> result = new ArrayList<HttpAttachmentPart>();
            for (MessagePart part : responseParts) {
                if (!(part instanceof HttpAttachmentPart)) continue;
                result.add((HttpAttachmentPart)part);
            }
            return result.toArray(new HttpAttachmentPart[result.size()]);
        }

        public boolean isMultipartEnabled() {
            return false;
        }

        public void removeAttachmentsChangeListener(PropertyChangeListener listener) {
            this.request.removePropertyChangeListener(listener);
        }
    }
}

