/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.attachments;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.AttachmentContainer;
import com.eviware.soapui.impl.wsdl.MutableAttachmentContainer;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.impl.wsdl.support.WsdlAttachment;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.MessagePart;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.editor.inspectors.attachments.AttachmentsTableModel;
import com.eviware.soapui.support.editor.inspectors.attachments.ContentTypeHandler;
import com.eviware.soapui.support.editor.inspectors.attachments.FileTransferHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AttachmentsPanel
extends JPanel {
    private DropTarget dropTarget;
    private FileTransferHandler fileTransferHandler;
    private AttachmentsTableModel tableModel;
    private JFileChooser fc;
    private final AttachmentContainer container;
    private JButton exportBtn;
    private JButton reloadBtn;
    private JButton addFileBtn;
    private JTable fileTable;
    private JXToolBar jPanel1;
    private JScrollPane jScrollPane1;
    private JButton removeBtn;
    private AttachmentPartCellEditor attachmentPartCellEditor;

    public AttachmentsPanel(AttachmentContainer container) {
        this.container = container;
        this.initComponents();
        this.initFileTransfer();
    }

    public void release() {
        this.tableModel.release();
        if (this.attachmentPartCellEditor != null) {
            this.attachmentPartCellEditor.release();
        }
    }

    private void initFileTransfer() {
        if (this.container instanceof MutableAttachmentContainer) {
            this.fileTransferHandler = new FileTransferHandler(this.tableModel);
            this.fileTable.setDragEnabled(true);
            this.fileTable.setTransferHandler(this.fileTransferHandler);
            this.dropTarget = new DropTarget();
            this.dropTarget.setActive(true);
            try {
                this.dropTarget.addDropTargetListener(new DropTargetListener(){

                    public void dragEnter(DropTargetDragEvent dtde) {
                    }

                    public void dragExit(DropTargetEvent dte) {
                    }

                    public void dragOver(DropTargetDragEvent dtde) {
                    }

                    public void drop(DropTargetDropEvent dtde) {
                        try {
                            dtde.acceptDrop(3);
                            Transferable trans = dtde.getTransferable();
                            List files = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
                            for (File f : files) {
                                System.out.println("Dropping file: " + f.getName());
                                Boolean retval = UISupport.confirmOrCancel("Cache attachment in request?", "Att Attachment");
                                if (retval == null) {
                                    return;
                                }
                                AttachmentsPanel.this.tableModel.addFile(f, retval);
                            }
                        }
                        catch (Exception e) {
                            SoapUI.logError(e);
                        }
                    }

                    public void dropActionChanged(DropTargetDragEvent dtde) {
                    }
                });
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
            this.jScrollPane1.getViewport().setDropTarget(this.dropTarget);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tableModel = new AttachmentsTableModel(this.container);
        this.fileTable = new JTable(this.tableModel);
        if (this.container instanceof MutableAttachmentContainer) {
            this.attachmentPartCellEditor = new AttachmentPartCellEditor();
            this.fileTable.getColumnModel().getColumn(3).setCellEditor(this.attachmentPartCellEditor);
        }
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.fileTable);
        this.add((Component)this.jScrollPane1, "Center");
        this.jPanel1 = UISupport.createSmallToolbar();
        if (this.container instanceof MutableAttachmentContainer) {
            this.addFileBtn = UISupport.createToolbarButton(UISupport.createImageIcon("/add_property.gif"));
            this.removeBtn = UISupport.createToolbarButton(UISupport.createImageIcon("/remove_property.gif"));
            this.reloadBtn = UISupport.createToolbarButton(UISupport.createImageIcon("/reload_properties.gif"));
            this.addFileBtn.setToolTipText("Adds an attachment");
            this.addFileBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    AttachmentsPanel.this.addFileBtnActionPerformed(evt);
                }
            });
            this.jPanel1.addFixed(this.addFileBtn);
            this.removeBtn.setToolTipText("Removes the selected attachment");
            this.removeBtn.setEnabled(false);
            this.removeBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    AttachmentsPanel.this.removeBtnActionPerformed(evt);
                }
            });
            this.jPanel1.addFixed(this.removeBtn);
            this.reloadBtn.setToolTipText("Reloads the selected attachment");
            this.reloadBtn.setEnabled(false);
            this.reloadBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    AttachmentsPanel.this.reloadBtnActionPerformed(evt);
                }
            });
            this.jPanel1.addFixed(this.reloadBtn);
        }
        this.exportBtn = UISupport.createToolbarButton(UISupport.createImageIcon("/export.gif"));
        this.exportBtn.setToolTipText("Exports the selected attachment to a file");
        this.exportBtn.setEnabled(false);
        this.exportBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttachmentsPanel.this.exportBtnActionPerformed(evt);
            }
        });
        this.jPanel1.addFixed(this.exportBtn);
        this.jPanel1.addGlue();
        this.jPanel1.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/attachments.html")));
        this.add((Component)this.jPanel1, "North");
        this.fileTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (AttachmentsPanel.this.removeBtn != null) {
                    AttachmentsPanel.this.removeBtn.setEnabled(AttachmentsPanel.this.fileTable.getSelectedRowCount() > 0);
                    AttachmentsPanel.this.reloadBtn.setEnabled(AttachmentsPanel.this.fileTable.getSelectedRowCount() > 0);
                }
                AttachmentsPanel.this.exportBtn.setEnabled(AttachmentsPanel.this.fileTable.getSelectedRowCount() > 0);
            }
        });
        this.fileTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                int ix = AttachmentsPanel.this.fileTable.getSelectedRow();
                if (ix == -1) {
                    return;
                }
                Attachment attachment = AttachmentsPanel.this.container.getAttachmentAt(ix);
                if (attachment.isCached()) {
                    String name = attachment.getName();
                    try {
                        name = StringUtils.createFileName(name, '-');
                        File tempFile = File.createTempFile("attachment-" + name, "." + ContentTypeHandler.getExtensionForContentType(attachment.getContentType()));
                        AttachmentsPanel.this.exportAttachment(tempFile, attachment, false);
                    }
                    catch (Exception e1) {
                        UISupport.showErrorMessage(e1);
                    }
                } else {
                    Tools.openURL(attachment.getUrl());
                }
            }
        });
    }

    protected void exportBtnActionPerformed(ActionEvent evt) {
        File file = UISupport.getFileDialogs().saveAs(this, "Export Attachment..");
        while (file != null && file.exists() && !UISupport.confirm("File " + file.getName() + " exists, overwrite?", "Export Attachment")) {
            file = UISupport.getFileDialogs().saveAs(this, "Export Attachment..");
        }
        if (file != null) {
            Attachment attachment = this.tableModel.getAttachmentAt(this.fileTable.getSelectedRow());
            try {
                this.exportAttachment(file, attachment, true);
            }
            catch (Exception e) {
                UISupport.showErrorMessage(e);
            }
        }
    }

    private void exportAttachment(File file, Attachment attachment, boolean showOpenQuery) throws FileNotFoundException, IOException, Exception, MalformedURLException {
        FileOutputStream out = new FileOutputStream(file);
        long total = Tools.writeAll(out, attachment.getInputStream());
        out.close();
        if (!showOpenQuery || UISupport.confirm("Written [" + total + "] bytes to " + file.getName() + ", open in browser?", "Saved File")) {
            Tools.openURL(file.toURI().toURL().toString());
        }
    }

    protected void reloadBtnActionPerformed(ActionEvent evt) {
        int selectedRow = this.fileTable.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        WsdlAttachment attachment = (WsdlAttachment)this.tableModel.getAttachmentAt(selectedRow);
        if (attachment == null) {
            return;
        }
        File file = UISupport.getFileDialogs().open(this, "Reload Attachment..", "*", "Any File", attachment.getUrl());
        if (file != null) {
            Boolean retval = UISupport.confirmOrCancel("Cache attachment in request?", "Reload Attachment");
            if (retval == null) {
                return;
            }
            try {
                attachment.reload(file, retval);
                this.tableModel.fireTableRowsUpdated(selectedRow, selectedRow);
            }
            catch (IOException e) {
                UISupport.showErrorMessage(e);
            }
        }
    }

    private void addFileBtnActionPerformed(ActionEvent evt) {
        int returnVal;
        String root;
        if (this.fc == null) {
            this.fc = new JFileChooser();
        }
        if (StringUtils.hasContent(root = PathUtils.getExpandedResourceRoot(this.container.getModelItem()))) {
            this.fc.setCurrentDirectory(new File(root));
        }
        if ((returnVal = this.fc.showOpenDialog(this)) == 0) {
            File file = this.fc.getSelectedFile();
            Boolean retval = UISupport.confirmOrCancel("Cache attachment in request?", "Add Attachment");
            if (retval == null) {
                return;
            }
            try {
                this.tableModel.addFile(file, retval);
            }
            catch (IOException e) {
                UISupport.showErrorMessage(e);
            }
        } else {
            System.out.println("Open command cancelled by user.");
        }
    }

    private void removeBtnActionPerformed(ActionEvent evt) {
        if (UISupport.confirm("Remove selected attachments?", "Remove Attachments")) {
            this.tableModel.removeAttachment(this.fileTable.getSelectedRows());
        }
    }

    private final class PartsComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        private Attachment attachment;
        private MessagePart.AttachmentPart[] parts;

        public PartsComboBoxModel() {
            AttachmentsPanel.this.container.addAttachmentsChangeListener(this);
        }

        public void release() {
            AttachmentsPanel.this.container.removeAttachmentsChangeListener(this);
        }

        public PartsComboBoxModel init(Attachment attachment) {
            this.attachment = attachment;
            int previousPartsCount = this.parts == null ? 0 : this.parts.length;
            this.parts = AttachmentsPanel.this.container.getDefinedAttachmentParts();
            if (previousPartsCount < this.parts.length) {
                this.fireIntervalAdded(this, previousPartsCount, this.parts.length);
            } else if (previousPartsCount > this.parts.length) {
                this.fireIntervalRemoved(this, this.parts.length - 1, previousPartsCount);
            }
            this.fireContentsChanged(this, 0, this.parts.length - 1);
            return this;
        }

        public Object getElementAt(int index) {
            return this.parts == null ? null : this.parts[index].getName();
        }

        public int getSize() {
            return this.parts == null ? 0 : this.parts.length;
        }

        public Object getSelectedItem() {
            return this.attachment == null ? null : this.attachment.getPart();
        }

        public void setSelectedItem(Object anItem) {
            if (this.attachment != null) {
                this.attachment.setPart((String)anItem);
            }
        }

        public void propertyChange(PropertyChangeEvent arg0) {
            if (arg0.getOldValue() == this.attachment && arg0.getNewValue() == null) {
                this.attachment = null;
                this.parts = null;
            }
        }
    }

    private class AttachmentPartCellEditor
    extends DefaultCellEditor {
        public AttachmentPartCellEditor() {
            super(new JComboBox(new PartsComboBoxModel()));
        }

        public void release() {
            ((PartsComboBoxModel)((JComboBox)this.editorComponent).getModel()).release();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            PartsComboBoxModel model = (PartsComboBoxModel)((JComboBox)this.editorComponent).getModel();
            ((JComboBox)this.editorComponent).setModel(model.init(AttachmentsPanel.this.tableModel.getAttachmentAt(row)));
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }
}

