/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.views.xml.raw;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.editor.views.AbstractXmlEditorView;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.editor.xml.XmlEditor;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RawXmlEditor<T extends XmlDocument>
extends AbstractXmlEditorView<T> {
    private JTextArea textArea = new JTextArea();
    private JScrollPane scrollPane;

    public RawXmlEditor(String title, XmlEditor<T> xmlEditor, String tooltip) {
        super(title, xmlEditor, "Raw");
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(SoapUI.getSettings().getBoolean(UISettings.WRAP_RAW_MESSAGES));
        this.textArea.setToolTipText(tooltip);
        this.scrollPane = new JScrollPane(this.textArea);
        UISupport.addPreviewCorner(this.scrollPane, true);
    }

    @Override
    public void setXml(String xml) {
        this.textArea.setText(this.getContent());
        this.textArea.setLineWrap(SoapUI.getSettings().getBoolean(UISettings.WRAP_RAW_MESSAGES));
        this.textArea.setCaretPosition(0);
    }

    public abstract String getContent();

    @Override
    public JComponent getComponent() {
        return this.scrollPane;
    }

    public boolean isInspectable() {
        return false;
    }

    @Override
    public boolean saveDocument(boolean validate) {
        return true;
    }

    @Override
    public void setEditable(boolean enabled) {
    }
}

