/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.resolver;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.actions.project.SimpleDialog;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.support.components.SimpleForm;
import com.eviware.soapui.support.resolver.ResolveContext;
import com.eviware.soapui.support.swing.ModelItemListCellRenderer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public abstract class ChangeOperationResolver
implements ResolveContext.Resolver {
    private boolean resolved = false;
    private WsdlProject project;
    private Operation selectedOperation;
    private String operationType;

    public ChangeOperationResolver(WsdlTestStep testStep, String operationType) {
        this.project = testStep.getTestCase().getTestSuite().getProject();
        this.operationType = operationType;
    }

    public String getResolvedPath() {
        return "";
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public boolean resolve() {
        PropertyChangeDialog pDialog = new PropertyChangeDialog("Resolve " + this.operationType);
        pDialog.setVisible(true);
        this.resolved = this.update();
        return this.resolved;
    }

    public abstract boolean update();

    protected abstract Interface[] getInterfaces(WsdlProject var1);

    public String getDescription() {
        return "Resolve: Select another " + this.operationType;
    }

    public String toString() {
        return this.getDescription();
    }

    public Operation getSelectedOperation() {
        return this.selectedOperation;
    }

    private class PropertyChangeDialog
    extends SimpleDialog {
        private JComboBox sourceStepCombo;
        private JComboBox propertiesCombo;

        public PropertyChangeDialog(String title) {
            super(title, ChangeOperationResolver.this.getDescription(), null);
        }

        protected Component buildContent() {
            SimpleForm form = new SimpleForm();
            form.addSpace(5);
            Interface[] ifaces = ChangeOperationResolver.this.getInterfaces(ChangeOperationResolver.this.project);
            DefaultComboBoxModel<Interface> sourceStepComboModel = new DefaultComboBoxModel<Interface>();
            this.sourceStepCombo = form.appendComboBox("Interfaces", sourceStepComboModel, "Target Interface");
            this.sourceStepCombo.setRenderer(new ModelItemListCellRenderer());
            for (Interface element : ifaces) {
                sourceStepComboModel.addElement(element);
            }
            this.propertiesCombo = form.appendComboBox(ChangeOperationResolver.this.operationType, ((Interface)this.sourceStepCombo.getSelectedItem()).getOperationList().toArray(), "Target " + ChangeOperationResolver.this.operationType);
            this.propertiesCombo.setRenderer(new ModelItemListCellRenderer());
            this.sourceStepCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Interface iface = ChangeOperationResolver.this.project.getInterfaceByName(((Interface)PropertyChangeDialog.this.sourceStepCombo.getSelectedItem()).getName());
                    PropertyChangeDialog.this.propertiesCombo.removeAllItems();
                    if (iface != null) {
                        PropertyChangeDialog.this.propertiesCombo.setEnabled(true);
                        for (Operation op : iface.getOperationList()) {
                            PropertyChangeDialog.this.propertiesCombo.addItem(op);
                        }
                    } else {
                        PropertyChangeDialog.this.propertiesCombo.setEnabled(false);
                    }
                }
            });
            form.addSpace(5);
            return form.getPanel();
        }

        protected boolean handleOk() {
            ChangeOperationResolver.this.selectedOperation = (Operation)this.propertiesCombo.getSelectedItem();
            return true;
        }
    }
}

