/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.resolver;

import com.eviware.soapui.impl.WsdlInterfaceFactory;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.rest.support.WadlImporter;
import com.eviware.soapui.impl.support.definition.support.InvalidDefinitionException;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestStepInterface;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.propertyexpansion.resolvers.providers.ProjectDirProvider;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveContext;
import java.io.File;
import javax.swing.JOptionPane;

public abstract class ImportInterfaceResolver
implements ResolveContext.Resolver {
    private boolean resolved = false;
    private WsdlTestStep item;

    public ImportInterfaceResolver(WsdlTestStep item) {
        this.item = item;
    }

    public String getResolvedPath() {
        return "";
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public boolean resolve() {
        Object[] options = new String[]{"File(Wsdl)", "Url(Wsdl)", "File(Wadl)", "Url(Wadl)", "Cancel"};
        int choosed = JOptionPane.showOptionDialog(UISupport.getMainFrame(), "Choose source for new interface from ...", "New interface source", 1, 3, null, options, null);
        switch (choosed) {
            case 0: {
                this.loadWsdlFromFile();
                this.resolved = this.update();
                break;
            }
            case 1: {
                this.loadWsdlFromUrl();
                this.resolved = this.update();
                break;
            }
            case 2: {
                this.loadWadlFromFile();
                this.resolved = this.update();
                break;
            }
            case 3: {
                this.loadWadlFromUrl();
                this.resolved = this.update();
                break;
            }
            default: {
                this.resolved = false;
            }
        }
        return this.resolved;
    }

    private void loadWadlFromUrl() {
        WsdlProject project = this.item.getTestCase().getTestSuite().getProject();
        String url = UISupport.prompt("Enter WADL URL", "Add WADL from URL", "");
        if (url == null) {
            return;
        }
        this.importWadl(project, url);
    }

    private void loadWadlFromFile() {
        WsdlProject project = this.item.getTestCase().getTestSuite().getProject();
        File file = UISupport.getFileDialogs().open(this, "Select WADL file", ".wadl", "WADL Files (*.wadl)", ProjectDirProvider.getProjectFolder(project));
        if (file == null) {
            return;
        }
        String path = file.getAbsolutePath();
        if (path == null) {
            return;
        }
        this.importWadl(project, "file:/" + path);
    }

    private void importWadl(WsdlProject project, String path) {
        RestService restService = (RestService)project.addNewInterface(((RestTestRequestStepInterface)((Object)this.item)).getRequestStepConfig().getService(), "rest");
        try {
            new WadlImporter(restService).initFromWadl(path);
        }
        catch (Exception e) {
            UISupport.showErrorMessage(e);
        }
    }

    protected abstract boolean update();

    private void loadWsdlFromUrl() {
        WsdlProject project = this.item.getTestCase().getTestSuite().getProject();
        String url = UISupport.prompt("Enter WSDL URL", "Add WSDL from URL", "");
        if (url == null) {
            return;
        }
        this.importWsdl(project, url);
    }

    private void loadWsdlFromFile() {
        WsdlProject project = this.item.getTestCase().getTestSuite().getProject();
        File file = UISupport.getFileDialogs().open(this, "Select WSDL file", ".wsdl", "WSDL Files (*.wsdl)", ProjectDirProvider.getProjectFolder(project));
        if (file == null) {
            return;
        }
        String path = file.getAbsolutePath();
        if (path == null) {
            return;
        }
        this.importWsdl(project, file.getAbsolutePath());
    }

    private void importWsdl(WsdlProject project, String file) {
        try {
            Boolean createRequests = UISupport.confirmOrCancel("Create default requests for all operations", "Import WSDL");
            if (createRequests == null) {
                return;
            }
            WsdlInterface[] ifaces = WsdlInterfaceFactory.importWsdl(project, file, createRequests);
            if (ifaces.length > 0) {
                UISupport.select(ifaces[0]);
            }
        }
        catch (InvalidDefinitionException ex) {
            UISupport.showExtendedInfo("Error loading WSDL", "There was something wrong with the WSDL you are trying to import", ex.getDetailedMessage(), null);
        }
        catch (Exception ex) {
            UISupport.showErrorMessage(ex.getMessage() + ":" + ex.getCause());
        }
    }

    public String getDescription() {
        return "Resolve: Import inteface";
    }

    public String toString() {
        return this.getDescription();
    }
}

