/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.swing;

import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ModalFrameUtil {
    public static void showAsModal(final Frame frame, final Frame owner) {
        frame.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                owner.setEnabled(false);
            }

            public void windowClosing(WindowEvent e) {
                owner.setEnabled(true);
                frame.removeWindowListener(this);
            }

            public void windowClosed(WindowEvent e) {
                owner.setEnabled(true);
                frame.removeWindowListener(this);
            }
        });
        owner.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                if (frame.isShowing()) {
                    frame.setExtendedState(0);
                    frame.toFront();
                } else {
                    owner.removeWindowListener(this);
                }
            }
        });
        frame.setVisible(true);
        try {
            new EventPump(frame).start();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static class EventPump
    implements InvocationHandler {
        Frame frame;

        public EventPump(Frame frame) {
            this.frame = frame;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.frame.isShowing();
        }

        public void start() throws Exception {
            Class<?> clazz = Class.forName("java.awt.Conditional");
            Object conditional = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
            Method pumpMethod = Class.forName("java.awt.EventDispatchThread").getDeclaredMethod("pumpEvents", clazz);
            pumpMethod.setAccessible(true);
            pumpMethod.invoke((Object)Thread.currentThread(), conditional);
        }
    }
}

