/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.tools;

import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.support.http.HttpRequestTestStep;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlRunTestCaseTestStep;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestRunListener;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.tools.AbstractSoapUIRunner;

public abstract class AbstractSoapUITestRunner
extends AbstractSoapUIRunner
implements TestRunListener {
    private String endpoint;
    private String domain;
    private String password;
    private String username;
    private String host;
    private String wssPasswordType;
    private String projectPassword;

    public AbstractSoapUITestRunner(String title) {
        super(title);
    }

    public void setProjectPassword(String projectPassword) {
        this.projectPassword = projectPassword;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setWssPasswordType(String wssPasswordType) {
        this.wssPasswordType = wssPasswordType;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getProjectPassword() {
        return this.projectPassword;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint.trim();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getHost() {
        return this.host;
    }

    public String getWssPasswordType() {
        return this.wssPasswordType;
    }

    protected void prepareRequestStep(HttpRequestTestStep requestStep) {
        AbstractHttpRequest<?> httpRequest = requestStep.getHttpRequest();
        if (StringUtils.hasContent(this.endpoint)) {
            httpRequest.setEndpoint(this.endpoint);
        } else if (StringUtils.hasContent(this.host)) {
            try {
                String ep = Tools.replaceHost(httpRequest.getEndpoint(), this.host);
                httpRequest.setEndpoint(ep);
            }
            catch (Exception e) {
                this.log.error((Object)"Failed to set host on endpoint", (Throwable)e);
            }
        }
        if (StringUtils.hasContent(this.username)) {
            httpRequest.setUsername(this.username);
        }
        if (StringUtils.hasContent(this.password)) {
            httpRequest.setPassword(this.password);
        }
        if (StringUtils.hasContent(this.domain)) {
            httpRequest.setDomain(this.domain);
        }
        if (httpRequest instanceof WsdlRequest && this.wssPasswordType != null && this.wssPasswordType.length() > 0) {
            ((WsdlRequest)httpRequest).setWssPasswordType(this.wssPasswordType.equals("Digest") ? "PasswordDigest" : "PasswordText");
        }
    }

    public void beforeRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
    }

    public final void beforeStep(TestCaseRunner testRunner, TestCaseRunContext runContext) {
    }

    public void beforeStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStep currentStep) {
        if (currentStep instanceof HttpRequestTestStep) {
            this.prepareRequestStep((HttpRequestTestStep)currentStep);
        } else if (currentStep instanceof WsdlRunTestCaseTestStep) {
            ((WsdlRunTestCaseTestStep)currentStep).addTestRunListener(this);
        }
    }

    public void afterStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStepResult result) {
        TestStep currentStep = runContext.getCurrentStep();
        if (currentStep instanceof WsdlRunTestCaseTestStep) {
            ((WsdlRunTestCaseTestStep)currentStep).removeTestRunListener(this);
        }
    }

    public void afterRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
    }
}

