/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.tools;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;

public class JarPackager {
    public static int BUFFER_SIZE = 10240;
    static Logger log = Logger.getLogger(JarPackager.class);

    public static File copyFileToDir(File fromFile, File toDir) {
        File toFile = new File(toDir, fromFile.getName());
        try {
            JarPackager.copyFile(fromFile, toFile);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return toFile;
    }

    public static void copyAllFromTo(File fromDir, File toDir, FileFilter filter) {
        if (fromDir.isDirectory() && toDir.isDirectory()) {
            File[] fromFiles;
            log.info((Object)("Coping files from " + fromDir.getAbsolutePath() + " to " + toDir.getAbsolutePath()));
            for (File file : fromFiles = filter == null ? fromDir.listFiles() : fromDir.listFiles(filter)) {
                File toFile = new File(toDir, file.getName());
                if (file.isDirectory()) {
                    if (toFile.exists() || toFile.mkdir()) {
                        JarPackager.copyAllFromTo(file, toFile, filter);
                        continue;
                    }
                    log.error((Object)("Could not create directory " + toFile.getAbsolutePath()));
                    continue;
                }
                try {
                    JarPackager.copyFile(file, toFile);
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        } else {
            log.error((Object)(fromDir.getAbsolutePath() + " or " + toDir.getAbsolutePath() + " is not directory!"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void copyFile(File fromFile, File toFile) throws IOException {
        block20: {
            FileOutputStream to;
            FileInputStream from;
            block18: {
                int bytesRead;
                from = null;
                to = null;
                from = new FileInputStream(fromFile);
                to = new FileOutputStream(toFile);
                byte[] buffer = new byte[4096];
                while ((bytesRead = from.read(buffer)) != -1) {
                    to.write(buffer, 0, bytesRead);
                }
                Object var7_7 = null;
                if (from == null) break block18;
                from.close();
            }
            if (to != null) {
                to.close();
            }
            break block20;
            {
                catch (Exception e) {
                    log.error((Object)e);
                    Object var7_8 = null;
                    if (from != null) {
                        from.close();
                    }
                    if (to != null) {
                        to.close();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (from != null) {
                    from.close();
                }
                if (to != null) {
                    to.close();
                }
                throw throwable;
            }
        }
    }

    public static void createJarArchive(File archiveFile, File root, File ... tobeJared) {
        try {
            byte[] buffer = new byte[BUFFER_SIZE];
            log.info((Object)("Creating archive [" + archiveFile.getAbsolutePath() + "]"));
            FileOutputStream stream = new FileOutputStream(archiveFile);
            JarOutputStream out = new JarOutputStream((OutputStream)stream, new Manifest());
            for (int i = 0; i < tobeJared.length; ++i) {
                int nRead;
                if (tobeJared[i] == null || !tobeJared[i].exists()) continue;
                String jarName = tobeJared[i].isDirectory() ? tobeJared[i].getAbsolutePath() + "/" : tobeJared[i].getAbsolutePath();
                jarName = jarName.replace(root.getAbsolutePath(), "").substring(1);
                jarName = jarName.replace(File.separatorChar, '/');
                JarEntry jarAdd = new JarEntry(jarName);
                log.info((Object)("Adding " + jarName));
                jarAdd.setTime(tobeJared[i].lastModified());
                out.putNextEntry(jarAdd);
                if (jarAdd.isDirectory()) continue;
                FileInputStream in = new FileInputStream(tobeJared[i]);
                while ((nRead = in.read(buffer, 0, buffer.length)) > 0) {
                    out.write(buffer, 0, nRead);
                }
                in.close();
            }
            out.close();
            stream.close();
            log.info((Object)"Adding completed OK");
        }
        catch (FileNotFoundException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

