/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.jedit;

import com.eviware.soapui.SoapUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.syntax.jedit.InputHandler;
import org.syntax.jedit.SyntaxDocument;
import org.syntax.jedit.SyntaxStyle;
import org.syntax.jedit.TextAreaDefaults;
import org.syntax.jedit.TextAreaPainter;
import org.syntax.jedit.TextUtilities;
import org.syntax.jedit.tokenmarker.Token;
import org.syntax.jedit.tokenmarker.TokenMarker;

public class JEditTextArea
extends JComponent
implements Scrollable {
    public static final String LEFT_OF_SCROLLBAR = "los";
    protected static final String CENTER = "center";
    protected static final String RIGHT = "right";
    protected static final String BOTTOM = "bottom";
    protected static WeakReference<JEditTextArea> focusedComponentRef;
    protected static final Timer caretTimer;
    protected TextAreaPainter painter;
    protected JPopupMenu popup;
    protected EventListenerList listenerList;
    protected MutableCaretEvent caretEvent;
    protected boolean caretBlinks;
    protected boolean caretVisible;
    protected boolean blink;
    protected boolean editable;
    protected int firstLine;
    protected int visibleLines;
    protected boolean scrollBarsInitialized;
    protected InputHandler inputHandler;
    protected SyntaxDocument document;
    protected DocumentHandler documentHandler;
    protected Segment lineSegment;
    protected int selectionStart;
    protected int selectionStartLine;
    protected int selectionEnd;
    protected int selectionEndLine;
    protected boolean biasLeft;
    protected int bracketPosition;
    protected int bracketLine;
    protected int magicCaret;
    protected boolean overwrite;
    protected boolean rectSelect;

    public JEditTextArea() {
        this(TextAreaDefaults.getDefaults());
    }

    public JEditTextArea(TextAreaDefaults defaults) {
        this.enableEvents(8L);
        this.painter = this.createPainter(defaults);
        this.documentHandler = new DocumentHandler();
        this.listenerList = new EventListenerList();
        this.caretEvent = new MutableCaretEvent();
        this.lineSegment = new Segment();
        this.bracketPosition = -1;
        this.bracketLine = -1;
        this.blink = true;
        this.setAutoscrolls(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.painter, "Center");
        this.painter.addComponentListener(new ComponentHandler());
        this.painter.addMouseListener(new MouseHandler());
        this.painter.addMouseMotionListener(new DragHandler());
        this.addFocusListener(new FocusHandler());
        this.setInputHandler(defaults.inputHandler);
        this.setDocument(defaults.document);
        this.editable = defaults.editable;
        this.caretVisible = defaults.caretVisible;
        this.caretBlinks = defaults.caretBlinks;
        this.popup = defaults.popup;
        focusedComponentRef = new WeakReference<JEditTextArea>(this);
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                if ((e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                    int caretLine = JEditTextArea.this.getCaretLine();
                    int newLine = caretLine + e.getWheelRotation();
                    if (newLine < 0) {
                        newLine = 0;
                    } else if (newLine > JEditTextArea.this.getLineCount() - 1) {
                        newLine = JEditTextArea.this.getLineCount() - 1;
                    }
                    int newPos = JEditTextArea.this.getLineStartOffset(newLine);
                    JEditTextArea.this.setCaretPosition(newPos);
                } else {
                    Rectangle rect = JEditTextArea.this.getVisibleRect();
                    rect.setLocation((int)rect.getX(), (int)rect.getY() + JEditTextArea.this.painter.getFontMetrics().getHeight() * 3 * e.getWheelRotation());
                    JEditTextArea.this.scrollRectToVisible(rect);
                }
            }
        });
    }

    protected TextAreaPainter createPainter(TextAreaDefaults defaults) {
        return new TextAreaPainter(this, defaults);
    }

    public final boolean isManagingFocus() {
        return true;
    }

    public final TextAreaPainter getPainter() {
        return this.painter;
    }

    public final InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public final boolean isCaretBlinkEnabled() {
        return this.caretBlinks;
    }

    public void setCaretBlinkEnabled(boolean caretBlinks) {
        this.caretBlinks = caretBlinks;
        if (!caretBlinks) {
            this.blink = false;
        }
        this.painter.invalidateSelectedLines();
    }

    public final boolean isCaretVisible() {
        return (!this.caretBlinks || this.blink) && this.caretVisible;
    }

    public void setCaretVisible(boolean caretVisible) {
        this.caretVisible = caretVisible;
        this.blink = true;
        this.painter.invalidateSelectedLines();
    }

    public final void blinkCaret() {
        if (this.caretBlinks && this.caretVisible) {
            this.blink = !this.blink;
            this.painter.invalidateSelectedLines();
        } else {
            this.blink = true;
        }
    }

    public void updateScrollBars() {
        this.revalidate();
    }

    public final int getFirstLine() {
        return this.firstLine;
    }

    public void setFirstLine(int firstLine) {
        if (firstLine == this.firstLine) {
            return;
        }
        this.firstLine = firstLine;
        this.updateScrollBars();
        this.painter.repaint();
    }

    public final int getVisibleLines() {
        return this.visibleLines;
    }

    public final void recalculateVisibleLines() {
        if (this.painter == null) {
            return;
        }
        int height = this.painter.getHeight();
        int lineHeight = this.painter.getFontMetrics().getHeight();
        this.visibleLines = height / lineHeight;
        this.updateScrollBars();
    }

    public void scrollToCaret() {
        int line = this.getCaretLine();
        int lineStart = this.getLineStartOffset(line);
        int offset = Math.max(0, Math.min(this.getTabExpandedLineLength(line) - 1, this.getCaretPosition() - lineStart));
        this.scrollTo(line, offset);
    }

    public void scrollTo(int line, int offset) {
        int x = this._offsetToX(line, offset);
        int width = this.painter.getFontMetrics().charWidth('w');
        if (offset > 0) {
            x += width + 5;
        }
        int y = this.lineToY(line);
        if (line > 0) {
            y += 5;
        }
        if (line > 0) {
            ++line;
        }
        this.scrollRectToVisible(new Rectangle(x, y, 1, this.painter.getFontMetrics().getHeight()));
        this.updateScrollBars();
        this.painter.repaint();
    }

    public int lineToY(int line) {
        FontMetrics fm = this.painter.getFontMetrics();
        return (line - this.firstLine) * fm.getHeight() - (fm.getLeading() + fm.getMaxDescent());
    }

    public int getLineHeight() {
        FontMetrics fm = this.painter.getFontMetrics();
        return fm.getHeight();
    }

    public int yToLine(int y) {
        FontMetrics fm = this.painter.getFontMetrics();
        int height = fm.getHeight();
        return Math.max(0, Math.min(this.getLineCount() - 1, y / height + this.firstLine));
    }

    public final int offsetToX(int line, int offset) {
        this.painter.currentLineTokens = null;
        return this._offsetToX(line, offset);
    }

    public int _offsetToX(int line, int offset) {
        Token tokens;
        TokenMarker tokenMarker = this.getTokenMarker();
        FontMetrics fm = this.painter.getFontMetrics();
        this.getLineText(line, this.lineSegment);
        int segmentOffset = this.lineSegment.offset;
        int x = 0;
        if (tokenMarker == null) {
            this.lineSegment.count = offset;
            return x + Utilities.getTabbedTextWidth(this.lineSegment, fm, x, (TabExpander)this.painter, 0);
        }
        if (this.painter.currentLineIndex == line && this.painter.currentLineTokens != null) {
            tokens = this.painter.currentLineTokens;
        } else {
            this.painter.currentLineIndex = line;
            tokens = this.painter.currentLineTokens = tokenMarker.markTokens(this.lineSegment, line);
        }
        Font defaultFont = this.painter.getFont();
        SyntaxStyle[] styles = this.painter.getStyles();
        byte id;
        while ((id = tokens.id) != 127) {
            fm = id == 0 ? this.painter.getFontMetrics() : styles[id].getFontMetrics(defaultFont);
            int length = tokens.length;
            if (offset + segmentOffset < this.lineSegment.offset + length) {
                this.lineSegment.count = offset - (this.lineSegment.offset - segmentOffset);
                return x + Utilities.getTabbedTextWidth(this.lineSegment, fm, x, (TabExpander)this.painter, 0);
            }
            this.lineSegment.count = length;
            x += Utilities.getTabbedTextWidth(this.lineSegment, fm, x, (TabExpander)this.painter, 0);
            this.lineSegment.offset += length;
            tokens = tokens.next;
        }
        return x;
    }

    public int xToOffset(int line, int x) {
        Token tokens;
        TokenMarker tokenMarker = this.getTokenMarker();
        FontMetrics fm = this.painter.getFontMetrics();
        this.getLineText(line, this.lineSegment);
        char[] segmentArray = this.lineSegment.array;
        int segmentOffset = this.lineSegment.offset;
        int segmentCount = this.lineSegment.count;
        int width = 0;
        if (tokenMarker == null) {
            for (int i = 0; i < segmentCount; ++i) {
                char c = segmentArray[i + segmentOffset];
                int charWidth = c == '\t' ? (int)this.painter.nextTabStop(width, i) - width : fm.charWidth(c);
                if (this.painter.isBlockCaretEnabled() ? x - charWidth <= width : x - charWidth / 2 <= width) {
                    return i;
                }
                width += charWidth;
            }
            return segmentCount;
        }
        if (this.painter.currentLineIndex == line && this.painter.currentLineTokens != null) {
            tokens = this.painter.currentLineTokens;
        } else {
            this.painter.currentLineIndex = line;
            tokens = this.painter.currentLineTokens = tokenMarker.markTokens(this.lineSegment, line);
        }
        int offset = 0;
        Font defaultFont = this.painter.getFont();
        SyntaxStyle[] styles = this.painter.getStyles();
        byte id;
        while ((id = tokens.id) != 127) {
            fm = id == 0 ? this.painter.getFontMetrics() : styles[id].getFontMetrics(defaultFont);
            int length = tokens.length;
            for (int i = 0; i < length; ++i) {
                char c = segmentArray[segmentOffset + offset + i];
                int charWidth = c == '\t' ? (int)this.painter.nextTabStop(width, offset + i) - width : fm.charWidth(c);
                if (this.painter.isBlockCaretEnabled() ? x - charWidth <= width : x - charWidth / 2 <= width) {
                    return offset + i;
                }
                width += charWidth;
            }
            offset += length;
            tokens = tokens.next;
        }
        return offset;
    }

    public int xyToOffset(int x, int y) {
        int line = this.yToLine(y);
        int start = this.getLineStartOffset(line);
        return start + this.xToOffset(line, x);
    }

    public int pointToOffset(Point pt) {
        return this.xyToOffset((int)pt.getX(), (int)pt.getY());
    }

    public final SyntaxDocument getDocument() {
        return this.document;
    }

    public void setDocument(SyntaxDocument document) {
        if (this.document == document) {
            return;
        }
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentHandler);
        }
        this.document = document;
        if (this.getParent() != null) {
            document.addDocumentListener(this.documentHandler);
        }
        this.select(0, 0);
        this.updateScrollBars();
        this.painter.repaint();
    }

    public final TokenMarker getTokenMarker() {
        return this.document.getTokenMarker();
    }

    public final void setTokenMarker(TokenMarker tokenMarker) {
        this.document.setTokenMarker(tokenMarker);
    }

    public final int getDocumentLength() {
        return this.document.getLength();
    }

    public final int getLineCount() {
        return this.document.getDefaultRootElement().getElementCount();
    }

    public final int getLineOfOffset(int offset) {
        return this.document.getDefaultRootElement().getElementIndex(offset);
    }

    public int getLineStartOffset(int line) {
        Element lineElement = this.document.getDefaultRootElement().getElement(line);
        if (lineElement == null) {
            return -1;
        }
        return lineElement.getStartOffset();
    }

    public int getLineEndOffset(int line) {
        Element lineElement = this.document.getDefaultRootElement().getElement(line);
        if (lineElement == null) {
            return -1;
        }
        return lineElement.getEndOffset();
    }

    public int getTabExpandedLineLength(int line) {
        Element lineElement = this.document.getDefaultRootElement().getElement(line);
        if (lineElement == null) {
            return -1;
        }
        int length = lineElement.getEndOffset() - lineElement.getStartOffset() - 1;
        try {
            String txt = this.document.getText(lineElement.getStartOffset(), length);
            for (int c = 0; c < txt.length(); ++c) {
                if (txt.charAt(c) != '\t') continue;
                length += 7;
            }
            return length;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return length;
        }
    }

    public int getLineLength(int line) {
        Element lineElement = this.document.getDefaultRootElement().getElement(line);
        if (lineElement == null) {
            return -1;
        }
        return lineElement.getEndOffset() - lineElement.getStartOffset() - 1;
    }

    public String getText() {
        try {
            return this.document.getText(0, this.document.getLength());
        }
        catch (BadLocationException bl) {
            SoapUI.logError(bl);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setText(String text) {
        try {
            try {
                this.document.beginCompoundEdit();
                this.document.remove(0, this.document.getLength());
                this.document.insertString(0, text, null);
                this.revalidate();
            }
            catch (BadLocationException bl) {
                SoapUI.logError(bl);
                Object var4_3 = null;
                this.document.endCompoundEdit();
            }
            Object var4_2 = null;
            this.document.endCompoundEdit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.document.endCompoundEdit();
            throw throwable;
        }
    }

    public final String getText(int start, int len) {
        try {
            return this.document.getText(start, len);
        }
        catch (BadLocationException bl) {
            SoapUI.logError(bl);
            return null;
        }
    }

    public final void getText(int start, int len, Segment segment) {
        try {
            this.document.getText(start, len, segment);
        }
        catch (BadLocationException bl) {
            SoapUI.logError(bl);
            segment.count = 0;
            segment.offset = 0;
        }
    }

    public final String getLineText(int lineIndex) {
        int start = this.getLineStartOffset(lineIndex);
        return this.getText(start, this.getLineEndOffset(lineIndex) - start - 1);
    }

    public final void getLineText(int lineIndex, Segment segment) {
        int start = this.getLineStartOffset(lineIndex);
        this.getText(start, this.getLineEndOffset(lineIndex) - start - 1, segment);
    }

    public final int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionStart(int line) {
        if (line == this.selectionStartLine) {
            return this.selectionStart;
        }
        if (this.rectSelect) {
            Element map = this.document.getDefaultRootElement();
            int start = this.selectionStart - map.getElement(this.selectionStartLine).getStartOffset();
            Element lineElement = map.getElement(line);
            int lineStart = lineElement.getStartOffset();
            int lineEnd = lineElement.getEndOffset() - 1;
            return Math.min(lineEnd, lineStart + start);
        }
        return this.getLineStartOffset(line);
    }

    public final int getSelectionStartLine() {
        return this.selectionStartLine;
    }

    public final void setSelectionStart(int selectionStart) {
        this.select(selectionStart, this.selectionEnd);
    }

    public final int getSelectionEnd() {
        return this.selectionEnd;
    }

    public int getSelectionEnd(int line) {
        if (line == this.selectionEndLine) {
            return this.selectionEnd;
        }
        if (this.rectSelect) {
            Element map = this.document.getDefaultRootElement();
            int end2 = this.selectionEnd - map.getElement(this.selectionEndLine).getStartOffset();
            Element lineElement = map.getElement(line);
            int lineStart = lineElement.getStartOffset();
            int lineEnd = lineElement.getEndOffset() - 1;
            return Math.min(lineEnd, lineStart + end2);
        }
        return this.getLineEndOffset(line) - 1;
    }

    public final int getSelectionEndLine() {
        return this.selectionEndLine;
    }

    public final void setSelectionEnd(int selectionEnd) {
        this.select(this.selectionStart, selectionEnd);
    }

    public final int getCaretPosition() {
        return this.biasLeft ? this.selectionStart : this.selectionEnd;
    }

    public final int getCaretLine() {
        return this.biasLeft ? this.selectionStartLine : this.selectionEndLine;
    }

    public final int getMarkPosition() {
        return this.biasLeft ? this.selectionEnd : this.selectionStart;
    }

    public final int getMarkLine() {
        return this.biasLeft ? this.selectionEndLine : this.selectionStartLine;
    }

    public final void setCaretPosition(int caret) {
        this.select(caret, caret);
    }

    public final void selectAll() {
        this.select(0, this.getDocumentLength());
    }

    public final void selectNone() {
        this.select(this.getCaretPosition(), this.getCaretPosition());
    }

    public void select(int start, int end2) {
        boolean newBias;
        int newEnd;
        int newStart;
        if (start <= end2) {
            newStart = start;
            newEnd = end2;
            newBias = false;
        } else {
            newStart = end2;
            newEnd = start;
            newBias = true;
        }
        if (newStart < 0 || newEnd > this.getDocumentLength()) {
            throw new IllegalArgumentException("Bounds out of range: " + newStart + "," + newEnd);
        }
        if (newStart != this.selectionStart || newEnd != this.selectionEnd || newBias != this.biasLeft) {
            int newStartLine = this.getLineOfOffset(newStart);
            int newEndLine = this.getLineOfOffset(newEnd);
            if (this.painter.isBracketHighlightEnabled()) {
                if (this.bracketLine != -1) {
                    this.painter.invalidateLine(this.bracketLine);
                }
                this.updateBracketHighlight(end2);
                if (this.bracketLine != -1) {
                    this.painter.invalidateLine(this.bracketLine);
                }
            }
            this.painter.invalidateLineRange(this.selectionStartLine, this.selectionEndLine);
            this.painter.invalidateLineRange(newStartLine, newEndLine);
            this.document.addUndoableEdit(new CaretUndo(this.selectionStart, this.selectionEnd));
            this.selectionStart = newStart;
            this.selectionEnd = newEnd;
            this.selectionStartLine = newStartLine;
            this.selectionEndLine = newEndLine;
            this.biasLeft = newBias;
            this.fireCaretEvent();
        }
        this.blink = true;
        caretTimer.restart();
        if (this.selectionStart == this.selectionEnd) {
            this.rectSelect = false;
        }
        this.magicCaret = -1;
        this.scrollToCaret();
    }

    public final String getSelectedText() {
        if (this.selectionStart == this.selectionEnd) {
            return null;
        }
        if (this.rectSelect) {
            Element map = this.document.getDefaultRootElement();
            int start = this.selectionStart - map.getElement(this.selectionStartLine).getStartOffset();
            int end2 = this.selectionEnd - map.getElement(this.selectionEndLine).getStartOffset();
            if (end2 < start) {
                int tmp = end2;
                end2 = start;
                start = tmp;
            }
            StringBuffer buf = new StringBuffer();
            Segment seg = new Segment();
            for (int i = this.selectionStartLine; i <= this.selectionEndLine; ++i) {
                Element lineElement = map.getElement(i);
                int lineStart = lineElement.getStartOffset();
                int lineEnd = lineElement.getEndOffset() - 1;
                int lineLen = lineEnd - lineStart;
                lineStart = Math.min(lineStart + start, lineEnd);
                lineLen = Math.min(end2 - start, lineEnd - lineStart);
                this.getText(lineStart, lineLen, seg);
                buf.append(seg.array, seg.offset, seg.count);
                if (i == this.selectionEndLine) continue;
                buf.append('\n');
            }
            return buf.toString();
        }
        return this.getText(this.selectionStart, this.selectionEnd - this.selectionStart);
    }

    public void setSelectedText(String selectedText) {
        if (!this.editable) {
            throw new InternalError("Text component read only");
        }
        this.document.beginCompoundEdit();
        try {
            block10: {
                try {
                    if (this.rectSelect) {
                        Element map = this.document.getDefaultRootElement();
                        int start = this.selectionStart - map.getElement(this.selectionStartLine).getStartOffset();
                        int end2 = this.selectionEnd - map.getElement(this.selectionEndLine).getStartOffset();
                        if (end2 < start) {
                            int tmp = end2;
                            end2 = start;
                            start = tmp;
                        }
                        int lastNewline = 0;
                        int currNewline = 0;
                        for (int i = this.selectionStartLine; i <= this.selectionEndLine; ++i) {
                            Element lineElement = map.getElement(i);
                            int lineStart = lineElement.getStartOffset();
                            int lineEnd = lineElement.getEndOffset() - 1;
                            int rectStart = Math.min(lineEnd, lineStart + start);
                            this.document.remove(rectStart, Math.min(lineEnd - rectStart, end2 - start));
                            if (selectedText == null) continue;
                            currNewline = selectedText.indexOf(10, lastNewline);
                            if (currNewline == -1) {
                                currNewline = selectedText.length();
                            }
                            this.document.insertString(rectStart, selectedText.substring(lastNewline, currNewline), null);
                            lastNewline = Math.min(selectedText.length(), currNewline + 1);
                        }
                        if (selectedText != null && currNewline != selectedText.length()) {
                            int offset = map.getElement(this.selectionEndLine).getEndOffset() - 1;
                            this.document.insertString(offset, "\n", null);
                            this.document.insertString(offset + 1, selectedText.substring(currNewline + 1), null);
                        }
                        break block10;
                    }
                    this.document.remove(this.selectionStart, this.selectionEnd - this.selectionStart);
                    if (selectedText == null) break block10;
                    this.document.insertString(this.selectionStart, selectedText, null);
                }
                catch (BadLocationException bl) {
                    SoapUI.logError(bl);
                    throw new InternalError("Cannot replace selection");
                }
            }
            Object var13_13 = null;
            this.document.endCompoundEdit();
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.document.endCompoundEdit();
            throw throwable;
        }
        this.setCaretPosition(this.selectionEnd);
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public final JPopupMenu getRightClickPopup() {
        return this.popup;
    }

    public final void setRightClickPopup(JPopupMenu popup) {
        this.popup = popup;
    }

    public final int getMagicCaretPosition() {
        return this.magicCaret;
    }

    public final void setMagicCaretPosition(int magicCaret) {
        this.magicCaret = magicCaret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overwriteSetSelectedText(String str) {
        if (!this.overwrite || this.selectionStart != this.selectionEnd) {
            this.setSelectedText(str);
            return;
        }
        int caret = this.getCaretPosition();
        int caretLineEnd = this.getLineEndOffset(this.getCaretLine());
        if (caretLineEnd - caret <= str.length()) {
            this.setSelectedText(str);
            return;
        }
        this.document.beginCompoundEdit();
        try {
            try {
                this.document.remove(caret, str.length());
                this.document.insertString(caret, str, null);
            }
            catch (BadLocationException bl) {
                SoapUI.logError(bl);
                Object var6_5 = null;
                this.document.endCompoundEdit();
            }
            Object var6_4 = null;
            this.document.endCompoundEdit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.document.endCompoundEdit();
            throw throwable;
        }
    }

    public final boolean isOverwriteEnabled() {
        return this.overwrite;
    }

    public final void setOverwriteEnabled(boolean overwrite2) {
        this.overwrite = overwrite2;
        this.painter.invalidateSelectedLines();
    }

    public final boolean isSelectionRectangular() {
        return this.rectSelect;
    }

    public final void setSelectionRectangular(boolean rectSelect) {
        this.rectSelect = rectSelect;
        this.painter.invalidateSelectedLines();
    }

    public final int getBracketPosition() {
        return this.bracketPosition;
    }

    public final int getBracketLine() {
        return this.bracketLine;
    }

    public final void addCaretListener(CaretListener listener) {
        this.listenerList.add(CaretListener.class, listener);
    }

    public final void removeCaretListener(CaretListener listener) {
        this.listenerList.remove(CaretListener.class, listener);
    }

    public void cut() {
        if (this.editable) {
            this.copy();
            this.setSelectedText("");
        }
    }

    public void copy() {
        if (this.selectionStart != this.selectionEnd) {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            String selection = this.getSelectedText();
            int repeatCount = this.inputHandler.getRepeatCount();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < repeatCount; ++i) {
                buf.append(selection);
            }
            clipboard.setContents(new StringSelection(buf.toString()), null);
        }
    }

    public void paste() {
        if (this.editable) {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            try {
                String selection = ((String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor)).replace('\r', '\n');
                selection = selection.replace("\n\n", "\n");
                int repeatCount = this.inputHandler.getRepeatCount();
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < repeatCount; ++i) {
                    buf.append(selection);
                }
                selection = buf.toString();
                this.setSelectedText(selection);
            }
            catch (Exception e) {
                this.getToolkit().beep();
                System.err.println("Clipboard does not contain a string");
            }
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (focusedComponentRef != null && focusedComponentRef.get() == this) {
            focusedComponentRef = null;
        }
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentHandler);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.document != null) {
            this.document.addDocumentListener(this.documentHandler);
        }
    }

    public void processKeyEvent(KeyEvent evt) {
        if (this.inputHandler == null) {
            return;
        }
        switch (evt.getID()) {
            case 400: {
                this.inputHandler.keyTyped(evt);
                break;
            }
            case 401: {
                this.inputHandler.keyPressed(evt);
                break;
            }
            case 402: {
                this.inputHandler.keyReleased(evt);
            }
        }
        if (!evt.isConsumed()) {
            KeyListener[] keyListeners;
            for (KeyListener listener : keyListeners = this.getKeyListeners()) {
                switch (evt.getID()) {
                    case 400: {
                        listener.keyTyped(evt);
                        break;
                    }
                    case 401: {
                        listener.keyPressed(evt);
                        break;
                    }
                    case 402: {
                        listener.keyReleased(evt);
                    }
                }
                if (evt.isConsumed()) break;
            }
            if (!evt.isConsumed()) {
                this.getParent().dispatchEvent(evt);
            }
        }
    }

    protected void fireCaretEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; --i) {
            if (listeners[i] != CaretListener.class) continue;
            ((CaretListener)listeners[i + 1]).caretUpdate(this.caretEvent);
        }
    }

    protected void updateBracketHighlight(int newCaretPosition) {
        if (newCaretPosition == 0) {
            this.bracketLine = -1;
            this.bracketPosition = -1;
            return;
        }
        try {
            int offset = TextUtilities.findMatchingBracket(this.document, newCaretPosition - 1);
            if (offset != -1) {
                this.bracketLine = this.getLineOfOffset(offset);
                this.bracketPosition = offset - this.getLineStartOffset(this.bracketLine);
                return;
            }
        }
        catch (BadLocationException bl) {
            SoapUI.logError(bl);
        }
        this.bracketPosition = -1;
        this.bracketLine = -1;
    }

    protected void documentChanged(DocumentEvent evt) {
        DocumentEvent.ElementChange ch = evt.getChange(this.document.getDefaultRootElement());
        int count = ch == null ? 0 : ch.getChildrenAdded().length - ch.getChildrenRemoved().length;
        int line = this.getLineOfOffset(evt.getOffset());
        if (count == 0) {
            this.painter.invalidateLine(line);
        } else if (line < this.firstLine) {
            this.setFirstLine(this.firstLine + count);
        } else {
            this.painter.invalidateLineRange(line, this.firstLine + this.visibleLines);
            this.updateScrollBars();
        }
    }

    public Dimension getPreferredSize() {
        Dimension preferredSize = this.painter.getPreferredSize();
        if (this.getParent() instanceof JViewport) {
            JViewport viewport = (JViewport)this.getParent();
            Dimension size = viewport.getSize();
            preferredSize = new Dimension((int)(preferredSize.getWidth() < size.getWidth() ? size.getWidth() : preferredSize.getWidth()), (int)(preferredSize.getHeight() < size.getHeight() ? size.getHeight() : preferredSize.getHeight()));
        }
        return preferredSize;
    }

    public Dimension getMaximumSize() {
        return this.painter.getMaximumSize();
    }

    public Dimension getMinimumSize() {
        return this.painter.getMinimumSize();
    }

    public int getMaxLineLength() {
        int max = 0;
        for (int c = 0; c < this.getLineCount(); ++c) {
            int lineLength = this.getTabExpandedLineLength(c);
            if (lineLength <= max) continue;
            max = lineLength;
        }
        return max;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle arg0, int arg1, int arg2) {
        return this.getFontMetrics(this.getFont()).getHeight() * 5;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle arg0, int arg1, int arg2) {
        return this.getFontMetrics(this.getFont()).getHeight();
    }

    static {
        caretTimer = new Timer(500, new CaretBlinker());
        caretTimer.setInitialDelay(500);
        caretTimer.start();
    }

    class CaretUndo
    extends AbstractUndoableEdit {
        private int start;
        private int end;

        CaretUndo(int start, int end2) {
            this.start = start;
            this.end = end2;
        }

        public boolean isSignificant() {
            return false;
        }

        public String getPresentationName() {
            return "caret move";
        }

        public void undo() throws CannotUndoException {
            super.undo();
            JEditTextArea.this.select(this.start, this.end);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            JEditTextArea.this.select(this.start, this.end);
        }

        public boolean addEdit(UndoableEdit edit) {
            if (edit instanceof CaretUndo) {
                CaretUndo cedit = (CaretUndo)edit;
                this.start = cedit.start;
                this.end = cedit.end;
                cedit.die();
                return true;
            }
            return false;
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            if (JEditTextArea.this.popup != null && e.isPopupTrigger()) {
                this.doPopup(e);
            }
        }

        private void doPopup(MouseEvent evt) {
            JEditTextArea.this.popup.show(JEditTextArea.this.painter, evt.getX(), evt.getY());
        }

        public void mouseReleased(MouseEvent e) {
            if (JEditTextArea.this.popup != null && e.isPopupTrigger()) {
                this.doPopup(e);
            }
        }

        public void mousePressed(MouseEvent evt) {
            JEditTextArea.this.requestFocus();
            if (JEditTextArea.this.isEditable()) {
                JEditTextArea.this.setCaretVisible(true);
            }
            focusedComponentRef = new WeakReference<JEditTextArea>(JEditTextArea.this);
            if (JEditTextArea.this.popup != null && evt.isPopupTrigger()) {
                this.doPopup(evt);
                return;
            }
            if (evt.getButton() != 1) {
                return;
            }
            int line = JEditTextArea.this.yToLine(evt.getY());
            int offset = JEditTextArea.this.xToOffset(line, evt.getX());
            int dot = JEditTextArea.this.getLineStartOffset(line) + offset;
            switch (evt.getClickCount()) {
                case 1: {
                    this.doSingleClick(evt, line, offset, dot);
                    break;
                }
                case 2: {
                    try {
                        this.doDoubleClick(evt, line, offset, dot);
                    }
                    catch (BadLocationException bl) {
                        SoapUI.logError(bl);
                    }
                    break;
                }
                case 3: {
                    this.doTripleClick(evt, line, offset, dot);
                }
            }
        }

        private void doSingleClick(MouseEvent evt, int line, int offset, int dot) {
            if ((evt.getModifiers() & 1) != 0) {
                JEditTextArea.this.rectSelect = (evt.getModifiers() & 2) != 0;
                JEditTextArea.this.select(JEditTextArea.this.getMarkPosition(), dot);
            } else {
                JEditTextArea.this.setCaretPosition(dot);
            }
        }

        private void doDoubleClick(MouseEvent evt, int line, int offset, int dot) throws BadLocationException {
            if (JEditTextArea.this.getTabExpandedLineLength(line) == 0) {
                return;
            }
            try {
                int bracket = TextUtilities.findMatchingBracket(JEditTextArea.this.document, Math.max(0, dot - 1));
                if (bracket != -1) {
                    int mark = JEditTextArea.this.getMarkPosition();
                    if (bracket > mark) {
                        ++bracket;
                        --mark;
                    }
                    JEditTextArea.this.select(mark, bracket);
                    return;
                }
            }
            catch (BadLocationException bl) {
                SoapUI.logError(bl);
            }
            String lineText = JEditTextArea.this.getLineText(line);
            char ch = lineText.charAt(Math.max(0, offset - 1));
            String noWordSep = (String)JEditTextArea.this.document.getProperty("noWordSep");
            if (noWordSep == null) {
                noWordSep = "";
            }
            boolean selectNoLetter = !Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1;
            int wordStart = 0;
            for (int i = offset - 1; i >= 0; --i) {
                ch = lineText.charAt(i);
                if (!(selectNoLetter ^ (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1))) continue;
                wordStart = i + 1;
                break;
            }
            int wordEnd = lineText.length();
            for (int i = offset; i < lineText.length(); ++i) {
                ch = lineText.charAt(i);
                if (!(selectNoLetter ^ (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1))) continue;
                wordEnd = i;
                break;
            }
            int lineStart = JEditTextArea.this.getLineStartOffset(line);
            JEditTextArea.this.select(lineStart + wordStart, lineStart + wordEnd);
        }

        private void doTripleClick(MouseEvent evt, int line, int offset, int dot) {
            JEditTextArea.this.select(JEditTextArea.this.getLineStartOffset(line), JEditTextArea.this.getLineEndOffset(line) - 1);
        }
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        public void focusGained(FocusEvent evt) {
            if (JEditTextArea.this.isEditable()) {
                JEditTextArea.this.setCaretVisible(true);
            }
            focusedComponentRef = new WeakReference<JEditTextArea>(JEditTextArea.this);
        }

        public void focusLost(FocusEvent evt) {
            JEditTextArea.this.setCaretVisible(false);
            focusedComponentRef = null;
        }
    }

    class DragHandler
    implements MouseMotionListener {
        DragHandler() {
        }

        public void mouseDragged(MouseEvent evt) {
            if (JEditTextArea.this.popup != null && JEditTextArea.this.popup.isVisible()) {
                return;
            }
            JEditTextArea.this.setSelectionRectangular((evt.getModifiers() & 2) != 0);
            JEditTextArea.this.select(JEditTextArea.this.getMarkPosition(), JEditTextArea.this.xyToOffset(evt.getX(), evt.getY()));
        }

        public void mouseMoved(MouseEvent evt) {
        }
    }

    class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        public void insertUpdate(DocumentEvent evt) {
            JEditTextArea.this.documentChanged(evt);
            int offset = evt.getOffset();
            int length = evt.getLength();
            int newStart = JEditTextArea.this.selectionStart > offset || JEditTextArea.this.selectionStart == JEditTextArea.this.selectionEnd && JEditTextArea.this.selectionStart == offset ? JEditTextArea.this.selectionStart + length : JEditTextArea.this.selectionStart;
            int newEnd = JEditTextArea.this.selectionEnd >= offset ? JEditTextArea.this.selectionEnd + length : JEditTextArea.this.selectionEnd;
            JEditTextArea.this.select(newStart, newEnd);
        }

        public void removeUpdate(DocumentEvent evt) {
            JEditTextArea.this.documentChanged(evt);
            int offset = evt.getOffset();
            int length = evt.getLength();
            int newStart = JEditTextArea.this.selectionStart > offset ? (JEditTextArea.this.selectionStart > offset + length ? JEditTextArea.this.selectionStart - length : offset) : JEditTextArea.this.selectionStart;
            int newEnd = JEditTextArea.this.selectionEnd > offset ? (JEditTextArea.this.selectionEnd > offset + length ? JEditTextArea.this.selectionEnd - length : offset) : JEditTextArea.this.selectionEnd;
            JEditTextArea.this.select(newStart, newEnd);
        }

        public void changedUpdate(DocumentEvent evt) {
        }
    }

    class ComponentHandler
    extends ComponentAdapter {
        ComponentHandler() {
        }

        public void componentResized(ComponentEvent evt) {
            JEditTextArea.this.recalculateVisibleLines();
            JEditTextArea.this.scrollBarsInitialized = true;
        }
    }

    class AdjustHandler
    implements AdjustmentListener {
        AdjustHandler() {
        }

        public void adjustmentValueChanged(AdjustmentEvent evt) {
            if (!JEditTextArea.this.scrollBarsInitialized) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                }
            });
        }
    }

    class MutableCaretEvent
    extends CaretEvent {
        MutableCaretEvent() {
            super(JEditTextArea.this);
        }

        public int getDot() {
            return JEditTextArea.this.getCaretPosition();
        }

        public int getMark() {
            return JEditTextArea.this.getMarkPosition();
        }
    }

    static class CaretBlinker
    implements ActionListener {
        CaretBlinker() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (focusedComponentRef != null && focusedComponentRef.get() != null && ((JEditTextArea)focusedComponentRef.get()).hasFocus()) {
                ((JEditTextArea)focusedComponentRef.get()).blinkCaret();
            }
        }
    }

    class ScrollLayout
    implements LayoutManager {
        private Component center;

        ScrollLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
            if (name.equals(JEditTextArea.CENTER)) {
                this.center = comp;
            }
        }

        public void removeLayoutComponent(Component comp) {
            if (this.center == comp) {
                this.center = null;
            }
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension();
            Insets insets = JEditTextArea.this.getInsets();
            dim.width = insets.left + insets.right;
            dim.height = insets.top + insets.bottom;
            Dimension centerPref = this.center.getPreferredSize();
            dim.width += centerPref.width;
            dim.height += centerPref.height;
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = new Dimension();
            Insets insets = JEditTextArea.this.getInsets();
            dim.width = insets.left + insets.right;
            dim.height = insets.top + insets.bottom;
            Dimension centerPref = this.center.getMinimumSize();
            dim.width += centerPref.width;
            dim.height += centerPref.height;
            return dim;
        }

        public void layoutContainer(Container parent) {
            Dimension size = parent.getSize();
            Insets insets = parent.getInsets();
            int itop = insets.top;
            int ileft = insets.left;
            int ibottom = insets.bottom;
            int iright = insets.right;
            int centerWidth = size.width - ileft - iright;
            int centerHeight = size.height - itop - ibottom;
            this.center.setBounds(ileft, itop, centerWidth, centerHeight);
        }
    }
}

