/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.safari;

import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt16;
import com.teamdev.jxbrowser.cookie.HttpCookie;
import com.teamdev.jxbrowser.cookie.HttpCookieStorage;
import com.teamdev.jxbrowser.webkit.cocoa.Id;
import com.teamdev.jxbrowser.webkit.cocoa.nsarray.NSArray;
import com.teamdev.jxbrowser.webkit.cocoa.nsdate.NSDate;
import com.teamdev.jxbrowser.webkit.cocoa.nsdate.NSTimeInterval;
import com.teamdev.jxbrowser.webkit.cocoa.nsdictionary.NSDictionary;
import com.teamdev.jxbrowser.webkit.cocoa.nshttpcookie.NSHttpCookie;
import com.teamdev.jxbrowser.webkit.cocoa.nshttpcookie.NSHttpCookieProperty;
import com.teamdev.jxbrowser.webkit.cocoa.nshttpcookie.NSHttpCookieStorage;
import com.teamdev.jxbrowser.webkit.cocoa.nsstring.NSString;
import com.teamdev.jxbrowser.webkit.cocoa.nsurl.NSURL;
import com.teamdev.jxdesktop.macosx.MainMessageLoop;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafariCookieStorage
extends HttpCookieStorage {
    private NSHttpCookieStorage storage;

    public SafariCookieStorage() {
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                SafariCookieStorage.this.storage = NSHttpCookieStorage.sharedHTTPCookieStorage();
            }
        });
    }

    public List<HttpCookie> getCookies() {
        final ArrayList<HttpCookie> arrayList = new ArrayList<HttpCookie>();
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                NSArray nSArray = SafariCookieStorage.this.storage.cookies();
                UInt16 uInt16 = nSArray.count();
                int n = 0;
                while ((long)n < uInt16.getValue()) {
                    Id id = nSArray.objectAtIndex(new UInt16(n));
                    NSHttpCookie nSHttpCookie = new NSHttpCookie(id);
                    arrayList.add(SafariCookieStorage.this.safariCookieToJxBrowserCookie(nSHttpCookie));
                    ++n;
                }
            }
        });
        return arrayList;
    }

    public List<HttpCookie> getCookies(final String string) {
        final ArrayList<HttpCookie> arrayList = new ArrayList<HttpCookie>();
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                NSArray nSArray = SafariCookieStorage.this.storage.cookiesForURL(NSURL.NSURL_URLWithString(string));
                UInt16 uInt16 = nSArray.count();
                int n = 0;
                while ((long)n < uInt16.getValue()) {
                    Id id = nSArray.objectAtIndex(new UInt16(n));
                    NSHttpCookie nSHttpCookie = new NSHttpCookie(id);
                    arrayList.add(SafariCookieStorage.this.safariCookieToJxBrowserCookie(nSHttpCookie));
                    ++n;
                }
            }
        });
        return arrayList;
    }

    public void setCookie(final HttpCookie httpCookie, String string) {
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                SafariCookieStorage.this.storage.setCookie(SafariCookieStorage.this.jxBrowserCookieToSafariCookie(httpCookie));
            }
        });
    }

    public void setCookie(List<HttpCookie> list, String string) {
        for (HttpCookie httpCookie : list) {
            this.setCookie(httpCookie, string);
        }
    }

    public void deleteCookie(final HttpCookie httpCookie) {
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                SafariCookieStorage.this.storage.deleteCookie(SafariCookieStorage.this.jxBrowserCookieToSafariCookie(httpCookie));
            }
        });
    }

    public void deleteCookie(List<HttpCookie> list) {
        for (HttpCookie httpCookie : list) {
            this.deleteCookie(httpCookie);
        }
    }

    private HttpCookie safariCookieToJxBrowserCookie(NSHttpCookie nSHttpCookie) {
        String string = nSHttpCookie.name().cString().getValue();
        String string2 = nSHttpCookie.value().cString().getValue();
        String string3 = nSHttpCookie.domain().cString().getValue();
        String string4 = nSHttpCookie.path().cString().getValue();
        boolean bl = nSHttpCookie.isSessionOnly();
        boolean bl2 = nSHttpCookie.isHTTPOnly();
        boolean bl3 = nSHttpCookie.isSecure();
        long l = (long)nSHttpCookie.expiresDate().timeIntervalSince1970().getValue();
        return new HttpCookie(string, string2, string3, string4, l, bl2, bl3, bl);
    }

    private NSHttpCookie jxBrowserCookieToSafariCookie(HttpCookie httpCookie) {
        NSHttpCookieProperty nSHttpCookieProperty = NSHttpCookieProperty.getInstance();
        NSString nSString = nSHttpCookieProperty.getPropertyName("NSHTTPCookieName");
        NSString nSString2 = nSHttpCookieProperty.getPropertyName("NSHTTPCookieValue");
        NSString nSString3 = nSHttpCookieProperty.getPropertyName("NSHTTPCookieDomain");
        NSString nSString4 = nSHttpCookieProperty.getPropertyName("NSHTTPCookiePath");
        NSString nSString5 = nSHttpCookieProperty.getPropertyName("NSHTTPCookieExpires");
        NSString nSString6 = NSString.NSString_stringWithString(httpCookie.getName());
        NSString nSString7 = NSString.NSString_stringWithString(httpCookie.getValue());
        NSString nSString8 = NSString.NSString_stringWithString(httpCookie.getDomain());
        NSString nSString9 = NSString.NSString_stringWithString(httpCookie.getPath());
        NSDate nSDate = NSDate.NSDate_dateWithTimeIntervalSinceReferenceDate(new NSTimeInterval(httpCookie.getExpiresDate()));
        NSArray nSArray = NSArray.NSArray_arrayWithObjects(nSString, new Parameter[]{nSString2, nSString3, nSString4, nSString5, new Pointer.Void()});
        NSArray nSArray2 = NSArray.NSArray_arrayWithObjects(nSString6, new Parameter[]{nSString7, nSString8, nSString9, nSDate, new Pointer.Void()});
        NSDictionary nSDictionary = NSDictionary.NSDictionary_dictionaryWithObjects_forKeys(nSArray2, nSArray);
        return NSHttpCookie.cookieWithProperties(nSDictionary);
    }
}

