/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.safari;

import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.BrowserServices;
import com.teamdev.jxbrowser.prompt.CloseStatus;
import com.teamdev.jxbrowser.prompt.DialogParams;
import com.teamdev.jxbrowser.prompt.PromptDialogParams;
import com.teamdev.jxbrowser.prompt.PromptService;
import com.teamdev.jxbrowser.safari.SafariBrowser;
import com.teamdev.jxbrowser.security.HttpSecurityAction;
import com.teamdev.jxbrowser.security.HttpSecurityHandler;
import com.teamdev.jxbrowser.security.SecurityProblem;
import com.teamdev.jxbrowser.webkit.DialogAction;
import com.teamdev.jxbrowser.webkit.DialogCreator;
import com.teamdev.jxbrowser.webkit.WebBrowserDialog;
import com.teamdev.jxbrowser.webkit.WebBrowserInputDialog;
import java.awt.Component;
import java.util.HashSet;

class SafariPromptService {
    SafariPromptService(SafariBrowser safariBrowser) {
        safariBrowser.getPeer().setDialogCreator(new SafariDialogCreator(safariBrowser));
    }

    private class SafariDialogCreator
    implements DialogCreator {
        private static final String TITLE = "JxBrowser";
        private SafariBrowser browser;

        private SafariDialogCreator(SafariBrowser safariBrowser) {
            this.browser = safariBrowser;
        }

        public WebBrowserDialog createAlert(final String string) {
            return new WebBrowserDialog(){

                public DialogAction showDialog(Component component) {
                    PromptService promptService = BrowserServices.getInstance().getPromptService();
                    if (promptService != null) {
                        try {
                            promptService.alertRequested(new DialogParams((Browser)SafariDialogCreator.this.browser, string, SafariDialogCreator.TITLE, SafariDialogCreator.this.browser.getComponent()));
                        }
                        catch (Exception exception) {
                            return DialogAction.OK;
                        }
                    }
                    return DialogAction.OK;
                }
            };
        }

        public WebBrowserDialog createConfirmation(final String string) {
            return new WebBrowserDialog(){

                public DialogAction showDialog(Component component) {
                    PromptService promptService = BrowserServices.getInstance().getPromptService();
                    if (promptService != null) {
                        try {
                            DialogParams dialogParams = new DialogParams((Browser)SafariDialogCreator.this.browser, string, SafariDialogCreator.TITLE, SafariDialogCreator.this.browser.getComponent());
                            CloseStatus closeStatus = promptService.confirmationRequested(dialogParams);
                            return closeStatus != null && closeStatus == CloseStatus.CANCEL ? DialogAction.CANCEL : DialogAction.OK;
                        }
                        catch (Exception exception) {
                            return DialogAction.OK;
                        }
                    }
                    return DialogAction.OK;
                }
            };
        }

        public WebBrowserInputDialog createPrompt(final String string, final String string2) {
            return new WebBrowserInputDialog(){
                private String resultValue;
                {
                    this.resultValue = string2;
                }

                public String getValue() {
                    return this.resultValue;
                }

                public DialogAction showDialog(Component component) {
                    PromptService promptService = BrowserServices.getInstance().getPromptService();
                    if (promptService != null) {
                        try {
                            PromptDialogParams promptDialogParams = new PromptDialogParams((Browser)SafariDialogCreator.this.browser, string, SafariDialogCreator.TITLE, string2, SafariDialogCreator.this.browser.getComponent());
                            CloseStatus closeStatus = promptService.promptRequested(promptDialogParams);
                            if (closeStatus != null && closeStatus == CloseStatus.OK) {
                                this.resultValue = promptDialogParams.getValue();
                                return DialogAction.OK;
                            }
                            return closeStatus != null && closeStatus == CloseStatus.CANCEL ? DialogAction.CANCEL : DialogAction.OK;
                        }
                        catch (Exception exception) {
                            return DialogAction.OK;
                        }
                    }
                    return DialogAction.OK;
                }
            };
        }

        public WebBrowserDialog createCertificate(final String string) {
            return new WebBrowserDialog(){

                public DialogAction showDialog(Component component) {
                    HttpSecurityAction httpSecurityAction = SafariDialogCreator.this.fireSecurityProblem();
                    if (httpSecurityAction == HttpSecurityAction.CONTINUE) {
                        return DialogAction.OK;
                    }
                    if (httpSecurityAction == HttpSecurityAction.DEFAULT) {
                        return SafariDialogCreator.this.showCertificateErrorDialog(string);
                    }
                    return DialogAction.CANCEL;
                }
            };
        }

        private DialogAction showCertificateErrorDialog(String string) {
            PromptService promptService = BrowserServices.getInstance().getPromptService();
            if (promptService != null) {
                String string2 = "<html><b>JxBrowser can't verify the identity of the website \"" + string + "\".</b>\n" + "<html><p></p>The certificate for this website was signed by an unknown certifying authority.\n" + "You might be connecting to a website that is pretending to be \n" + "\"" + string + "\" which could put your confidential information at risk.\n" + "\nWould you like to connect to the website anyway?\n\n";
                try {
                    DialogParams dialogParams = new DialogParams((Browser)this.browser, string2, TITLE, this.browser.getComponent());
                    CloseStatus closeStatus = promptService.badCertificateRequested(dialogParams);
                    return closeStatus != null && closeStatus == CloseStatus.CANCEL ? DialogAction.CANCEL : DialogAction.OK;
                }
                catch (Exception exception) {
                    return DialogAction.CANCEL;
                }
            }
            return DialogAction.CANCEL;
        }

        private HttpSecurityAction fireSecurityProblem() {
            HttpSecurityHandler httpSecurityHandler = this.browser.getHttpSecurityHandler();
            if (httpSecurityHandler != null) {
                HashSet<SecurityProblem> hashSet = new HashSet<SecurityProblem>();
                hashSet.add(SecurityProblem.NOT_TRUSTED_CERTIFICATE);
                HttpSecurityAction httpSecurityAction = httpSecurityHandler.onSecurityProblem(hashSet);
                if (httpSecurityAction != null) {
                    return httpSecurityAction;
                }
            }
            return HttpSecurityAction.CONTINUE;
        }
    }
}

