/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator;

import org.w3c.dom.Document;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AnalyzerContext;
import org.wsi.test.log.MessageEntry;
import org.wsi.test.log.MimePart;
import org.wsi.test.report.Entry;
import org.wsi.test.util.EntryType;
import org.wsi.wsdl.WSDLDocument;
import org.wsi.xml.XMLUtils;

public class EntryContext {
    protected Entry entry = null;
    protected MessageEntry request = null;
    protected MessageEntry response = null;
    protected MessageEntry messageEntry = null;
    protected Document requestDocument = null;
    protected Document responseDocument = null;
    protected Document messageEntryDocument = null;
    protected WSDLDocument wsdlDocument = null;
    protected AnalyzerContext analyzerContext = null;

    public EntryContext(Entry entry, MessageEntry messageEntry, MessageEntry messageEntry2) {
        this(entry, messageEntry, messageEntry2, null);
    }

    public EntryContext(Entry entry, MessageEntry messageEntry, MessageEntry messageEntry2, AnalyzerContext analyzerContext) {
        this.entry = entry;
        this.request = messageEntry;
        this.response = messageEntry2;
        this.analyzerContext = analyzerContext;
        try {
            MimePart mimePart;
            if (messageEntry.isMimeContent()) {
                mimePart = messageEntry.getMimeParts().getRootPart();
                if (mimePart != null && mimePart.getContent().length() > 0) {
                    this.requestDocument = XMLUtils.parseXML(mimePart.getContent());
                }
            } else if (messageEntry.getMessage().length() > 0) {
                this.requestDocument = XMLUtils.parseXML(messageEntry.getMessage());
            }
            if (messageEntry2.isMimeContent()) {
                mimePart = messageEntry2.getMimeParts().getRootPart();
                if (mimePart != null && mimePart.getContent().length() > 0) {
                    this.responseDocument = XMLUtils.parseXML(mimePart.getContent());
                }
            } else if (messageEntry2.getMessage().length() > 0) {
                this.responseDocument = XMLUtils.parseXML(messageEntry2.getMessage());
            }
        }
        catch (WSIException wSIException) {
            // empty catch block
        }
        if (entry.getEntryType().equals(EntryType.ENTRY_TYPE_REQUEST)) {
            this.messageEntry = messageEntry;
            this.messageEntryDocument = this.requestDocument;
        } else {
            this.messageEntry = messageEntry2;
            this.messageEntryDocument = this.responseDocument;
        }
    }

    public EntryContext(Entry entry, WSDLDocument wSDLDocument) {
        this.entry = entry;
        this.wsdlDocument = wSDLDocument;
    }

    public EntryContext(Entry entry, AnalyzerContext analyzerContext) {
        this.entry = entry;
        this.analyzerContext = analyzerContext;
    }

    public Entry getEntry() {
        return this.entry;
    }

    public MessageEntry getRequest() {
        return this.request;
    }

    public MessageEntry getResponse() {
        return this.response;
    }

    public MessageEntry getMessageEntry() {
        return this.messageEntry;
    }

    public Document getRequestDocument() {
        return this.requestDocument;
    }

    public Document getResponseDocument() {
        return this.responseDocument;
    }

    public Document getMessageEntryDocument() {
        return this.messageEntryDocument;
    }

    public WSDLDocument getWSDLDocument() {
        return this.wsdlDocument;
    }

    public AnalyzerContext getAnalyzerContext() {
        return this.analyzerContext;
    }
}

