/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AnalyzerContext;
import org.wsi.test.profile.ProfileArtifact;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.BaseValidator;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.EnvelopeValidator;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.report.Entry;
import org.wsi.test.report.FailureDetail;
import org.wsi.test.report.PrereqFailedList;
import org.wsi.test.report.ReportArtifact;
import org.wsi.test.report.Reporter;
import org.wsi.test.report.impl.PrereqFailedListImpl;
import org.wsi.test.util.EntryType;
import org.wsi.xml.XMLDocumentCacheUser;
import org.wsi.xml.dom.ElementLocation;

public abstract class BaseValidatorImpl
extends XMLDocumentCacheUser
implements BaseValidator {
    private static final Hashtable resultPriority = new Hashtable(6);
    private static final int MAX_VALID_PRIORITY = 1;
    public AnalyzerContext analyzerContext;
    protected ProfileArtifact profileArtifact;
    protected Reporter reporter;
    protected ReportArtifact reportArtifact;
    public boolean verboseOption = false;
    protected int assertionCount = 0;
    static /* synthetic */ Class class$org$wsi$test$profile$validator$impl$BaseMessageValidator;

    public void init(AnalyzerContext analyzerContext, ProfileArtifact profileArtifact, ReportArtifact reportArtifact, Reporter reporter) throws WSIException {
        this.analyzerContext = analyzerContext;
        this.profileArtifact = profileArtifact;
        this.reportArtifact = reportArtifact;
        this.reporter = reporter;
        this.documentList = this.analyzerContext.getDocumentList();
        this.verboseOption = reporter.getReport().getReportContext().getAnalyzer().getAnalyzerConfig().getVerboseOption();
    }

    protected void processAssertions(String string, EntryContext entryContext) throws WSIException {
        long l = 0L;
        HashMap<String, AssertionProcess> hashMap = new HashMap<String, AssertionProcess>();
        TestAssertion testAssertion = null;
        Class[] classArray = new Class[1];
        Class clazz = this instanceof BaseMessageValidator ? (class$org$wsi$test$profile$validator$impl$BaseMessageValidator == null ? (class$org$wsi$test$profile$validator$impl$BaseMessageValidator = BaseValidatorImpl.class$("org.wsi.test.profile.validator.impl.BaseMessageValidator")) : class$org$wsi$test$profile$validator$impl$BaseMessageValidator) : this.getClass();
        classArray[0] = clazz;
        Object[] objectArray = new Object[]{this};
        Entry entry = entryContext.getEntry();
        this.reportArtifact.addEntry(entry);
        if (this instanceof EnvelopeValidator) {
            this.reporter.setCurrentEnvelopeEntry(entry);
        } else {
            this.reporter.setCurrentEntry(entry);
        }
        try {
            Iterator iterator = this.profileArtifact.getTestAssertionList().iterator();
            while (iterator.hasNext()) {
                testAssertion = (TestAssertion)iterator.next();
                AssertionResult assertionResult = null;
                if (!testAssertion.isEnabled() || !this.isPrimaryEntryTypeMatch(testAssertion, entryContext)) continue;
                try {
                    Object object;
                    ++this.assertionCount;
                    AssertionProcess assertionProcess = (AssertionProcess)hashMap.get(testAssertion.getId());
                    if (assertionProcess == null) {
                        object = Class.forName(string + testAssertion.getId());
                        assertionProcess = (AssertionProcess)((Class)object).getConstructor(classArray).newInstance(objectArray);
                        hashMap.put(testAssertion.getId(), assertionProcess);
                    }
                    if (entry.getEntryDetail() == null) {
                        assertionResult = this.createAssertionResult(testAssertion, "missingInput", (String)null);
                    } else if (this.isNotApplicable(testAssertion)) {
                        assertionResult = this.createAssertionResult(testAssertion, "notApplicable", (String)null);
                    } else {
                        Object object2;
                        TreeMap treeMap = null;
                        PrereqFailedList prereqFailedList = null;
                        object = testAssertion.getPrereqIdList().iterator();
                        while (object.hasNext()) {
                            if (treeMap == null) {
                                treeMap = new TreeMap();
                            }
                            String string2 = (String)object.next();
                            object2 = this.reporter.getAssertionResult(string2);
                            treeMap.put(resultPriority.get(object2.getResult()), object2.getResult());
                            if ((Integer)resultPriority.get(object2.getResult()) <= 1) continue;
                            if (prereqFailedList == null) {
                                prereqFailedList = new PrereqFailedListImpl();
                            }
                            prereqFailedList.addTestAssertionID(string2);
                        }
                        if (prereqFailedList != null) {
                            object2 = (Integer)treeMap.lastKey();
                            String string3 = (String)treeMap.get(object2);
                            if (string3.equals("failed") || string3.equals("warning")) {
                                string3 = "prereqFailed";
                            }
                            assertionResult = this.createAssertionResult(testAssertion, string3, prereqFailedList);
                        } else {
                            assertionProcess.reset();
                            if (this.verboseOption) {
                                System.err.println("  Processing " + testAssertion.getId() + " for entry reference ID [" + entry.getReferenceID() + "] ...");
                                l = System.currentTimeMillis();
                            }
                            assertionResult = assertionProcess.validate(testAssertion, entryContext);
                            this.analyzerContext.setDocumentList(this.documentList);
                            if (this.verboseOption) {
                                System.err.println("    Elapsed time: " + (System.currentTimeMillis() - l) + "ms");
                            }
                        }
                    }
                    this.reporter.addAssertionResult(assertionResult);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (testAssertion == null) continue;
                    this.reporter.getReport().getReportContext().getAnalyzer().printMessage("WARNING: " + testAssertion.getId() + " is not supported currently.");
                }
            }
        }
        catch (Exception exception) {
            System.err.println("EXECEPTION: " + exception.getMessage());
            if (this.verboseOption) {
                exception.printStackTrace();
            }
            if (exception instanceof WSIException) {
                throw (WSIException)exception;
            }
            throw new WSIException(exception.getMessage(), exception);
        }
        finally {
            this.reporter.endCurrentEntry();
        }
    }

    protected abstract boolean isPrimaryEntryTypeMatch(TestAssertion var1, EntryContext var2);

    protected boolean isPrimaryEntryTypeMatch(TestAssertion testAssertion, Entry entry) {
        boolean bl = false;
        if (testAssertion.getEntryTypeName().equals(entry.getEntryType().getTypeName())) {
            bl = true;
        }
        return bl;
    }

    protected abstract boolean isNotApplicable(TestAssertion var1);

    public void cleanup() throws WSIException {
        if (this.assertionCount == 0) {
            this.setAllMissingInput();
        }
        this.analyzerContext.setDocumentList(this.documentList);
    }

    public AssertionResult createAssertionResult(TestAssertion testAssertion, String string, FailureDetail failureDetail) {
        Vector<FailureDetail> vector = null;
        if (failureDetail != null) {
            vector = new Vector<FailureDetail>();
            vector.add(failureDetail);
        }
        return this.createAssertionResult(testAssertion, string, vector);
    }

    public AssertionResult createAssertionResult(TestAssertion testAssertion, String string, String string2) {
        return this.createAssertionResult(testAssertion, string, string2, null);
    }

    public AssertionResult createAssertionResult(TestAssertion testAssertion, String string, String string2, ElementLocation elementLocation) {
        Vector<FailureDetail> vector = null;
        if (string2 != null) {
            vector = new Vector<FailureDetail>();
            FailureDetail failureDetail = this.reporter.createFailureDetail();
            failureDetail.setFailureMessage(string2);
            failureDetail.setElementLocation(elementLocation);
            vector.add(failureDetail);
        }
        return this.createAssertionResult(testAssertion, string, vector);
    }

    public AssertionResult createAssertionResult(TestAssertion testAssertion, String string, Vector vector) {
        AssertionResult assertionResult = this.reporter.createAssertionResult();
        assertionResult.setAssertion(testAssertion);
        assertionResult.setResult(string);
        assertionResult.setEntry(this.reporter.getReport().getCurrentEntry());
        assertionResult.setFailureDetailList(vector);
        return assertionResult;
    }

    public AssertionResult createAssertionResult(TestAssertion testAssertion, String string, PrereqFailedList prereqFailedList) {
        AssertionResult assertionResult = this.reporter.createAssertionResult();
        assertionResult.setAssertion(testAssertion);
        assertionResult.setResult(string);
        assertionResult.setEntry(this.reporter.getReport().getCurrentEntry());
        assertionResult.setPrereqFailedList(prereqFailedList);
        return assertionResult;
    }

    protected void addAssertionResult(String string, String string2) throws WSIException {
        AssertionResult assertionResult = this.reporter.createAssertionResult();
        assertionResult.setAssertion(this.profileArtifact.getTestAssertion(string));
        assertionResult.setResult(string2);
        assertionResult.setEntry(this.reporter.getReport().getCurrentEntry());
        this.reporter.addAssertionResult(assertionResult);
    }

    protected void addAssertionResult(String string, String string2, String string3) throws WSIException {
        Vector<FailureDetail> vector = null;
        if (string3 != null) {
            vector = new Vector<FailureDetail>();
            FailureDetail failureDetail = this.reporter.createFailureDetail();
            vector.add(failureDetail);
        }
        this.addAssertionResult(string, string2, vector);
    }

    protected void addAssertionResult(String string, String string2, Vector vector) throws WSIException {
        AssertionResult assertionResult = this.reporter.createAssertionResult();
        assertionResult.setAssertion(this.profileArtifact.getTestAssertion(string));
        assertionResult.setResult(string2);
        assertionResult.setEntry(this.reporter.getReport().getCurrentEntry());
        assertionResult.setFailureDetailList(vector);
        this.reporter.addAssertionResult(assertionResult);
    }

    protected void addMissingInputResult(TestAssertion testAssertion) throws WSIException {
        AssertionResult assertionResult = this.reporter.createAssertionResult();
        assertionResult.setAssertion(testAssertion);
        assertionResult.setResult("missingInput");
        assertionResult.setEntry(this.reporter.getReport().getCurrentEntry());
        this.reporter.addAssertionResult(assertionResult);
    }

    public void setAllMissingInput() throws WSIException {
        if (this.profileArtifact != null) {
            Entry entry = this.reporter.getReport().createEntry();
            entry.setArtifactName(this.reportArtifact.getType().getTypeName());
            this.reportArtifact.addEntry(entry);
            this.reporter.setCurrentEntry(entry);
            Iterator iterator = this.profileArtifact.getTestAssertionList().iterator();
            while (iterator.hasNext()) {
                TestAssertion testAssertion = (TestAssertion)iterator.next();
                if (!testAssertion.isEnabled()) continue;
                this.addMissingInputResult(testAssertion);
            }
            this.reporter.endCurrentEntry();
        }
    }

    protected void setMissingInput(EntryType entryType) throws WSIException {
        Entry entry = this.reporter.getReport().createEntry();
        entry.setEntryType(entryType);
        entry.setReferenceID("[" + entryType.getTypeName() + "]");
        this.reportArtifact.addEntry(entry);
        this.reporter.setCurrentEntry(entry);
        Iterator iterator = this.profileArtifact.getTestAssertionList().iterator();
        while (iterator.hasNext()) {
            TestAssertion testAssertion = (TestAssertion)iterator.next();
            if (!testAssertion.isEnabled() || !this.isPrimaryEntryTypeMatch(testAssertion, entry)) continue;
            this.addMissingInputResult(testAssertion);
        }
        this.reporter.endCurrentEntry();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        resultPriority.put("passed", new Integer(0));
        resultPriority.put("notApplicable", new Integer(1));
        resultPriority.put("missingInput", new Integer(2));
        resultPriority.put("warning", new Integer(3));
        resultPriority.put("prereqFailed", new Integer(4));
        resultPriority.put("failed", new Integer(5));
    }
}

