/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.xml.XMLUtils;

public class BP1032
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1032(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Document document = entryContext.getMessageEntryDocument();
            if (document == null) {
                throw new AssertionNotApplicableException();
            }
            Element element = document.getDocumentElement();
            if (!element.getLocalName().equals("Envelope")) {
                throw new AssertionNotApplicableException();
            }
            Attr attr = this.getAttribute(element.getAttributes());
            if (attr != null) {
                throw new AssertionFailException("soap:Envelope attribute name is " + attr.getName());
            }
            if ((element = XMLUtils.getFirstChild(element)) != null && element.getLocalName().equals("Header")) {
                attr = this.getAttribute(element.getAttributes());
                if (attr != null) {
                    throw new AssertionFailException("soap:Header attribute name is " + attr.getName());
                }
                element = XMLUtils.getNextSibling(element);
            }
            if (element != null && element.getLocalName().equals("Body") && (attr = this.getAttribute(element.getAttributes())) != null) {
                throw new AssertionFailException("soap:Body attribute name is " + attr.getName());
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private Attr getAttribute(NamedNodeMap namedNodeMap) {
        Attr attr = null;
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr2 = (Attr)namedNodeMap.item(i);
                if (attr2.getNamespaceURI() == null || !attr2.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) continue;
                attr = attr2;
                break;
            }
        }
        return attr;
    }
}

