/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;

public class BP1309
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1309(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Document document;
        if (this.validator.isOneWayResponse(entryContext) || (document = entryContext.getMessageEntryDocument()) == null) {
            this.result = "notApplicable";
        } else {
            NodeList nodeList = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
            if (nodeList == null || nodeList.getLength() == 0) {
                this.result = "notApplicable";
            } else {
                try {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node;
                        int n;
                        Element element = (Element)nodeList.item(i);
                        NodeList nodeList2 = element.getChildNodes();
                        Vector<Element> vector = new Vector<Element>();
                        for (n = 0; n < nodeList2.getLength(); ++n) {
                            node = nodeList2.item(n);
                            if (node.getNodeType() != 1) continue;
                            vector.addElement((Element)node);
                        }
                        for (n = 0; n < vector.size(); ++n) {
                            node = (Element)vector.elementAt(n);
                            if (!node.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") || !node.getLocalName().equals("Body") || node == vector.lastElement()) continue;
                            throw new AssertionFailException(entryContext.getMessageEntry().getMessage());
                        }
                    }
                }
                catch (AssertionFailException assertionFailException) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

