/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import java.util.Collection;
import java.util.HashSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.xml.XMLUtils;

public class BP1600
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1600(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Object object;
            Document document = entryContext.getMessageEntryDocument();
            if (document == null) {
                if (this.validator.isOneWayResponse(entryContext)) {
                    throw new AssertionNotApplicableException();
                }
                throw new AssertionFailException("The log message is empty or invalid.");
            }
            Element element = document.getDocumentElement();
            if (!element.getLocalName().equals("Envelope") || !this.isSOAPNamespace(element.getNamespaceURI())) {
                throw new AssertionFailException("The top element is not soap:Envelope");
            }
            Collection collection = this.collectNamespaces(element.getAttributes());
            collection.add("http://www.w3.org/2000/xmlns/");
            Attr attr = this.getNotValidAttr(element.getAttributes(), collection);
            if (attr != null) {
                throw new AssertionFailException("The attribute " + attr.getNodeName() + " is not namespace-qualified");
            }
            if ((element = XMLUtils.getFirstChild(element)) != null && element.getLocalName().equals("Header") && this.isSOAPNamespace(element.getNamespaceURI())) {
                object = XMLUtils.getFirstChild(element);
                while (object != null) {
                    Collection collection2 = this.collectNamespaces(object.getAttributes());
                    if (!collection.contains(object.getNamespaceURI()) && !collection2.contains(object.getNamespaceURI())) {
                        throw new AssertionFailException("The header entry " + object.getNodeName() + " is not namespace-qualified");
                    }
                    object = XMLUtils.getNextSibling((Element)object);
                }
                element = XMLUtils.getNextSibling(element);
            }
            if (element == null || !element.getLocalName().equals("Body") || !this.isSOAPNamespace(element.getNamespaceURI())) {
                throw new AssertionFailException("The soap:Body element is not presented or follows an additional sub element of soap:Envelope");
            }
            element = XMLUtils.getNextSibling(element);
            while (element != null) {
                if (element.getLocalName().equals("Header") && this.isSOAPNamespace(element.getNamespaceURI())) {
                    throw new AssertionFailException("The soap:Header element cannot follow the soap:Body element");
                }
                object = this.collectNamespaces(element.getAttributes());
                if (!collection.contains(element.getNamespaceURI()) && !object.contains(element.getNamespaceURI())) {
                    throw new AssertionFailException("The sub envelope element " + element.getNodeName() + " is not namespace-qualified");
                }
                element = XMLUtils.getNextSibling(element);
            }
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private Collection collectNamespaces(NamedNodeMap namedNodeMap) {
        HashSet<String> hashSet = new HashSet<String>();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                if (attr.getNamespaceURI() == null || !attr.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
                hashSet.add(attr.getValue());
            }
        }
        return hashSet;
    }

    private Attr getNotValidAttr(NamedNodeMap namedNodeMap, Collection collection) {
        Attr attr = null;
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr2 = (Attr)namedNodeMap.item(i);
                if (attr2.getNamespaceURI() != null && collection.contains(attr2.getNamespaceURI())) continue;
                attr = attr2;
                break;
            }
        }
        return attr;
    }

    private boolean isSOAPNamespace(String string) {
        if (string == null) {
            return false;
        }
        return string.equals("http://schemas.xmlsoap.org/soap/envelope/");
    }
}

