/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import com.ibm.wsdl.util.xml.DOM2Writer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.TestUtils;
import org.wsi.util.Utils;
import org.wsi.xml.XMLUtils;
import org.xml.sax.SAXException;

public class BP1701
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1701(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        if (this.validator.isOneWayResponse(entryContext)) {
            this.result = "notApplicable";
        } else {
            try {
                Node node;
                Document document = XMLUtils.parseXML(entryContext.getMessageEntry().getMessage());
                NodeList nodeList = document.getElementsByTagName("*");
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        node = (Element)nodeList.item(i);
                        node.removeAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                    }
                }
                String string = DOM2Writer.nodeToString((Node)document);
                node = XMLUtils.parseXML(string, TestUtils.getSOAPSchemaLocation());
            }
            catch (WSIException wSIException) {
                if (wSIException.getTargetException() instanceof SAXException) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail(Utils.getExceptionDetails(wSIException.getTargetException()), entryContext);
                }
            }
            catch (Exception exception) {
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail(Utils.getExceptionDetails(exception), entryContext);
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

