/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.message;

import java.util.Iterator;
import org.wsi.WSIException;
import org.wsi.test.log.MimePart;
import org.wsi.test.log.MimeParts;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.util.MIMEUtils;

public class AP1934
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public AP1934(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        if (!entryContext.getMessageEntry().isMimeContent()) {
            this.result = "notApplicable";
        } else {
            MimeParts mimeParts = entryContext.getMessageEntry().getMimeParts();
            if (mimeParts.count() == 0) {
                this.result = "notApplicable";
            } else {
                Iterator iterator = mimeParts.getParts().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    MimePart mimePart = (MimePart)iterator.next();
                    String string = MIMEUtils.getMimeHeaderAttribute(mimePart.getHeaders(), "Content-Transfer-Encoding");
                    if (!(string == null || string != null && (string.equalsIgnoreCase("7bit") || string.equalsIgnoreCase("8bit") || string.equalsIgnoreCase("base64") || string.equalsIgnoreCase("quoted-printable") || string.equalsIgnoreCase("binary")))) {
                        this.result = "failed";
                        this.failureDetail = this.validator.createFailureDetail("(" + (n + 1) + "), part header field \"Content-Transfer-Encoding\" has incorrect value \"" + string + "\"", entryContext);
                    }
                    ++n;
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

