/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.message;

import java.util.Map;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.analyzer.AssertionPassException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.util.HTTPUtils;

public class SSBP1003
extends AssertionProcess {
    protected final BaseMessageValidator validator;

    public SSBP1003(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            if (this.validator.isOneWayResponse(entryContext)) {
                throw new AssertionNotApplicableException();
            }
            String string = entryContext.getMessageEntry().getHTTPHeaders();
            Map map = HTTPUtils.getHttpHeaderTokens(string, ":");
            String string2 = (String)map.get("Content-Type");
            if (string2 == null) {
                throw new AssertionFailException("The Content-Type header is not present.");
            }
            string2 = string2.trim();
            String string3 = string2.substring(string2.indexOf(";") + 1, string2.length());
            if (!(string3 = string3.trim()).startsWith("charset")) {
                throw new AssertionFailException("Missing or bad \"charset\" attribute in the Content-Type header: " + string3);
            }
            String string4 = string3.substring(string3.indexOf("=") + 1, string3.length());
            if (string4.startsWith("\"")) {
                string4 = string4.substring(1, string4.length() - 1);
            }
            if (!string4.equalsIgnoreCase("utf-8") && !string4.equalsIgnoreCase("utf-16")) {
                throw new AssertionFailException("The value of the \"charset\" attribute of the Content-Type header is " + string2);
            }
            int n = entryContext.getMessageEntry().getMessage().indexOf("<?xml");
            if (n == -1) {
                throw new AssertionPassException();
            }
            int n2 = entryContext.getMessageEntry().getMessage().indexOf("?>");
            if (n2 == -1) {
                throw new AssertionPassException();
            }
            String string5 = entryContext.getMessageEntry().getMessage().substring(n, n2 + "?>".length());
            n = string5.indexOf("encoding");
            if (n == -1) {
                if (string4.equalsIgnoreCase("utf-8")) {
                    throw new AssertionPassException();
                }
                throw new AssertionFailException("There is no XML declaration and the charset value in the Content-Type header is not UTF-8.\nCharset value in the Content-Type header: " + string4);
            }
            int n3 = string5.indexOf(39, n);
            int n4 = string5.indexOf(34, n);
            int n5 = -1;
            int n6 = 0;
            if (n3 == -1) {
                n5 = n4;
                n6 = 34;
            } else if (n4 == -1) {
                n5 = n3;
                n6 = 39;
            } else if (n4 < n3) {
                n5 = n4;
                n6 = 34;
            } else {
                n5 = n3;
                n6 = 39;
            }
            if (n5 == -1 || n6 == 0) {
                throw new AssertionPassException();
            }
            int n7 = string5.indexOf(n6, n5 + 1);
            if (n7 == -1) {
                throw new AssertionPassException();
            }
            String string6 = string5.substring(n5 + 1, n7);
            if (string4.equalsIgnoreCase(string6)) {
                int n8 = 0;
                n8 = entryContext.getMessageEntry().getBOM();
                if (n8 != 0 && (n8 == 0xEFBBBF && !string6.equalsIgnoreCase("utf-8") || n8 == 65534 && !string6.equalsIgnoreCase("utf-16") || n8 == 65279 && !string6.equalsIgnoreCase("utf-16"))) {
                    throw new AssertionFailException("The BOM and XML declaration do not match.");
                }
                throw new AssertionPassException();
            }
            throw new AssertionFailException("There is an XML declaration, but its encoding value does not match the charset value.\nCharset value in the Content-Type header: " + string4 + "\nEncoding in the XML declaration: " + string6);
        }
        catch (AssertionPassException assertionPassException) {
            this.result = "passed";
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

