/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.message;

import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.SetCookie2Validator;
import org.wsi.util.HTTPUtils;

public class WSI1105
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public WSI1105(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        SetCookie2Validator setCookie2Validator = new SetCookie2Validator();
        String string = entryContext.getMessageEntry().getHTTPHeaders();
        if (entryContext.getMessageEntry().getType().equalsIgnoreCase("response")) {
            String string2 = (String)HTTPUtils.getHttpHeaderTokens(string, ":").get("Set-Cookie2");
            if (string2 == null) {
                this.result = "notApplicable";
            } else if (setCookie2Validator.isSetCookie2(string2.trim())) {
                this.result = "passed";
            } else {
                this.result = "warning";
                this.failureDetail = this.validator.createFailureDetail("\nMessage:\nHeaders:\n" + entryContext.getMessageEntry().getHTTPHeaders() + "\nSOAP message:\n" + entryContext.getMessageEntry().getMessage(), entryContext);
            }
        } else {
            String string3 = (String)HTTPUtils.getHttpHeaderTokens(string, ":").get("Cookie");
            if (string3 == null) {
                this.result = "notApplicable";
            } else if (setCookie2Validator.isCookie(string3.trim())) {
                this.result = "passed";
            } else {
                this.result = "warning";
                this.failureDetail = this.validator.createFailureDetail("\nMessage:\nHeaders:\n" + entryContext.getMessageEntry().getHTTPHeaders() + "\nSOAP message:\n" + entryContext.getMessageEntry().getMessage(), entryContext);
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

