/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.uddi;

import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import org.uddi4j.datatype.OverviewDoc;
import org.uddi4j.datatype.tmodel.TModel;
import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.uddi.UDDIValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.wsdl.WSDLDocument;

public class BP3001
extends AssertionProcess {
    private final UDDIValidatorImpl validator;

    public BP3001(UDDIValidatorImpl uDDIValidatorImpl) {
        super(uDDIValidatorImpl);
        this.validator = uDDIValidatorImpl;
    }

    private void setFaultMessage(String string) {
        this.result = "failed";
        this.failureDetailMessage = "The tModel key is: [" + string + "].";
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        Binding binding = null;
        TModel tModel = (TModel)entryContext.getEntry().getEntryDetail();
        if (tModel == null) {
            this.result = "failed";
            this.failureDetailMessage = "Could not locate a tModel.";
            return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetailMessage);
        }
        String string = tModel.getTModelKey();
        OverviewDoc overviewDoc = tModel.getOverviewDoc();
        if (overviewDoc != null) {
            Object object;
            String string2 = overviewDoc.getOverviewURLString();
            try {
                object = new WSDLDocument(string2);
                Definition definition = ((WSDLDocument)object).getDefinitions();
                Map map = definition.getNamespaces();
                if (!map.containsValue("http://schemas.xmlsoap.org/wsdl/")) {
                    string2 = null;
                }
                if ((binding = this.validator.getBinding(string2, (WSDLDocument)object)) == null || definition.getBinding(binding.getQName()) == null) {
                    string2 = null;
                }
            }
            catch (Exception exception) {
                string2 = null;
            }
            if (string2 != null) {
                object = null;
                int n = string2.indexOf("#");
                if (n > -1) {
                    object = string2.substring(n + 1);
                }
                if (object != null && ((String)object).length() != 0 && (((String)object).toUpperCase().indexOf("xpointer(".toUpperCase()) == -1 || ((String)object).lastIndexOf(")") != ((String)object).length() - 1)) {
                    this.setFaultMessage(string);
                }
            } else {
                this.setFaultMessage(string);
            }
        } else {
            this.setFaultMessage(string);
        }
        if (this.result == "passed") {
            this.validator.setWSDLBinding(binding);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetailMessage);
    }
}

