/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Binding;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.xml.XMLUtils;

public class AP2908
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;

    public AP2908(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
            Document document = XMLUtils.parseXMLDocument(this.validator.wsdlURL);
            Element element = this.getBindingElement(document.getDocumentElement(), binding.getQName().getLocalPart());
            List list = this.getChildElements(element, WSITag.WSDL_OPERATION);
            boolean bl = false;
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                Element element3 = this.getChildElement(element2, WSITag.WSDL_INPUT);
                Element element4 = this.getChildElement(element2, WSITag.WSDL_OUTPUT);
                List list2 = this.getMimeMultipartElements(element3);
                List list3 = this.getMimeMultipartElements(element4);
                if (!list2.isEmpty()) {
                    bl = true;
                    if (this.containsInvalidMimePart(list2)) {
                        throw new AssertionFailException("The invalid mime:part element is in the wsdl:input of the \"" + element2.getAttribute("name") + "\" binding operation.");
                    }
                }
                if (list3.isEmpty()) continue;
                bl = true;
                if (!this.containsInvalidMimePart(list3)) continue;
                throw new AssertionFailException("The invalid mime:part element is in the wsdl:output of the \"" + element2.getAttribute("name") + "\" binding operation.");
            }
            if (!bl) {
                throw new AssertionNotApplicableException();
            }
        }
        catch (IOException iOException) {
            this.result = "notApplicable";
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean containsInvalidMimePart(List list) {
        for (int i = 0; i < list.size(); ++i) {
            List list2 = this.getChildElements((Element)list.get(i), WSITag.WSDL_MIME_PART);
            for (int j = 0; j < list2.size(); ++j) {
                Element element = (Element)list2.get(j);
                if (element.getAttributeNode("name") == null) continue;
                return true;
            }
        }
        return false;
    }

    private List getMimeMultipartElements(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if (element != null) {
            Element element2 = XMLUtils.getFirstChild(element);
            while (element2 != null) {
                if (element2.getNamespaceURI().equals(WSITag.WSDL_MIME_MULTIPART.getNamespaceURI()) && element2.getLocalName().equals(WSITag.WSDL_MIME_MULTIPART.getLocalPart())) {
                    arrayList.add(element2);
                    List list = this.getChildElements(element2, WSITag.WSDL_MIME_PART);
                    for (int i = 0; i < list.size(); ++i) {
                        List list2 = this.getMimeMultipartElements((Element)list.get(i));
                        arrayList.addAll(list2);
                    }
                }
                element2 = XMLUtils.getNextSibling(element2);
            }
        }
        return arrayList;
    }

    private Element getChildElement(Element element, QName qName) {
        Element element2 = XMLUtils.getFirstChild(element);
        while (element2 != null) {
            if (element2.getNamespaceURI().equals(qName.getNamespaceURI()) && element2.getLocalName().equals(qName.getLocalPart())) {
                return element2;
            }
            element2 = XMLUtils.getNextSibling(element2);
        }
        return null;
    }

    private List getChildElements(Element element, QName qName) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if (element != null) {
            Element element2 = XMLUtils.getFirstChild(element);
            while (element2 != null) {
                if (element2.getNamespaceURI().equals(qName.getNamespaceURI()) && element2.getLocalName().equals(qName.getLocalPart())) {
                    arrayList.add(element2);
                }
                element2 = XMLUtils.getNextSibling(element2);
            }
        }
        return arrayList;
    }

    private Element getBindingElement(Element element, String string) {
        Element element2 = XMLUtils.getFirstChild(element);
        while (element2 != null) {
            if (element2.getNamespaceURI().equals(WSITag.WSDL_BINDING.getNamespaceURI()) && element2.getLocalName().equals(WSITag.WSDL_BINDING.getLocalPart()) && element2.getAttribute("name").equals(string)) {
                return element2;
            }
            element2 = XMLUtils.getNextSibling(element2);
        }
        return null;
    }
}

