/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.ErrorList;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;

public class BP2014
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();

    public BP2014(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    private String getSOAPBindingStyle(Binding binding) {
        String string = null;
        List list = binding.getExtensibilityElements();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof SOAPBinding)) continue;
            string = ((SOAPBinding)list.get(i)).getStyle();
            break;
        }
        if (string == null) {
            string = "document";
        }
        return string;
    }

    private SOAPBody getSOAPBody(List list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof SOAPBody)) continue;
            return (SOAPBody)list.get(i);
        }
        return null;
    }

    private SOAPOperation getSOAPOperation(List list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof SOAPOperation)) continue;
            return (SOAPOperation)list.get(i);
        }
        return null;
    }

    private boolean checkRpcLiteral(BindingOperation bindingOperation, Binding binding) {
        String string;
        List list = bindingOperation.getExtensibilityElements();
        SOAPOperation sOAPOperation = this.getSOAPOperation(list);
        if (sOAPOperation == null) {
            return false;
        }
        String string2 = string = sOAPOperation.getStyle() == null ? this.getSOAPBindingStyle(binding) : sOAPOperation.getStyle();
        if (!string.equals("rpc")) {
            return false;
        }
        list = bindingOperation.getBindingOutput().getExtensibilityElements();
        SOAPBody sOAPBody = this.getSOAPBody(list);
        if (sOAPBody == null) {
            return false;
        }
        String string3 = sOAPBody.getUse();
        if (string3 == null) {
            return false;
        }
        return string3.equals("literal");
    }

    public void visit(Operation operation, Object object, WSDLTraversalContext wSDLTraversalContext) {
        Binding[] bindingArray = this.validator.analyzerContext.getCandidateInfo().getBindings();
        if (operation.getParameterOrdering() == null) {
            this.result = "notApplicable";
            return;
        }
        if (bindingArray == null || operation == null) {
            this.result = "notApplicable";
            return;
        }
        if (operation.getOutput() == null) {
            this.result = "notApplicable";
            return;
        }
        if (operation.getOutput().getMessage() == null) {
            this.result = "notApplicable";
            return;
        }
        for (int i = 0; i < bindingArray.length; ++i) {
            List list = bindingArray[i].getBindingOperations();
            for (int j = 0; j < list.size(); ++j) {
                BindingOperation bindingOperation = (BindingOperation)list.get(j);
                if (operation.getName() != null && bindingOperation.getName() != null) {
                    if (!operation.getName().equals(bindingOperation.getName())) continue;
                    if (this.checkRpcLiteral(bindingOperation, bindingArray[i])) {
                        List list2 = operation.getParameterOrdering();
                        Output output = null;
                        Message message = null;
                        Map map = null;
                        output = operation.getOutput();
                        if (output != null && (message = output.getMessage()) != null) {
                            map = message.getParts();
                        }
                        if (list2 != null && map != null) {
                            int n = 0;
                            Iterator iterator = list2.iterator();
                            while (iterator.hasNext()) {
                                String string = (String)iterator.next();
                                if (!map.containsKey(string)) continue;
                                ++n;
                            }
                            if (n == map.size() || n == map.size() - 1) {
                                this.result = "passed";
                            } else {
                                this.errors.add(operation.getName());
                                wSDLTraversalContext.cancelOperationProcessing();
                            }
                            return;
                        }
                        this.result = list2 == null ? "notApplicable" : "passed";
                        return;
                    }
                    this.result = "notApplicable";
                    return;
                }
                this.result = "notApplicable";
                return;
            }
        }
        this.result = "notApplicable";
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal wSDLTraversal = new WSDLTraversal();
        wSDLTraversal.setVisitor(this);
        wSDLTraversal.visitOperation(true);
        wSDLTraversal.ignoreImport();
        wSDLTraversal.traverse((Operation)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext, entryContext.getEntry().getEntryDetail());
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

