/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.report.FailureDetail;

public class BP2017
extends AssertionProcess {
    private final WSDLValidatorImpl validator;

    public BP2017(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Vector<FailureDetail> vector = new Vector<FailureDetail>();
        Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
        if (binding == null) {
            this.result = "notApplicable";
            return this.validator.createAssertionResult(testAssertion, this.result, vector);
        }
        SOAPBinding sOAPBinding = WSDLValidatorImpl.getSoapBinding(binding);
        if (sOAPBinding == null) {
            this.result = "notApplicable";
            return this.validator.createAssertionResult(testAssertion, this.result, vector);
        }
        String string = sOAPBinding.getStyle() == null ? "document" : sOAPBinding.getStyle();
        HashMap hashMap = this.validator.getSoapOperations(binding);
        if (hashMap.isEmpty()) {
            this.result = "notApplicable";
        } else {
            String string2 = null;
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                SOAPOperation sOAPOperation = (SOAPOperation)iterator.next();
                String string3 = sOAPOperation.getStyle();
                if (string3 == null) {
                    string3 = string;
                }
                if (string3 != null && !string3.equals("document") && !string3.equals("rpc")) {
                    this.result = "failed";
                    vector.add(this.validator.createFailureDetail("Operation Name: " + hashMap.get(sOAPOperation) + "\nSOAP Operation: " + sOAPOperation.toString(), entryContext, sOAPOperation));
                }
                if (string2 == null) {
                    string2 = string3;
                    continue;
                }
                if (string2.equals(string3) && string2.equals(string)) continue;
                this.result = "failed";
                vector.add(this.validator.createFailureDetail("Operation Name: " + hashMap.get(sOAPOperation) + "\nSOAP Operation: " + sOAPOperation.toString(), entryContext, sOAPOperation));
            }
            if (string2 == null) {
                this.result = "notApplicable";
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, vector);
    }
}

