/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.extensions.soap.SOAPFault;
import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;

public class BP2032
extends AssertionProcess {
    private final WSDLValidatorImpl validator;

    public BP2032(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
        BindingFault[] bindingFaultArray = this.validator.getAllBindingFaults(binding);
        if (bindingFaultArray == null || bindingFaultArray.length == 0) {
            this.result = "passed";
        } else {
            for (int i = 0; i < bindingFaultArray.length; ++i) {
                BindingFault bindingFault = bindingFaultArray[i];
                SOAPFault sOAPFault = this.validator.getSoapFault(bindingFault);
                if (sOAPFault != null && sOAPFault.getName() != null && bindingFault.getName() != null && bindingFault.getName().equals(sOAPFault.getName())) continue;
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail(sOAPFault == null ? null : sOAPFault.toString(), entryContext);
                break;
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

