/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import javax.wsdl.Definition;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.ErrorList;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;
import org.wsi.xml.XMLTags;
import org.wsi.xml.XMLUtils;

public class BP2103
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();

    public BP2103(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public void visit(ExtensibilityElement extensibilityElement, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (extensibilityElement instanceof UnknownExtensibilityElement) {
            this.searchForImport(((UnknownExtensibilityElement)extensibilityElement).getElement());
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal wSDLTraversal = new WSDLTraversal();
        wSDLTraversal.setVisitor(this);
        wSDLTraversal.ignoreImport();
        wSDLTraversal.visitExtensibilityElement(true);
        wSDLTraversal.ignoreReferences();
        wSDLTraversal.traverse((Definition)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private void searchForImport(Node node) {
        while (node != null) {
            if (1 == node.getNodeType()) {
                if (XMLUtils.equals(node, XMLTags.ELEM_XSD_IMPORT)) {
                    Attr attr = XMLUtils.getAttribute((Element)node, XMLTags.ATTR_XSD_SCHEMALOCATION);
                    String string = attr != null ? attr.getValue() : "";
                    attr = XMLUtils.getAttribute((Element)node, XMLTags.ATTR_XSD_NAMESPACE);
                    String string2 = attr != null ? attr.getValue() : "";
                    this.errors.add(new QName(string2, string));
                } else if (!XMLUtils.equals(node, XMLTags.ELEM_XSD_SCHEMA)) {
                    this.searchForImport(node.getFirstChild());
                }
            }
            node = node.getNextSibling();
        }
    }
}

