/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.ErrorList;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;
import org.wsi.xml.XMLUtils;

public class BP2105
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();
    private boolean importFound = false;

    public BP2105(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public void visit(Import import_, Object object, WSDLTraversalContext wSDLTraversalContext) {
        this.importFound = true;
        if (import_.getDefinition() != null && import_.getLocationURI() != null) {
            this.processWSDL(import_.getDefinition().getDocumentBaseURI());
        }
    }

    private boolean isExtensibilityElement(Element element) {
        boolean bl = true;
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_BINDING);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_DEFINITIONS);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_DOCUMENTATION);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_FAULT);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_IMPORT);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_INPUT);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_MESSAGE);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_OPERATION);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_OUTPUT);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_PART);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_PORT);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_PORTTYPE);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_SERVICE);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_TYPES);
        return bl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        Definition definition = (Definition)entryContext.getEntry().getEntryDetail();
        if (definition.getImports() == null || definition.getImports().size() == 0) {
            this.result = "notApplicable";
        } else {
            this.processWSDL(definition.getDocumentBaseURI());
            WSDLTraversal wSDLTraversal = new WSDLTraversal();
            wSDLTraversal.setVisitor(this);
            wSDLTraversal.visitImport(true);
            wSDLTraversal.ignoreReferences();
            wSDLTraversal.ignoreImport();
            wSDLTraversal.traverse((Definition)entryContext.getEntry().getEntryDetail());
            if (!this.errors.isEmpty()) {
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
            } else {
                this.result = !this.importFound ? "notApplicable" : "passed";
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private void processWSDL(String string) {
        try {
            Document document = this.validator.parseXMLDocumentURL(string, null);
            this.checkWSDL(document.getDocumentElement());
        }
        catch (Throwable throwable) {
            this.errors.add(throwable.toString());
        }
    }

    private void createFailed(Node node) {
        Attr attr = XMLUtils.getAttribute((Element)node, WSITag.ATTR_WSDL_LOCATION);
        String string = attr != null ? attr.getValue() : "";
        attr = XMLUtils.getAttribute((Element)node, WSITag.ATTR_WSDL_NAMESPACE);
        String string2 = attr != null ? attr.getValue() : "";
        this.errors.add(new QName(string2, string));
    }

    private void checkWSDL(Node node) {
        if (node != null) {
            boolean bl;
            Element element = XMLUtils.findChildElement((Element)node, WSITag.WSDL_IMPORT);
            boolean bl2 = bl = XMLUtils.findChildElement((Element)node, WSITag.WSDL_DOCUMENTATION) != null;
            while (element != null) {
                Element element2 = XMLUtils.findPreviousSibling(element);
                if (element2 != null) {
                    while (this.isExtensibilityElement(element2) && element2 != null) {
                        if (element2 == null) continue;
                        element2 = XMLUtils.findPreviousSibling(element2);
                    }
                }
                if (bl && element2 != null) {
                    if (!XMLUtils.equals(element2, WSITag.WSDL_DOCUMENTATION) && !XMLUtils.equals(element2, WSITag.WSDL_IMPORT)) {
                        this.createFailed(node);
                    }
                } else if (element2 != null && !XMLUtils.equals(element2, WSITag.WSDL_DEFINITIONS) && !XMLUtils.equals(element2, WSITag.WSDL_IMPORT) && element2.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/")) {
                    this.createFailed(node);
                }
                element = XMLUtils.findElement(element, WSITag.WSDL_IMPORT);
            }
        }
    }
}

