/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOutput;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.ErrorList;
import org.wsi.test.util.TypesRegistry;
import org.wsi.test.util.WSDLUtil;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;

public class BP2121
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();
    private TypesRegistry registry = null;

    public BP2121(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public void visit(SOAPBinding sOAPBinding, Object object, WSDLTraversalContext wSDLTraversalContext) {
        String string = sOAPBinding.getStyle() == null ? "document" : sOAPBinding.getStyle();
        wSDLTraversalContext.addParameter("style", string);
    }

    public void visit(SOAPOperation sOAPOperation, Object object, WSDLTraversalContext wSDLTraversalContext) {
        String string = sOAPOperation.getStyle();
        if (string == null) {
            string = (String)wSDLTraversalContext.getParameter("style");
        }
        if (!"document".equals(string)) {
            wSDLTraversalContext.cancelBindingOperationProcessing();
        }
    }

    public void visit(SOAPBody sOAPBody, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if ("literal".equals(sOAPBody.getUse())) {
            Message message;
            Operation operation = wSDLTraversalContext.getBindingOperation().getOperation();
            if (operation == null || object instanceof BindingInput && operation.getInput() == null || object instanceof BindingOutput && operation.getOutput() == null) {
                return;
            }
            Message message2 = message = object instanceof BindingInput ? operation.getInput().getMessage() : operation.getOutput().getMessage();
            if (message == null) {
                return;
            }
            List list = WSDLUtil.getParts(operation, message, sOAPBody, "document");
            if (list == null) {
                return;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Part part = (Part)iterator.next();
                if (part.getElementName() != null && this.registry.getType(part.getElementName()) != null) continue;
                this.errors.add(operation.getName());
                wSDLTraversalContext.cancelBindingOperationProcessing();
            }
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        this.registry = new TypesRegistry(entryContext.getWSDLDocument().getDefinitions(), this.validator);
        WSDLTraversal wSDLTraversal = new WSDLTraversal();
        wSDLTraversal.setVisitor(this);
        wSDLTraversal.visitSOAPBinding(true);
        wSDLTraversal.visitSOAPBody(true);
        wSDLTraversal.visitSOAPOperation(true);
        wSDLTraversal.ignoreReferences();
        wSDLTraversal.ignoreImport();
        wSDLTraversal.traverse((Binding)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

