/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wsi.WSIException;
import org.wsi.WSIRuntimeException;
import org.wsi.test.analyzer.AnalyzerContext;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.CandidateInfo;
import org.wsi.test.analyzer.ServiceReference;
import org.wsi.test.analyzer.config.WSDLElement;
import org.wsi.test.profile.ProfileArtifact;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.WSDLValidator;
import org.wsi.test.profile.validator.impl.BaseValidatorImpl;
import org.wsi.test.report.Entry;
import org.wsi.test.report.EntryContainer;
import org.wsi.test.report.FailureDetail;
import org.wsi.test.report.ReportArtifact;
import org.wsi.test.report.Reporter;
import org.wsi.test.util.EntryType;
import org.wsi.wsdl.WSDLDocument;
import org.wsi.wsdl.WSDLElementList;
import org.wsi.wsdl.WSDLUtils;
import org.wsi.xml.dom.ElementLocation;
import org.wsi.xml.schema.TargetNamespaceProcessor;
import org.wsi.xml.schema.XMLSchemaValidator;

public class WSDLValidatorImpl
extends BaseValidatorImpl
implements WSDLValidator {
    protected String wsdlURL;
    protected WSDLDocument wsdlDocument = null;
    protected HashMap containerMap = new HashMap();

    public void init(AnalyzerContext analyzerContext, ProfileArtifact profileArtifact, ReportArtifact reportArtifact, String string, WSDLDocument wSDLDocument, Reporter reporter) throws WSIException {
        super.init(analyzerContext, profileArtifact, reportArtifact, reporter);
        this.wsdlDocument = wSDLDocument;
        if (wSDLDocument != null) {
            this.wsdlURL = wSDLDocument.getLocation();
        }
        if (string != null) {
            this.wsdlURL = string;
        }
    }

    public WSDLDocument validate() throws WSIException {
        Object var1_1 = null;
        Service service = null;
        Port port = null;
        Binding binding = null;
        PortType portType = null;
        Operation operation = null;
        Message message = null;
        String string = this.getClass().getPackage().getName() + ".";
        try {
            if (this.wsdlDocument == null) {
                this.wsdlDocument = new WSDLDocument(this.wsdlURL);
            }
        }
        catch (Exception exception) {
            throw new WSIException(exception.getMessage(), exception);
        }
        Definition definition = this.wsdlDocument.getDefinitions();
        ServiceReference serviceReference = this.analyzerContext.getServiceReference();
        CandidateInfo candidateInfo = new CandidateInfo(serviceReference, this.wsdlDocument);
        this.analyzerContext.setCandidateInfo(candidateInfo);
        this.reporter.setPrereqType("entryContainer");
        this.processDefinitionAssertions(string, candidateInfo);
        this.processTypesAssertions(string, candidateInfo);
        this.processImportAssertions(string, candidateInfo);
        if (serviceReference.getWSDLElement().isPort()) {
            service = definition.getService(serviceReference.getWSDLElement().getParentElementQName());
            if (service == null) {
                throw new WSIRuntimeException("Could not locate WSDL service: " + serviceReference.getWSDLElement().getParentElementName());
            }
            port = service.getPort(serviceReference.getWSDLElement().getName());
            if (port == null) {
                throw new WSIRuntimeException("Could not locate WSDL port: " + serviceReference.getWSDLElement().getName());
            }
            binding = port.getBinding();
            if (binding == null || binding.isUndefined()) {
                this.setMissingInput(EntryType.getEntryType("binding"));
                this.setMissingInput(EntryType.getEntryType("portType"));
                this.setMissingInput(EntryType.getEntryType("operation"));
                this.setMissingInput(EntryType.getEntryType("message"));
            } else {
                this.processBindingAssertions(binding, serviceReference, string, this.wsdlDocument);
                portType = binding.getPortType();
                if (portType == null || portType.isUndefined()) {
                    this.setMissingInput(EntryType.getEntryType("portType"));
                    this.setMissingInput(EntryType.getEntryType("operation"));
                    this.setMissingInput(EntryType.getEntryType("message"));
                } else {
                    this.processMessageAssertions(binding, serviceReference, string, this.wsdlDocument);
                    this.processPortTypeAssertions(portType, serviceReference, string, this.wsdlDocument);
                    this.processOperationAssertions(portType, serviceReference, string, this.wsdlDocument);
                    this.processMessageAssertions(portType, serviceReference, string, this.wsdlDocument);
                }
            }
        } else if (serviceReference.getWSDLElement().isBinding()) {
            WSDLElement wSDLElement = serviceReference.getWSDLElement();
            if (wSDLElement.getQName() != null && wSDLElement.getQName().getLocalPart() != null && wSDLElement.getQName().getLocalPart().length() > 0) {
                binding = definition.getBinding(serviceReference.getWSDLElement().getQName());
                if (binding == null || binding.isUndefined()) {
                    throw new WSIRuntimeException("Could not locate WSDL binding: " + serviceReference.getWSDLElement().getName());
                }
                this.processBindingAssertions(binding, serviceReference, string, this.wsdlDocument);
                this.processMessageAssertions(binding, serviceReference, string, this.wsdlDocument);
                portType = binding.getPortType();
                if (portType == null || portType.isUndefined()) {
                    this.setMissingInput(EntryType.getEntryType("portType"));
                    this.setMissingInput(EntryType.getEntryType("operation"));
                    this.setMissingInput(EntryType.getEntryType("message"));
                } else {
                    this.processPortTypeAssertions(portType, serviceReference, string, this.wsdlDocument);
                    this.processOperationAssertions(portType, serviceReference, string, this.wsdlDocument);
                    this.processMessageAssertions(portType, serviceReference, string, this.wsdlDocument);
                }
            } else {
                this.setMissingInput(EntryType.getEntryType("binding"));
                this.setMissingInput(EntryType.getEntryType("portType"));
                this.setMissingInput(EntryType.getEntryType("operation"));
                this.setMissingInput(EntryType.getEntryType("message"));
            }
        } else if (serviceReference.getWSDLElement().isPortType()) {
            portType = definition.getPortType(serviceReference.getWSDLElement().getQName());
            if (portType == null || portType.isUndefined()) {
                throw new WSIRuntimeException("Could not locate WSDL PortType: " + serviceReference.getWSDLElement().getName());
            }
            this.setMissingInput(EntryType.getEntryType("binding"));
            this.processPortTypeAssertions(portType, serviceReference, string, this.wsdlDocument);
            this.processOperationAssertions(portType, serviceReference, string, this.wsdlDocument);
            this.processMessageAssertions(portType, serviceReference, string, this.wsdlDocument);
        } else if (serviceReference.getWSDLElement().isOperation()) {
            portType = definition.getPortType(serviceReference.getWSDLElement().getParentElementQName());
            if (portType == null || portType.isUndefined()) {
                throw new WSIRuntimeException("Could not locate WSDL portType: " + serviceReference.getWSDLElement().getParentElementQName());
            }
            operation = this.getOperationFromPortType(portType, serviceReference.getWSDLElement().getName());
            if (operation == null || operation.isUndefined()) {
                throw new WSIRuntimeException("Could not locate WSDL Operation: " + serviceReference.getWSDLElement().getName() + "in portType: " + portType.getQName());
            }
            this.setMissingInput(EntryType.getEntryType("binding"));
            this.setMissingInput(EntryType.getEntryType("portType"));
            this.processOperationAssertions(operation, portType, serviceReference, string, this.wsdlDocument);
            this.processMessageAssertions(operation, serviceReference, string, this.wsdlDocument);
        } else if (serviceReference.getWSDLElement().isMessage()) {
            message = definition.getMessage(serviceReference.getWSDLElement().getQName());
            if (message == null || message.isUndefined()) {
                throw new WSIRuntimeException("Could not locate WSDL Message: " + serviceReference.getWSDLElement().getName());
            }
            this.setMissingInput(EntryType.getEntryType("binding"));
            this.setMissingInput(EntryType.getEntryType("portType"));
            this.setMissingInput(EntryType.getEntryType("operation"));
            this.processMessageAssertions(message, serviceReference, string, this.wsdlDocument);
        } else {
            throw new WSIRuntimeException("The following WSDL type is not supported: " + serviceReference.getWSDLElement().getType());
        }
        this.cleanup();
        return this.wsdlDocument;
    }

    protected EntryContainer getEntryContainer(String string) {
        EntryContainer entryContainer = null;
        entryContainer = (EntryContainer)this.containerMap.get(string);
        if (entryContainer == null) {
            entryContainer = this.reporter.createEntryContainer();
            entryContainer.setId(string);
            this.containerMap.put(string, entryContainer);
        }
        return entryContainer;
    }

    protected Operation getOperationFromPortType(PortType portType, String string) {
        Operation operation = null;
        if (portType.getOperations() != null) {
            Iterator iterator = portType.getOperations().iterator();
            while (iterator.hasNext()) {
                operation = (Operation)iterator.next();
                if (!string.equals(operation.getName())) continue;
                return operation;
            }
        }
        return null;
    }

    protected void processDefinitionAssertions(String string, CandidateInfo candidateInfo) throws WSIException {
        Entry entry = null;
        Definition[] definitionArray = candidateInfo.getDefinitions();
        for (int i = 0; i < definitionArray.length; ++i) {
            Definition definition = definitionArray[i];
            if (definition == null) continue;
            entry = this.reporter.getReport().createEntry();
            entry.setEntryType(EntryType.getEntryType("definitions"));
            entry.setReferenceID(definition.getDocumentBaseURI());
            entry.setEntryDetail(definition);
            entry.setEntryContainer(this.getEntryContainer(definition.getDocumentBaseURI()));
            this.processAssertions(string, new EntryContext(entry, candidateInfo.getWsdlDocument()));
        }
    }

    protected void processTypesAssertions(String string, CandidateInfo candidateInfo) throws WSIException {
        Entry entry = null;
        Types[] typesArray = candidateInfo.getTypes();
        Definition[] definitionArray = candidateInfo.getDefinitions();
        if (typesArray == null || typesArray.length == 0) {
            this.setMissingInput(EntryType.getEntryType("types"));
        } else {
            for (int i = 0; i < typesArray.length; ++i) {
                Types types = typesArray[i];
                if (types == null) continue;
                entry = this.reporter.getReport().createEntry();
                entry.setEntryType(EntryType.getEntryType("types"));
                entry.setReferenceID(candidateInfo.getDefinition(types).getDocumentBaseURI() + "-Types");
                entry.setEntryDetail(types);
                entry.setEntryContainer(this.getEntryContainer(definitionArray[i].getDocumentBaseURI()));
                this.processAssertions(string, new EntryContext(entry, candidateInfo.getWsdlDocument()));
            }
        }
    }

    protected void processImportAssertions(String string, CandidateInfo candidateInfo) throws WSIException {
        Entry entry = null;
        Import[] importArray = candidateInfo.getImports();
        if (importArray == null || importArray.length == 0) {
            this.setMissingInput(EntryType.getEntryType("import"));
        } else {
            for (int i = 0; i < importArray.length; ++i) {
                Import import_ = importArray[i];
                entry = this.reporter.getReport().createEntry();
                entry.setEntryType(EntryType.getEntryType("import"));
                entry.setReferenceID(import_.getNamespaceURI());
                entry.setEntryDetail(import_);
                entry.setEntryContainer(this.getEntryContainer(import_.getLocationURI()));
                this.processAssertions(string, new EntryContext(entry, candidateInfo.getWsdlDocument()));
            }
        }
    }

    protected void processPortAssertions(Port port, ServiceReference serviceReference, String string, WSDLDocument wSDLDocument) throws WSIException {
        Entry entry = null;
        entry = this.reporter.getReport().createEntry();
        entry.setEntryType(EntryType.getEntryType("port"));
        entry.setReferenceID(port.getName());
        entry.setParentElementName(serviceReference.getWSDLElement().getParentElementName());
        entry.setEntryDetail(port);
        this.processAssertions(string, new EntryContext(entry, wSDLDocument));
    }

    protected void processBindingAssertions(Binding binding, ServiceReference serviceReference, String string, WSDLDocument wSDLDocument) throws WSIException {
        Entry entry = null;
        QName qName = binding.getQName();
        entry = this.reporter.getReport().createEntry();
        entry.setEntryType(EntryType.getEntryType("binding"));
        entry.setReferenceID(qName.toString());
        entry.setEntryDetail(binding);
        Definition definition = this.analyzerContext.getCandidateInfo().getDefinition(binding);
        entry.setEntryContainer(this.getEntryContainer(definition == null ? null : definition.getDocumentBaseURI()));
        this.processAssertions(string, new EntryContext(entry, wSDLDocument));
    }

    protected void processPortTypeAssertions(PortType portType, ServiceReference serviceReference, String string, WSDLDocument wSDLDocument) throws WSIException {
        Entry entry = null;
        QName qName = portType.getQName();
        entry = this.reporter.getReport().createEntry();
        entry.setEntryType(EntryType.getEntryType("portType"));
        entry.setReferenceID(qName.toString());
        entry.setEntryDetail(portType);
        Definition definition = this.analyzerContext.getCandidateInfo().getDefinition(portType);
        entry.setEntryContainer(this.getEntryContainer(definition == null ? null : definition.getDocumentBaseURI()));
        this.processAssertions(string, new EntryContext(entry, wSDLDocument));
    }

    protected void processOperationAssertions(Operation operation, PortType portType, ServiceReference serviceReference, String string, WSDLDocument wSDLDocument) throws WSIException {
        Entry entry = null;
        entry = this.reporter.getReport().createEntry();
        entry.setEntryType(EntryType.getEntryType("operation"));
        entry.setReferenceID(operation.getName());
        entry.setParentElementName(portType.getQName().getLocalPart());
        entry.setEntryDetail(operation);
        Definition definition = this.analyzerContext.getCandidateInfo().getDefinition(portType);
        entry.setEntryContainer(this.getEntryContainer(definition == null ? null : definition.getDocumentBaseURI()));
        this.processAssertions(string, new EntryContext(entry, wSDLDocument));
    }

    protected void processOperationAssertions(PortType portType, ServiceReference serviceReference, String string, WSDLDocument wSDLDocument) throws WSIException {
        if (portType.getOperations() == null) {
            this.setMissingInput(EntryType.getEntryType("operation"));
        } else {
            Iterator iterator = portType.getOperations().iterator();
            while (iterator.hasNext()) {
                Operation operation = (Operation)iterator.next();
                if (operation == null || operation.isUndefined()) {
                    this.setMissingInput(EntryType.getEntryType("operation"));
                    continue;
                }
                this.processOperationAssertions(operation, portType, serviceReference, string, wSDLDocument);
            }
        }
    }

    protected void processMessageAssertions(Message message, ServiceReference serviceReference, String string, WSDLDocument wSDLDocument) throws WSIException {
        Entry entry = null;
        QName qName = message.getQName();
        entry = this.reporter.getReport().createEntry();
        entry.setEntryType(EntryType.getEntryType("message"));
        entry.setReferenceID(qName.toString());
        entry.setEntryDetail(message);
        Definition definition = this.analyzerContext.getCandidateInfo().getDefinition(message);
        entry.setEntryContainer(this.getEntryContainer(definition == null ? null : definition.getDocumentBaseURI()));
        this.processAssertions(string, new EntryContext(entry, wSDLDocument));
    }

    protected void processMessageAssertions(Binding binding, ServiceReference serviceReference, String string, WSDLDocument wSDLDocument) throws WSIException {
        HashSet hashSet;
        if (binding.getBindingOperations() != null && (hashSet = WSDLUtils.findMessages(wSDLDocument.getDefinitions(), binding)).size() > 0) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Message message = (Message)iterator.next();
                if (message.isUndefined()) continue;
                this.processMessageAssertions(message, serviceReference, string, wSDLDocument);
            }
        }
    }

    protected void processMessageAssertions(PortType portType, ServiceReference serviceReference, String string, WSDLDocument wSDLDocument) throws WSIException {
        HashSet<Message> hashSet = new HashSet<Message>();
        if (portType.getOperations() != null) {
            Object object;
            Iterator iterator = portType.getOperations().iterator();
            while (iterator.hasNext()) {
                object = (Operation)iterator.next();
                if (object.getInput() != null && !object.getInput().getMessage().isUndefined()) {
                    hashSet.add(object.getInput().getMessage());
                }
                if (object.getOutput() != null && !object.getOutput().getMessage().isUndefined()) {
                    hashSet.add(object.getOutput().getMessage());
                }
                if (object.getFaults() == null) continue;
                Iterator iterator2 = object.getFaults().values().iterator();
                while (iterator2.hasNext()) {
                    Message message = ((Fault)iterator2.next()).getMessage();
                    if (message.isUndefined()) continue;
                    hashSet.add(message);
                }
            }
            if (hashSet.size() == 0) {
                this.setMissingInput(EntryType.getEntryType("message"));
            } else {
                object = hashSet.iterator();
                while (object.hasNext()) {
                    this.processMessageAssertions((Message)object.next(), serviceReference, string, wSDLDocument);
                }
            }
        }
    }

    protected void processMessageAssertions(Operation operation, ServiceReference serviceReference, String string, WSDLDocument wSDLDocument) throws WSIException {
        HashSet<Message> hashSet = new HashSet<Message>();
        if (operation.getInput() != null && !operation.getInput().getMessage().isUndefined()) {
            hashSet.add(operation.getInput().getMessage());
        }
        if (operation.getOutput() != null && !operation.getOutput().getMessage().isUndefined()) {
            hashSet.add(operation.getOutput().getMessage());
        }
        Iterator iterator = operation.getFaults().values().iterator();
        while (iterator.hasNext()) {
            Message message = ((Fault)iterator.next()).getMessage();
            if (message.isUndefined()) continue;
            hashSet.add(message);
        }
        if (hashSet.size() == 0) {
            this.setMissingInput(EntryType.getEntryType("message"));
        } else {
            Iterator iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                this.processMessageAssertions((Message)iterator2.next(), serviceReference, string, wSDLDocument);
            }
        }
    }

    protected boolean isPrimaryEntryTypeMatch(TestAssertion testAssertion, EntryContext entryContext) {
        boolean bl = false;
        if (testAssertion.getEntryTypeName().equals(entryContext.getEntry().getEntryType().getTypeName())) {
            bl = true;
        }
        return bl;
    }

    protected boolean isNotApplicable(TestAssertion testAssertion) {
        boolean bl = false;
        return bl;
    }

    protected SOAPFault[] getSoapFaults(Binding binding) throws WSIException {
        Vector<SOAPFault> vector = new Vector<SOAPFault>();
        BindingFault[] bindingFaultArray = this.getAllBindingFaults(binding);
        for (int i = 0; i < bindingFaultArray.length; ++i) {
            SOAPFault sOAPFault = this.getSoapFault(bindingFaultArray[i]);
            if (sOAPFault == null) continue;
            vector.add(sOAPFault);
        }
        Object[] objectArray = new SOAPFault[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected BindingFault[] getAllBindingFaults(Binding binding) throws WSIException {
        Object[] objectArray;
        Vector<BindingFault> vector = new Vector<BindingFault>();
        try {
            objectArray = binding.getBindingOperations().iterator();
            while (objectArray.hasNext()) {
                try {
                    BindingOperation bindingOperation = (BindingOperation)objectArray.next();
                    Iterator iterator = bindingOperation.getBindingFaults().values().iterator();
                    while (iterator.hasNext()) {
                        vector.add((BindingFault)iterator.next());
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        objectArray = new BindingFault[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected SOAPFault getSoapFault(BindingFault bindingFault) throws WSIException {
        SOAPFault sOAPFault = null;
        try {
            Iterator iterator = bindingFault.getExtensibilityElements().iterator();
            while (iterator.hasNext() && sOAPFault == null) {
                try {
                    sOAPFault = (SOAPFault)iterator.next();
                }
                catch (ClassCastException classCastException) {}
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return sOAPFault;
    }

    protected SOAPHeader[] getSoapHeaders(Binding binding) throws WSIException {
        Binding[] bindingArray = new Binding[]{binding};
        Vector<SOAPHeader> vector = new Vector<SOAPHeader>();
        for (int i = 0; i < bindingArray.length; ++i) {
            try {
                BindingOperation[] bindingOperationArray = bindingArray[i].getBindingOperations().toArray(new BindingOperation[0]);
                for (int j = 0; j < bindingOperationArray.length; ++j) {
                    try {
                        BindingInput bindingInput = bindingOperationArray[j].getBindingInput();
                        BindingOutput bindingOutput = bindingOperationArray[j].getBindingOutput();
                        Iterator iterator = bindingInput.getExtensibilityElements().iterator();
                        while (iterator.hasNext()) {
                            try {
                                vector.add((SOAPHeader)iterator.next());
                            }
                            catch (ClassCastException classCastException) {}
                        }
                        iterator = bindingOutput.getExtensibilityElements().iterator();
                        while (iterator.hasNext()) {
                            try {
                                vector.add((SOAPHeader)iterator.next());
                            }
                            catch (ClassCastException classCastException) {}
                        }
                        continue;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        Object[] objectArray = new SOAPHeader[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected SOAPHeaderFault[] getSoapHeaderFaults(Binding binding) throws WSIException {
        Vector vector = new Vector();
        SOAPHeader[] sOAPHeaderArray = this.getSoapHeaders(binding);
        List list = null;
        for (int i = 0; i < sOAPHeaderArray.length; ++i) {
            list = sOAPHeaderArray[i].getSOAPHeaderFaults();
            if (list == null) continue;
            vector.addAll(list);
        }
        Object[] objectArray = new SOAPHeaderFault[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected SOAPBody[] getSoapBodies(Binding binding) throws WSIException {
        Binding[] bindingArray = new Binding[]{binding};
        Vector<SOAPBody> vector = new Vector<SOAPBody>();
        for (int i = 0; i < bindingArray.length; ++i) {
            BindingOperation[] bindingOperationArray = bindingArray[i].getBindingOperations().toArray(new BindingOperation[0]);
            for (int j = 0; j < bindingOperationArray.length; ++j) {
                Iterator iterator;
                try {
                    iterator = bindingOperationArray[j].getBindingInput().getExtensibilityElements().iterator();
                    while (iterator.hasNext()) {
                        try {
                            vector.add((SOAPBody)iterator.next());
                        }
                        catch (ClassCastException classCastException) {}
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    iterator = bindingOperationArray[j].getBindingOutput().getExtensibilityElements().iterator();
                    while (iterator.hasNext()) {
                        try {
                            vector.add((SOAPBody)iterator.next());
                        }
                        catch (ClassCastException classCastException) {}
                    }
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        Object[] objectArray = new SOAPBody[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected SOAPBody getSoapBody(BindingInput bindingInput) throws WSIException {
        SOAPBody sOAPBody = null;
        Iterator iterator = bindingInput.getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SOAPBody)) continue;
            sOAPBody = (SOAPBody)e;
            break;
        }
        return sOAPBody;
    }

    protected SOAPBody getSoapBody(BindingOutput bindingOutput) throws WSIException {
        SOAPBody sOAPBody = null;
        Iterator iterator = bindingOutput.getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SOAPBody)) continue;
            sOAPBody = (SOAPBody)e;
            break;
        }
        return sOAPBody;
    }

    protected String getSchemaUsed(Definition definition) throws AssertionFailException {
        String string = "";
        try {
            Element element;
            Document document = this.parseXMLDocumentURL(definition.getDocumentBaseURI(), null);
            if (document != null && (element = document.getDocumentElement()) != null) {
                string = element.getNamespaceURI();
            }
        }
        catch (WSIException wSIException) {
            throw new AssertionFailException("problem getting WSDL defintions namespace");
        }
        return string;
    }

    public static SOAPBinding getSoapBinding(Binding binding) throws WSIException {
        SOAPBinding sOAPBinding = null;
        List list = binding.getExtensibilityElements();
        if (list != null) {
            Iterator iterator = binding.getExtensibilityElements().iterator();
            while (iterator.hasNext() && sOAPBinding == null) {
                try {
                    sOAPBinding = (SOAPBinding)iterator.next();
                }
                catch (ClassCastException classCastException) {}
            }
        }
        return sOAPBinding;
    }

    protected XMLSchemaValidator createXMLSchemaValidator(String string) {
        return new XMLSchemaValidator(string, this.documentList);
    }

    protected List getSchemaTargetNamespaceList(Definition definition) throws WSIException {
        Vector vector = null;
        List list = null;
        Types types = null;
        types = definition.getTypes();
        if (types != null) {
            Iterator iterator = types.getExtensibilityElements().iterator();
            ExtensibilityElement extensibilityElement = null;
            while (iterator.hasNext()) {
                extensibilityElement = (ExtensibilityElement)iterator.next();
                TargetNamespaceProcessor targetNamespaceProcessor = null;
                if (!(extensibilityElement instanceof UnknownExtensibilityElement)) continue;
                targetNamespaceProcessor = new TargetNamespaceProcessor(definition.getDocumentBaseURI(), this.documentList);
                list = targetNamespaceProcessor.processAllSchema(((UnknownExtensibilityElement)extensibilityElement).getElement());
                if (list != null && vector == null) {
                    vector = new Vector();
                }
                vector.addAll(list);
            }
        }
        return vector;
    }

    protected List getSchemaNamespaceList(Definition definition) throws WSIException {
        Map map;
        Vector vector = new Vector();
        List list = this.getSchemaTargetNamespaceList(definition);
        if (list != null && !list.isEmpty()) {
            vector.addAll(list);
        }
        if ((map = definition.getImports()) != null && !map.isEmpty()) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                List list2 = (List)iterator.next();
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    Import import_ = (Import)iterator2.next();
                    if (import_ == null || import_.getDefinition() == null) continue;
                    vector.addAll(this.getSchemaNamespaceList(import_.getDefinition()));
                }
            }
        }
        return vector;
    }

    protected List getWSDLTargetNamespaceList(Definition definition) {
        Map map;
        Vector<String> vector = new Vector<String>();
        if (definition.getTargetNamespace() != null) {
            vector.add(definition.getTargetNamespace());
        }
        if ((map = definition.getImports()) != null && !map.isEmpty()) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    Import import_ = (Import)iterator2.next();
                    if (import_ == null || import_.getDefinition() == null) continue;
                    vector.addAll(this.getWSDLTargetNamespaceList(import_.getDefinition()));
                }
            }
        }
        return vector;
    }

    public BindingMatch[] getBindingMatches(Binding binding, String string, String string2) throws WSIException {
        Object object;
        Vector<BindingMatch> vector = new Vector<BindingMatch>();
        SOAPBinding sOAPBinding = WSDLValidatorImpl.getSoapBinding(binding);
        if (sOAPBinding != null) {
            List list;
            object = sOAPBinding.getStyle();
            if (object == null) {
                object = "document";
            }
            if ((list = binding.getBindingOperations()) != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    SOAPBody sOAPBody;
                    BindingOutput bindingOutput;
                    BindingOperation bindingOperation = (BindingOperation)iterator.next();
                    SOAPOperation sOAPOperation = WSDLValidatorImpl.getSoapOperation(bindingOperation);
                    if (!(sOAPOperation == null && ((String)object).equals(string) || sOAPOperation != null && sOAPOperation.getStyle() == null && ((String)object).equals(string)) && (sOAPOperation == null || sOAPOperation.getStyle() == null || !sOAPOperation.getStyle().equals(string))) continue;
                    BindingInput bindingInput = bindingOperation.getBindingInput();
                    if (bindingInput != null && ((bindingOutput = this.getSoapBody(bindingInput)) == null || bindingOutput.getUse() != null && !bindingOutput.getUse().equals(string2))) {
                        bindingInput = null;
                    }
                    if ((bindingOutput = bindingOperation.getBindingOutput()) != null && ((sOAPBody = this.getSoapBody(bindingOutput)) == null || sOAPBody.getUse() != null && !sOAPBody.getUse().equals(string2))) {
                        bindingOutput = null;
                    }
                    if (bindingOutput == null && bindingInput == null) continue;
                    vector.add(new BindingMatch(binding, bindingOperation, sOAPBinding, bindingInput, bindingOutput));
                }
            }
        }
        object = new BindingMatch[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public static SOAPOperation getSoapOperation(BindingOperation bindingOperation) throws WSIException {
        if (bindingOperation.getExtensibilityElements() == null) {
            return null;
        }
        Iterator iterator = bindingOperation.getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SOAPOperation)) continue;
            return (SOAPOperation)e;
        }
        return null;
    }

    protected HashMap getSoapOperations(Binding binding) throws WSIException {
        HashMap hashMap = new HashMap();
        if (binding.getBindingOperations() == null) {
            return null;
        }
        Iterator iterator = binding.getBindingOperations().iterator();
        BindingOperation bindingOperation = null;
        while (iterator.hasNext()) {
            bindingOperation = (BindingOperation)iterator.next();
            Iterator iterator2 = bindingOperation.getExtensibilityElements().iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                if (!(e instanceof SOAPOperation)) continue;
                hashMap.put(e, bindingOperation.getName());
            }
        }
        return hashMap;
    }

    protected boolean checkPartAttributes(BindingMatch[] bindingMatchArray, String string, String string2) throws AssertionFailException {
        if (!string.equals("useInput") && !string.equals("useOutput") || !string2.equals("useType") && !string2.equals("useElement")) {
            return false;
        }
        for (int i = 0; i < bindingMatchArray.length; ++i) {
            BindingMatch bindingMatch = bindingMatchArray[i];
            BindingOperation bindingOperation = bindingMatch.getBindingOperation();
            if (bindingOperation == null) continue;
            Operation operation = bindingOperation.getOperation();
            try {
                Iterator<Object> iterator;
                Part part;
                Message message;
                if (string.equals("useInput")) {
                    if (operation.getInput() == null || !bindingMatch.hasBindingInput()) continue;
                    message = operation.getInput().getMessage();
                } else {
                    if (operation.getOutput() == null || !bindingMatch.hasBindingOutput()) continue;
                    message = operation.getOutput().getMessage();
                }
                if (message == null) continue;
                Map map = message.getParts();
                List list = null;
                list = this.getPartsList(bindingMatch, string);
                if (list != null) {
                    part = new Vector();
                    Iterator iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        part.add(map.get((String)iterator2.next()));
                    }
                    iterator = part.iterator();
                } else {
                    iterator = map.values().iterator();
                }
                while (iterator.hasNext()) {
                    part = (Part)iterator.next();
                    QName qName = string2.equals("useElement") ? part.getElementName() : part.getTypeName();
                    if (qName != null) continue;
                    throw new AssertionFailException("Name of operation that failed: " + operation.getName() + "\n" + operation.toString() + "\n" + "\nName of message that failed: " + message.getQName() + "\n" + message.toString());
                }
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new AssertionFailException(nullPointerException.toString());
            }
        }
        return true;
    }

    private List getPartsList(BindingMatch bindingMatch, String string) {
        List list = null;
        Iterator iterator = null;
        try {
            BindingOperation bindingOperation = bindingMatch.getBindingOperation();
            iterator = string.equals("useInput") ? bindingOperation.getBindingInput().getExtensibilityElements().iterator() : bindingOperation.getBindingOutput().getExtensibilityElements().iterator();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        while (iterator.hasNext() && list == null) {
            try {
                SOAPBody sOAPBody = (SOAPBody)iterator.next();
                list = sOAPBody.getParts();
            }
            catch (ClassCastException classCastException) {}
        }
        return list;
    }

    protected ElementLocation getElementLocation(WSDLDocument wSDLDocument, Object object) {
        ElementLocation elementLocation = null;
        WSDLElementList wSDLElementList = wSDLDocument.getElementList();
        if (wSDLElementList != null) {
            elementLocation = wSDLElementList.getElementLocation(object);
        }
        return elementLocation;
    }

    protected FailureDetail createFailureDetail(String string, EntryContext entryContext) {
        return this.createFailureDetail(string, entryContext, entryContext.getEntry().getEntryDetail());
    }

    protected FailureDetail createFailureDetail(String string, EntryContext entryContext, Object object) {
        FailureDetail failureDetail = this.reporter.createFailureDetail();
        failureDetail.setFailureMessage(string);
        failureDetail.setElementLocation(this.getElementLocation(entryContext.getWSDLDocument(), object));
        return failureDetail;
    }

    protected boolean namespaceFoundInSoapLiteral(ExtensibilityElement extensibilityElement) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = extensibilityElement.getClass();
        Method method = clazz.getMethod("getUse", new Class[0]);
        Method method2 = clazz.getMethod("getNamespaceURI", new Class[0]);
        if (method.invoke((Object)extensibilityElement, null) == null || !method.invoke((Object)extensibilityElement, null).equals("literal")) {
            return false;
        }
        boolean bl = method2.invoke((Object)extensibilityElement, null) != null;
        return bl;
    }

    protected boolean isLiteral(ExtensibilityElement extensibilityElement) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = extensibilityElement.getClass();
        Method method = clazz.getMethod("getUse", new Class[0]);
        return method.invoke((Object)extensibilityElement, null) != null && method.invoke((Object)extensibilityElement, null).equals("literal");
    }

    protected class BindingMatch {
        private Binding binding;
        private BindingOperation bindingOperation;
        private SOAPBinding soapBinding;
        private BindingInput bindingInput;
        private BindingOutput bindingOutput;

        public BindingMatch(Binding binding, BindingOperation bindingOperation, SOAPBinding sOAPBinding, BindingInput bindingInput, BindingOutput bindingOutput) {
            this.binding = binding;
            this.bindingOperation = bindingOperation;
            this.soapBinding = sOAPBinding;
            this.bindingInput = bindingInput;
            this.bindingOutput = bindingOutput;
        }

        public BindingMatch(Binding binding, BindingOperation bindingOperation, SOAPBinding sOAPBinding, BindingInput bindingInput) {
            this(binding, bindingOperation, sOAPBinding, bindingInput, null);
        }

        public BindingMatch(Binding binding, BindingOperation bindingOperation, SOAPBinding sOAPBinding, BindingOutput bindingOutput) {
            this(binding, bindingOperation, sOAPBinding, null, bindingOutput);
        }

        public SOAPBinding getSoapBinding() {
            return this.soapBinding;
        }

        public BindingOperation getBindingOperation() {
            return this.bindingOperation;
        }

        public BindingInput getBindingInput() {
            return this.bindingInput;
        }

        public BindingOutput getBindingOutput() {
            return this.bindingOutput;
        }

        public boolean hasBindingInput() {
            return this.bindingInput != null;
        }

        public boolean hasBindingOutput() {
            return this.bindingOutput != null;
        }

        public Binding getBinding() {
            return this.binding;
        }
    }
}

