/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.util;

import java.io.File;
import java.net.URL;
import java.util.StringTokenizer;

public class AxisUtils {
    public static final String ELEM_ENVELOPE = "Envelope";
    public static final String ELEM_HEADER = "Header";
    public static final String ELEM_BODY = "Body";
    public static final String ELEM_FAULT = "Fault";
    public static final String ELEM_FAULT_CODE = "faultcode";
    public static final String ELEM_FAULT_STRING = "faultstring";
    public static final String ELEM_FAULT_DETAIL = "detail";
    public static final String ELEM_FAULT_ACTOR = "faultactor";
    public static final String ATTR_MUST_UNDERSTAND = "mustUnderstand";
    public static final String ATTR_ACTOR = "actor";
    public static final String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";
    public static final String NS_PREFIX_XML = "xml";
    public static final String NS_URI_XML = "http://www.w3.org/XML/1998/namespace";
    public static final String URI_SOAP11_NEXT_ACTOR = "http://schemas.xmlsoap.org/soap/actor/next";
    public static final String URI_SOAP11_ENV = "http://schemas.xmlsoap.org/soap/envelope/";
    protected static final String AMP = "&amp;";
    protected static final String QUOTE = "&quot;";
    protected static final String APOS = "&apos;";
    protected static final String LESS = "&lt;";
    protected static final String GREATER = "&gt;";
    protected static final String LF = "\n";
    protected static final String CR = "&#xd;";
    protected static final String TAB = "\t";

    public static String xmlEncodeString(String string) {
        if (string == null) {
            return "";
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = null;
        block10: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '&': {
                    if (stringBuffer == null) {
                        stringBuffer = AxisUtils.getInitialByteArray(string, i);
                    }
                    stringBuffer.append(AMP);
                    continue block10;
                }
                case '\"': {
                    if (stringBuffer == null) {
                        stringBuffer = AxisUtils.getInitialByteArray(string, i);
                    }
                    stringBuffer.append(QUOTE);
                    continue block10;
                }
                case '<': {
                    if (stringBuffer == null) {
                        stringBuffer = AxisUtils.getInitialByteArray(string, i);
                    }
                    stringBuffer.append(LESS);
                    continue block10;
                }
                case '>': {
                    if (stringBuffer == null) {
                        stringBuffer = AxisUtils.getInitialByteArray(string, i);
                    }
                    stringBuffer.append(GREATER);
                    continue block10;
                }
                case '\n': {
                    if (stringBuffer == null) {
                        stringBuffer = AxisUtils.getInitialByteArray(string, i);
                    }
                    stringBuffer.append(LF);
                    continue block10;
                }
                case '\r': {
                    if (stringBuffer == null) {
                        stringBuffer = AxisUtils.getInitialByteArray(string, i);
                    }
                    stringBuffer.append(CR);
                    continue block10;
                }
                case '\t': {
                    if (stringBuffer == null) {
                        stringBuffer = AxisUtils.getInitialByteArray(string, i);
                    }
                    stringBuffer.append(TAB);
                    continue block10;
                }
                case '\'': {
                    if (stringBuffer == null) {
                        stringBuffer = AxisUtils.getInitialByteArray(string, i);
                    }
                    stringBuffer.append(APOS);
                    continue block10;
                }
                default: {
                    if (c < ' ') {
                        throw new IllegalArgumentException("Invalid XML Character " + Integer.toHexString(c) + " " + string);
                    }
                    if (stringBuffer == null) continue block10;
                    stringBuffer.append(c);
                }
            }
        }
        if (stringBuffer == null) {
            return string;
        }
        return stringBuffer.toString();
    }

    protected static StringBuffer getInitialByteArray(String string, int n) {
        return new StringBuffer(string.substring(0, n));
    }

    public static URL normalize(URL uRL) {
        if (uRL.getProtocol().equals("file")) {
            try {
                File file = new File(AxisUtils.cleanup(uRL.getFile()));
                if (file.exists()) {
                    return file.toURL();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return uRL;
    }

    private static String cleanup(String string) {
        int n;
        String[] stringArray = AxisUtils.tokenize(string, "/\\", false);
        int n2 = stringArray.length;
        String[] stringArray2 = new String[n2];
        while (true) {
            boolean bl = false;
            boolean bl2 = true;
            n = 0;
            for (int i = 0; i < n2 && stringArray[i] != null; ++i) {
                if (".".equals(stringArray[i])) continue;
                if ("..".equals(stringArray[i])) {
                    stringArray2[n++] = stringArray[i];
                    if (!bl) continue;
                    bl2 = false;
                    continue;
                }
                if (i + 1 < n2 && "..".equals(stringArray[i + 1])) {
                    ++i;
                    continue;
                }
                stringArray2[n++] = stringArray[i];
                bl = true;
            }
            if (bl2) break;
            stringArray = stringArray2;
            stringArray2 = new String[n2];
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (n = 0; n < n2 && stringArray2[n] != null; ++n) {
            stringBuffer.append(stringArray2[n]);
            if (n + 1 >= n2 || stringArray2[n + 1] == null) continue;
            stringBuffer.append("/");
        }
        return stringBuffer.toString();
    }

    private static String[] tokenize(String string, String string2, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, bl);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }
}

