/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.wsdl.xsd;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InlineSchemaGenerator {
    protected final String SOAP_ENCODING_URI = "http://schemas.xmlsoap.org/soap/encoding/";
    protected final String FILE_PREFIX = "file:///";
    protected final String XMLNS = "xmlns";
    protected final String TARGETNAMESPACE = "targetNamespace";
    protected final String NAMESPACE = "namespace";
    protected final String IMPORT = "import";
    protected final String INCLUDE = "include";
    protected final String SCHEMA = "schema";
    protected final String SCHEMALOCATION = "schemaLocation";
    protected final String TYPE = "type";
    protected final String NAME = "name";
    protected final String[] ignoreNamespaces = new String[]{"http://www.w3.org/1999/XMLSchema", "http://www.w3.org/2000/10/XMLSchema", "http://www.w3.org/2001/XMLSchema"};
    protected static InlineSchemaGenerator instance = null;

    protected InlineSchemaGenerator() {
    }

    protected static InlineSchemaGenerator getInstance() {
        if (instance == null) {
            instance = new InlineSchemaGenerator();
        }
        return instance;
    }

    public static String createXSDString(Element element, List list, String string) {
        return InlineSchemaGenerator.createXSDString(element, list, string, new Hashtable());
    }

    public static String createXSDString(Element element, List list, String string, Hashtable hashtable) {
        InlineSchemaGenerator inlineSchemaGenerator = InlineSchemaGenerator.getInstance();
        Hashtable hashtable2 = inlineSchemaGenerator.getNSResolver(element);
        List list2 = inlineSchemaGenerator.getRequiredNamespaces(element);
        Hashtable hashtable3 = inlineSchemaGenerator.resolveNamespaces(list2, hashtable2, hashtable);
        List list3 = inlineSchemaGenerator.getImportNamespaces(element);
        list2 = inlineSchemaGenerator.removeImports(list2, list3);
        list2 = inlineSchemaGenerator.removeLocalNamespaces(list2, element);
        return inlineSchemaGenerator.createXSDStringRecursively(element, list, list2, hashtable3, string);
    }

    public static boolean soapEncodingRequiredNotImported(Element element, String string, Hashtable hashtable) {
        InlineSchemaGenerator inlineSchemaGenerator = InlineSchemaGenerator.getInstance();
        Hashtable hashtable2 = inlineSchemaGenerator.getNSResolver(element);
        List list = null;
        list = inlineSchemaGenerator.getRequiredNamespaces(element);
        inlineSchemaGenerator.resolveNamespaces(list, hashtable2, hashtable);
        List list2 = inlineSchemaGenerator.getImportNamespaces(element);
        list = inlineSchemaGenerator.removeImports(list, list2);
        list = inlineSchemaGenerator.removeLocalNamespaces(list, element);
        return inlineSchemaGenerator.checkSOAPEncodingRequired(list);
    }

    protected String createXSDStringRecursively(Element element, List list, List list2, Hashtable hashtable, String string) {
        Object object;
        Object object2;
        Object object3;
        if (element == null) {
            return "";
        }
        list.add(element);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = element.getTagName();
        stringBuffer.append("<").append(string2);
        boolean bl = false;
        String string3 = "";
        Object object4 = "";
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object3 = namedNodeMap.item(i);
            stringBuffer.append(" ").append(object3.getNodeName()).append("=\"");
            object2 = object3.getNodeName();
            if (((String)object2).equalsIgnoreCase("schemaLocation") && string != null) {
                bl = true;
                object = object3.getNodeValue();
                stringBuffer.append((String)object).append("\"");
                continue;
            }
            object = object3.getNodeValue();
            if (((String)object2).equalsIgnoreCase("namespace")) {
                string3 = object;
            } else if (((String)object2).indexOf("xmlns") != -1 && ((String)object).equalsIgnoreCase(element.getNamespaceURI())) {
                object4 = object2;
                object4 = ((String)object4).equalsIgnoreCase("xmlns") ? "" : ((String)object4).substring(6) + ":";
            }
            if (((String)object).equals("http://www.w3.org/1999/XMLSchema") || ((String)object).equals("http://www.w3.org/2000/10/XMLSchema")) {
                object = "http://www.w3.org/2001/XMLSchema";
            }
            stringBuffer.append((String)object).append("\"");
        }
        if (string2.equalsIgnoreCase("import") && !bl) {
            stringBuffer.append(" ").append("schemaLocation").append("=\"").append(string3).append("\"");
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object3 = (String)enumeration.nextElement();
                object2 = (String)hashtable.get(object3);
                if (((String)object2).equals("http://www.w3.org/1999/XMLSchema") || ((String)object2).equals("http://www.w3.org/2000/10/XMLSchema")) {
                    object2 = "http://www.w3.org/2001/XMLSchema";
                }
                stringBuffer.append(" ").append((String)object3).append("=\"").append((String)object2).append("\"");
            }
        }
        stringBuffer.append(">");
        if (list2 != null) {
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                stringBuffer.append("<").append((String)object4).append("import").append(" ").append("namespace").append("=\"").append((String)object3).append("\" ").append("schemaLocation").append("=\"").append((String)object3).append("\"/>");
            }
        }
        stringBuffer.append("\n");
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength() || i < 5; ++i) {
            object2 = nodeList.item(i);
            if (!(object2 instanceof Element)) continue;
            object = (Element)object2;
            stringBuffer.append(this.createXSDStringRecursively((Element)object, list, null, null, string));
        }
        stringBuffer.append("</").append(element.getTagName()).append(">");
        return stringBuffer.toString();
    }

    protected List getRequiredNamespaces(Element element) {
        String string;
        Object object;
        Object object2;
        Vector<String> vector = new Vector<String>();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            object2 = nodeList.item(i);
            if (!(object2 instanceof Element)) continue;
            object = (Element)object2;
            List list = this.getRequiredNamespaces((Element)object);
            for (int j = list.size() - 1; j >= 0; --j) {
                string = (String)list.get(j);
                if (vector.contains(string)) continue;
                vector.add(string);
            }
        }
        String string2 = element.getPrefix();
        if (string2 == null) {
            string2 = "";
        }
        if (!vector.contains(string2.intern())) {
            vector.add(string2.intern());
        }
        if (!(((String)(object2 = element.getLocalName())).equals("import") || ((String)object2).equals("include") || ((String)object2).equals("schema"))) {
            object = element.getAttributes();
            for (int i = 0; i < object.getLength(); ++i) {
                String string3;
                int n2;
                Node node = object.item(i);
                string = node.getNodeName();
                if (string.indexOf("xmlns") != -1 || string.equals("targetNamespace") || string.equals("name") || (n2 = (string3 = node.getNodeValue()).indexOf(":")) == -1 || string3.charAt(n2 + 1) == '/' || vector.contains((string3 = string3.substring(0, n2)).intern())) continue;
                vector.add(string3.intern());
            }
        }
        return vector;
    }

    protected List getImportNamespaces(Element element) {
        Object object;
        Node node;
        Vector<String> vector = new Vector<String>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength() || i < 5; ++i) {
            Node node2 = nodeList.item(i);
            if (!(node2 instanceof Element)) continue;
            node = (Element)node2;
            object = this.getImportNamespaces((Element)node);
            for (int j = object.size() - 1; j >= 0; --j) {
                String string = (String)object.get(j);
                if (vector.contains(string)) continue;
                vector.add(string);
            }
        }
        if (element.getLocalName().equalsIgnoreCase("import")) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                String string;
                node = namedNodeMap.item(i);
                object = node.getNodeName();
                if (!((String)object).equalsIgnoreCase("namespace") || vector.contains((string = node.getNodeValue()).intern())) continue;
                vector.add(string.intern());
            }
        }
        return vector;
    }

    protected Hashtable getNSResolver(Element element) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            String string = node.getNodeName();
            if (string.indexOf("xmlns") == -1) continue;
            String string2 = node.getNodeValue();
            String string3 = string;
            string3 = string3.equalsIgnoreCase("xmlns") ? "" : string3.substring(6);
            hashtable.put(string3, string2);
        }
        return hashtable;
    }

    protected Hashtable resolveNamespaces(List list, Hashtable hashtable, Hashtable hashtable2) {
        Hashtable hashtable3 = new Hashtable();
        if (list != null && !list.isEmpty() && hashtable != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                Object v;
                String string = (String)list.get(i);
                list.remove(i);
                if (hashtable.containsKey(string)) {
                    v = hashtable.get(string);
                    if (list.contains(v)) continue;
                    list.add(i, hashtable.get(string));
                    continue;
                }
                if (!hashtable2.containsKey(string = string.equals("") ? "xmlns" : "xmlns:" + string)) continue;
                v = hashtable2.get(string);
                if (!list.contains(v)) {
                    list.add(i, v);
                }
                hashtable3.put(string, v);
            }
        }
        return hashtable3;
    }

    protected List removeImports(List list, List list2) {
        if (list != null && list2 != null && !list2.isEmpty()) {
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                list.remove(string);
            }
        }
        return list;
    }

    protected List removeLocalNamespaces(List list, Element element) {
        if (list != null && element != null) {
            String string = element.getAttribute("targetNamespace");
            list.remove(string);
            for (int i = this.ignoreNamespaces.length - 1; i >= 0; --i) {
                if (!list.remove(this.ignoreNamespaces[i])) continue;
                ++i;
            }
        }
        return list;
    }

    protected boolean checkSOAPEncodingRequired(List list) {
        return list.contains("http://schemas.xmlsoap.org/soap/encoding/");
    }
}

