/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.ws.security.SAMLTokenPrincipal;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.KerberosSecurity;
import org.apache.ws.security.message.token.PKIPathSecurity;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.Validator;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinarySecurityTokenProcessor
implements Processor {
    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        BinarySecurity token = this.createSecurityToken(elem, data.getWssConfig());
        X509Certificate[] certs = null;
        Validator validator = data.getValidator(new QName(elem.getNamespaceURI(), elem.getLocalName()));
        certs = data.getSigCrypto() == null ? this.getCertificatesTokenReference(token, data.getDecCrypto()) : this.getCertificatesTokenReference(token, data.getSigCrypto());
        WSSecurityEngineResult result = new WSSecurityEngineResult(4096, token, certs);
        wsDocInfo.addTokenElement(elem);
        String id = elem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        result.put("id", id);
        if (validator != null) {
            Credential credential = new Credential();
            credential.setBinarySecurityToken(token);
            credential.setCertificates(certs);
            Credential returnedCredential = validator.validate(credential, data);
            result.put("validated-token", Boolean.TRUE);
            if (returnedCredential.getTransformedToken() != null) {
                result.put("transformed-token", returnedCredential.getTransformedToken());
                SAMLTokenPrincipal samlPrincipal = new SAMLTokenPrincipal(credential.getTransformedToken());
                result.put("principal", samlPrincipal);
            } else if (credential.getPrincipal() != null) {
                result.put("principal", credential.getPrincipal());
            } else if (certs != null && certs[0] != null) {
                result.put("principal", certs[0].getSubjectX500Principal());
            }
        }
        wsDocInfo.addResult(result);
        return Collections.singletonList(result);
    }

    private X509Certificate[] getCertificatesTokenReference(BinarySecurity token, Crypto crypto) throws WSSecurityException {
        if (token instanceof PKIPathSecurity) {
            return ((PKIPathSecurity)token).getX509Certificates(crypto);
        }
        if (token instanceof X509Security) {
            X509Certificate cert = ((X509Security)token).getX509Certificate(crypto);
            return new X509Certificate[]{cert};
        }
        return null;
    }

    private BinarySecurity createSecurityToken(Element element, WSSConfig config) throws WSSecurityException {
        String type = element.getAttribute("ValueType");
        BinarySecurity token = null;
        token = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(type) ? new X509Security(element, config.isWsiBSPCompliant()) : (PKIPathSecurity.getType().equals(type) ? new PKIPathSecurity(element, config.isWsiBSPCompliant()) : (KerberosSecurity.isKerberosToken(type) ? new KerberosSecurity(element, config.isWsiBSPCompliant()) : new BinarySecurity(element, config.isWsiBSPCompliant())));
        return token;
    }
}

