/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.gecko15;

import com.teamdev.jxbrowser.gecko15.BrowserPreferences;
import com.teamdev.jxbrowser.gecko15.WebBrowser;
import com.teamdev.jxbrowser.gecko15.WebNavigation;
import com.teamdev.jxbrowser.gecko15.dom.DomProxyFactory;
import com.teamdev.jxbrowser.gecko15.download.DownloadHandler;
import com.teamdev.jxbrowser.gecko15.events.BrowserWindowListener;
import com.teamdev.jxbrowser.gecko15.events.ContextMenuListener;
import com.teamdev.jxbrowser.gecko15.events.DisposeListener;
import com.teamdev.jxbrowser.gecko15.events.RequestListener;
import com.teamdev.jxbrowser.gecko15.events.StatusChangeListener;
import com.teamdev.jxbrowser.gecko15.events.TitleChangeListener;
import com.teamdev.jxbrowser.gecko15.events.impl.nsIWebProgressAdapter;
import com.teamdev.jxbrowser.gecko15.script.JavaScriptExecutor;
import com.teamdev.jxbrowser.gecko15.xpcom.ChromeContainerWindow;
import com.teamdev.jxbrowser.gecko15.xpcom.Mozilla;
import com.teamdev.jxbrowser.gecko15.xpcom.XPCOM;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDOMDocument;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDOMMimeType;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDOMMimeTypeArray;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDOMNavigator;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDOMWindow;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDOMWindowInternal;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDocShell;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDocumentEncoder;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIInputStream;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIInterfaceRequestor;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsILocalFile;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIRequest;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIURI;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIWebBrowser;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIWebBrowserPersist;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIWebBrowserStream;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIWebProgress;
import com.teamdev.jxbrowser.gecko15.xpcom.util.FlagUtil;
import com.teamdev.jxbrowser.gecko15.xpcom.util.StringInputStreamFactory;
import com.teamdev.jxbrowser.gecko15.xpcom.util.URIFactory;
import com.teamdev.jxbrowser.gecko15.xpcom.util.WebPageRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveWebBrowserSupport
implements WebBrowser {
    private final WebNavigation a;
    private final JavaScriptExecutor b;
    private final ChromeContainerWindow c;
    private final List<String> d;

    public ActiveWebBrowserSupport() {
        nsIWebBrowser nsIWebBrowser2 = XPCOM.createComponent("@mozilla.org/embedding/browser/nsWebBrowser;1", nsIWebBrowser.class);
        this.c = ChromeContainerWindow.newContainer();
        this.c.setWebBrowser(nsIWebBrowser2);
        this.a = new WebNavigation(nsIWebBrowser2);
        this.b = new JavaScriptExecutor();
        this.d = new ArrayList<String>();
        this.d.add("text/html");
        this.d.add("text/plain");
        this.d.add("text/xml");
        this.d.add("application/xml");
        this.d.add("application/xhtml+xml");
        this.d.add("image/svg+xml");
        this.d.add("image/png");
        this.d.add("image/jpeg");
        this.d.add("image/gif");
    }

    @Override
    public void addBrowserWindowListener(BrowserWindowListener browserWindowListener) {
        this.c.addBrowserWindowListener(browserWindowListener);
    }

    @Override
    public void removeBrowserWindowListener(BrowserWindowListener browserWindowListener) {
        this.c.removeBrowserWindowListener(browserWindowListener);
    }

    @Override
    public List<BrowserWindowListener> getBrowserWindowListeners() {
        return this.c.getBrowserWindowListeners();
    }

    @Override
    public void addRequestListener(RequestListener requestListener) {
        this.a.addRequestListener(requestListener);
    }

    @Override
    public void removeRequestListener(RequestListener requestListener) {
        this.a.removeRequestListener(requestListener);
    }

    @Override
    public List<RequestListener> getRequestListeners() {
        return this.a.getRequestListeners();
    }

    @Override
    public void addStatusChangeListener(StatusChangeListener statusChangeListener) {
        this.c.addStatusChangeListener(statusChangeListener);
    }

    @Override
    public void removeStatusChangeListener(StatusChangeListener statusChangeListener) {
        this.c.removeStatusChangeListener(statusChangeListener);
    }

    @Override
    public List<StatusChangeListener> getStatusChangeListeners() {
        return this.c.getStatusChangeListeners();
    }

    @Override
    public void addTitleChangeListener(TitleChangeListener titleChangeListener) {
        this.c.addTitleChangeListener(titleChangeListener);
    }

    @Override
    public void removeTitleChangeListener(TitleChangeListener titleChangeListener) {
        this.c.removeTitleChangeListener(titleChangeListener);
    }

    @Override
    public List<TitleChangeListener> getTitleChangeListeners() {
        return this.c.getTitleChangeListeners();
    }

    @Override
    public void addContextMenuListener(ContextMenuListener contextMenuListener) {
        this.c.addContextMenuListener(contextMenuListener);
    }

    @Override
    public void removeContextMenuListener(ContextMenuListener contextMenuListener) {
        this.c.removeContextMenuListener(contextMenuListener);
    }

    @Override
    public List<ContextMenuListener> getContextMenuListeners() {
        return this.c.getContextMenuListeners();
    }

    @Override
    public void dispose() {
        this.c.dispose();
    }

    @Override
    public String evaluateScript(String string) {
        return this.b.evaluateScript(string, this.a, this.getNsIWebBrowser());
    }

    @Override
    public String getDocumentContent() {
        return this.getDocumentContent("text/html");
    }

    @Override
    public Component getComponent() {
        return this.c.getContainerComponent();
    }

    @Override
    public Document getDocument() {
        final AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                nsIWebBrowser nsIWebBrowser2 = ActiveWebBrowserSupport.this.getNsIWebBrowser();
                nsIDOMWindow nsIDOMWindow2 = nsIWebBrowser2.getContentDOMWindow();
                nsIDOMDocument nsIDOMDocument2 = nsIDOMWindow2.getDocument();
                atomicReference.set((Document)DomProxyFactory.createDomObjectProxy(nsIDOMDocument2));
            }
        });
        return atomicReference.get();
    }

    @Override
    public String getDocumentContent(final String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Content type cannot be null or empty string.");
        }
        final AtomicReference<String> atomicReference = new AtomicReference<String>("");
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                atomicReference.set(ActiveWebBrowserSupport.this.a(string));
            }
        });
        return atomicReference.get();
    }

    private String a(String string) {
        nsIWebBrowser nsIWebBrowser2 = this.getNsIWebBrowser();
        nsIDOMWindow nsIDOMWindow2 = nsIWebBrowser2.getContentDOMWindow();
        nsIDOMDocument nsIDOMDocument2 = nsIDOMWindow2.getDocument();
        nsIDocumentEncoder nsIDocumentEncoder2 = XPCOM.createComponent("@mozilla.org/layout/documentEncoder;1?type=" + string, nsIDocumentEncoder.class);
        nsIDocumentEncoder2.init(nsIDOMDocument2, string, 4L);
        return nsIDocumentEncoder2.encodeToString();
    }

    @Override
    public String getLocationURL() {
        return this.a.currentURI();
    }

    @Override
    public String getTitle() {
        return this.c.getTitle();
    }

    @Override
    public void goBack() {
        this.a.goBack();
    }

    @Override
    public boolean canGoBack() {
        return this.a.canGoBack();
    }

    @Override
    public boolean canGoForward() {
        return this.a.canGoForward();
    }

    @Override
    public void goForward() {
        this.a.goForward();
    }

    @Override
    public boolean isDisposed() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void navigate(String string) {
        this.a.navigate(string);
    }

    @Override
    public void navigate(String string, String string2) {
        this.a.navigate(string, string2);
    }

    @Override
    public void navigate(String string, String string2, long l2) {
        this.a.navigate(string, string2, l2);
    }

    @Override
    public void refresh() {
        this.a.refresh();
    }

    @Override
    public void stop() {
        this.a.stop();
    }

    @Override
    public void setPreferences(final BrowserPreferences browserPreferences) {
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                nsIInterfaceRequestor nsIInterfaceRequestor2 = XPCOM.queryInterface(ActiveWebBrowserSupport.this.c.getWebBrowser(), nsIInterfaceRequestor.class);
                nsIDocShell nsIDocShell2 = (nsIDocShell)nsIInterfaceRequestor2.getInterface("{6f60ac96-fa2c-41a5-92b4-29aaadbd7a7b}");
                nsIDocShell2.setAllowAuth(browserPreferences.isAllowAuthentication());
                nsIDocShell2.setAllowImages(browserPreferences.isAllowImages());
                nsIDocShell2.setAllowJavascript(browserPreferences.isAllowJavascript());
                nsIDocShell2.setAllowMetaRedirects(browserPreferences.isAllowMetaRedirects());
                nsIDocShell2.setAllowPlugins(browserPreferences.isAllowPlugins());
                nsIDocShell2.setAllowSubframes(browserPreferences.isAllowSubFrames());
            }
        });
    }

    @Override
    public BrowserPreferences getPreferences() {
        final BrowserPreferences browserPreferences = new BrowserPreferences();
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                nsIWebBrowser nsIWebBrowser2 = ActiveWebBrowserSupport.this.c.getWebBrowser();
                nsIInterfaceRequestor nsIInterfaceRequestor2 = XPCOM.queryInterface(nsIWebBrowser2, nsIInterfaceRequestor.class);
                nsIDocShell nsIDocShell2 = (nsIDocShell)nsIInterfaceRequestor2.getInterface("{6f60ac96-fa2c-41a5-92b4-29aaadbd7a7b}");
                browserPreferences.setAllowAuthentication(nsIDocShell2.getAllowAuth());
                browserPreferences.setAllowImages(nsIDocShell2.getAllowImages());
                browserPreferences.setAllowJavascript(nsIDocShell2.getAllowJavascript());
                browserPreferences.setAllowMetaRedirects(nsIDocShell2.getAllowMetaRedirects());
                browserPreferences.setAllowPlugins(nsIDocShell2.getAllowPlugins());
                browserPreferences.setAllowSubFrames(nsIDocShell2.getAllowSubframes());
            }
        });
        return browserPreferences;
    }

    @Override
    public void setContent(String string) {
        this.setContent(string, "text/html");
    }

    @Override
    public void setContent(String string, String string2) {
        this.setContent(string, string2, "UTF-8");
    }

    @Override
    public void setContent(String string, String string2, String string3) {
        this.setContent(string, string2, string3, null);
    }

    @Override
    public void setContent(final String string, final String string2, final String string3, final String string4) {
        if (string == null) {
            throw new IllegalArgumentException("Content cannot be null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("ContentType cannot be null.");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("Charset cannot be null.");
        }
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                if (string4 == null) {
                    nsIWebBrowser nsIWebBrowser2 = ActiveWebBrowserSupport.this.getNsIWebBrowser();
                    nsIInterfaceRequestor nsIInterfaceRequestor2 = XPCOM.queryInterface(nsIWebBrowser2, nsIInterfaceRequestor.class);
                    nsIDocShell nsIDocShell2 = (nsIDocShell)nsIInterfaceRequestor2.getInterface("{6f60ac96-fa2c-41a5-92b4-29aaadbd7a7b}");
                    nsIInputStream nsIInputStream2 = StringInputStreamFactory.newInputStream(string);
                    nsIDocShell2.loadStream(nsIInputStream2, null, string2, string3, null);
                } else {
                    nsIURI nsIURI2 = URIFactory.newURI(string4);
                    nsIWebBrowser nsIWebBrowser3 = ActiveWebBrowserSupport.this.getNsIWebBrowser();
                    nsIWebBrowserStream nsIWebBrowserStream2 = XPCOM.queryInterface(nsIWebBrowser3, nsIWebBrowserStream.class);
                    nsIWebBrowserStream2.openStream(nsIURI2, string2 + ";charset=" + string3);
                    nsIWebBrowserStream2.appendToStream(string.getBytes(), string.length());
                    nsIWebBrowserStream2.closeStream();
                }
            }
        });
    }

    @Override
    public BufferedImage toImage() {
        return this.toImage(WebPageRenderer.getDocumentPreferredSize(this.getNsIWebBrowser()));
    }

    @Override
    public BufferedImage toImage(Dimension dimension) {
        if (dimension == null) {
            throw new IllegalArgumentException("PreferredSize cannot be null.");
        }
        if (dimension.width == 0 || dimension.height == 0) {
            throw new IllegalArgumentException("PreferredSize cannot be empty.");
        }
        try {
            nsIWebBrowser nsIWebBrowser2 = this.getNsIWebBrowser();
            InputStream inputStream = WebPageRenderer.render(nsIWebBrowser2, dimension);
            return ImageIO.read(inputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot capture a web page.", iOException);
        }
    }

    @Override
    public boolean isMimeTypeSupported(final String string) {
        final AtomicBoolean atomicBoolean = new AtomicBoolean(this.d.contains(string));
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                nsIDOMWindow nsIDOMWindow2 = ActiveWebBrowserSupport.this.getNsIWebBrowser().getContentDOMWindow();
                nsIDOMWindowInternal nsIDOMWindowInternal2 = XPCOM.queryInterface(nsIDOMWindow2, nsIDOMWindowInternal.class);
                nsIDOMNavigator nsIDOMNavigator2 = nsIDOMWindowInternal2.getNavigator();
                nsIDOMMimeTypeArray nsIDOMMimeTypeArray2 = nsIDOMNavigator2.getMimeTypes();
                long l2 = nsIDOMMimeTypeArray2.getLength();
                int n2 = 0;
                while ((long)n2 < l2) {
                    nsIDOMMimeType nsIDOMMimeType2 = nsIDOMMimeTypeArray2.item(n2);
                    String string2 = nsIDOMMimeType2.getType();
                    if (string2.equals(string)) {
                        atomicBoolean.set(true);
                        break;
                    }
                    ++n2;
                }
            }
        });
        return atomicBoolean.get();
    }

    @Override
    public void addDisposeListener(DisposeListener disposeListener) {
        this.c.addDisposeListener(disposeListener);
    }

    @Override
    public void removeDisposeListener(DisposeListener disposeListener) {
        this.c.removeDisposeListener(disposeListener);
    }

    @Override
    public List<DisposeListener> getDisposeListeners() {
        return this.c.getDisposeListeners();
    }

    @Override
    public nsIWebBrowser getNsIWebBrowser() {
        return this.c.getWebBrowser();
    }

    @Override
    public void saveWebPage(final File file, final String string) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                nsIWebBrowser nsIWebBrowser2 = ActiveWebBrowserSupport.this.getNsIWebBrowser();
                nsIWebBrowserPersist nsIWebBrowserPersist2 = XPCOM.queryInterface(nsIWebBrowser2, nsIWebBrowserPersist.class);
                File file2 = new File(file, string);
                nsILocalFile nsILocalFile2 = Mozilla.NewLocalFile(file2.getAbsolutePath(), false);
                nsILocalFile nsILocalFile3 = Mozilla.NewLocalFile(file.getAbsolutePath(), false);
                nsIDOMDocument nsIDOMDocument2 = nsIWebBrowser2.getContentDOMWindow().getDocument();
                nsIWebBrowserPersist2.setProgressListener(new nsIWebProgressAdapter(){

                    public void onStateChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, long l2, long l3) {
                        if (FlagUtil.checkFlag(l2, 262160L)) {
                            countDownLatch.countDown();
                        }
                    }
                });
                nsIWebBrowserPersist2.saveDocument(nsIDOMDocument2, nsILocalFile2, nsILocalFile3, "text/html", 4L, 0L);
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    @Override
    public DownloadHandler getDownloadHandler() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDownloadHandler(DownloadHandler downloadHandler) {
        throw new UnsupportedOperationException();
    }
}

