/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.gecko15;

import com.teamdev.jxbrowser.gecko15.events.RequestListener;
import com.teamdev.jxbrowser.gecko15.events.impl.RequestListeners;
import com.teamdev.jxbrowser.gecko15.xpcom.Mozilla;
import com.teamdev.jxbrowser.gecko15.xpcom.XPCOM;
import com.teamdev.jxbrowser.gecko15.xpcom.XPCOMJavaProxyManager;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIInputStream;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIRequest;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsISupports;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIURI;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIWebBrowser;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIWebNavigation;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIWebProgress;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIWebProgressListener;
import com.teamdev.jxbrowser.gecko15.xpcom.util.StringInputStreamFactory;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebNavigation {
    private final nsIWebBrowser a;
    private final RequestListeners b;

    public WebNavigation(nsIWebBrowser nsIWebBrowser2) {
        this.a = nsIWebBrowser2;
        this.b = new RequestListeners();
        nsIWebBrowser2.addWebBrowserListener(new i(), "{a0cda7e4-c6ca-11e0-b6a5-001320257da5}");
    }

    public void navigate(String string) {
        this.navigate(string, null);
    }

    public void navigate(String string, String string2) {
        this.navigate(string, string2, 0L);
    }

    public void navigate(final String string, final String string2, final long l2) {
        XPCOM.invokeLater(new Runnable(){

            public void run() {
                nsIInputStream nsIInputStream2 = WebNavigation.this.a(string2);
                nsIWebNavigation nsIWebNavigation2 = WebNavigation.this.a();
                nsIWebNavigation2.loadURI(string, l2, null, nsIInputStream2, null);
                Mozilla.release(nsIWebNavigation2);
            }
        });
    }

    private nsIWebNavigation a() {
        return XPCOM.queryInterface(this.a, nsIWebNavigation.class);
    }

    private nsIInputStream a(String string) {
        if (string != null) {
            String string2 = String.format("Content-Type: application/x-www-form-urlencoded\r\nContent-Length: %d\r\n\r\n%s", string.length(), string);
            return StringInputStreamFactory.newInputStream(string2);
        }
        return null;
    }

    public void stop() {
        XPCOM.invokeLater(new Runnable(){

            public void run() {
                nsIWebNavigation nsIWebNavigation2 = WebNavigation.this.a();
                nsIWebNavigation2.stop(3L);
                Mozilla.release(nsIWebNavigation2);
            }
        });
    }

    public void refresh() {
        XPCOM.invokeLater(new Runnable(){

            public void run() {
                nsIWebNavigation nsIWebNavigation2 = WebNavigation.this.a();
                nsIWebNavigation2.reload(0L);
                Mozilla.release(nsIWebNavigation2);
            }
        });
    }

    public String currentURI() {
        final AtomicReference<String> atomicReference = new AtomicReference<String>("about:blank");
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                nsIWebNavigation nsIWebNavigation2 = WebNavigation.this.a();
                nsIURI nsIURI2 = nsIWebNavigation2.getCurrentURI();
                Mozilla.release(nsIWebNavigation2);
                if (nsIURI2 != null) {
                    atomicReference.set(nsIURI2.getSpec());
                }
            }
        });
        return atomicReference.get();
    }

    public void goBack() {
        XPCOM.invokeLater(new Runnable(){

            public void run() {
                if (WebNavigation.this.canGoBack()) {
                    nsIWebNavigation nsIWebNavigation2 = WebNavigation.this.a();
                    nsIWebNavigation2.goBack();
                    Mozilla.release(nsIWebNavigation2);
                }
            }
        });
    }

    public void goForward() {
        XPCOM.invokeLater(new Runnable(){

            public void run() {
                if (WebNavigation.this.canGoForward()) {
                    nsIWebNavigation nsIWebNavigation2 = WebNavigation.this.a();
                    nsIWebNavigation2.goForward();
                    Mozilla.release(nsIWebNavigation2);
                }
            }
        });
    }

    public boolean canGoForward() {
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                nsIWebNavigation nsIWebNavigation2 = WebNavigation.this.a();
                atomicBoolean.set(nsIWebNavigation2.getCanGoForward());
                Mozilla.release(nsIWebNavigation2);
            }
        });
        return atomicBoolean.get();
    }

    public boolean canGoBack() {
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                nsIWebNavigation nsIWebNavigation2 = WebNavigation.this.a();
                atomicBoolean.set(nsIWebNavigation2.getCanGoBack());
                Mozilla.release(nsIWebNavigation2);
            }
        });
        return atomicBoolean.get();
    }

    public void addRequestListener(RequestListener requestListener) {
        this.b.addRequestListener(requestListener);
    }

    public void removeRequestListener(RequestListener requestListener) {
        this.b.removeRequestListener(requestListener);
    }

    public List<RequestListener> getRequestListeners() {
        return this.b.getRequestListeners();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class i
    implements nsIWebProgressListener {
        private i() {
        }

        @Override
        public void onLocationChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, nsIURI nsIURI2, long l2) {
            WebNavigation.this.b.fireLocationChanged(nsIWebProgress2, nsIRequest2, nsIURI2);
        }

        @Override
        public void onProgressChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, int n2, int n3, int n4, int n5) {
            WebNavigation.this.b.fireProgressChanged(nsIWebProgress2, nsIRequest2, n2, n3, n4, n5);
        }

        @Override
        public void onSecurityChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, long l2) {
            WebNavigation.this.b.fireSecurityChanged(nsIWebProgress2, nsIRequest2, l2);
        }

        @Override
        public void onStateChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, long l2, long l3) {
            WebNavigation.this.b.fireStateChanged(nsIWebProgress2, nsIRequest2, l2, l3);
        }

        @Override
        public void onStatusChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, long l2, String string) {
            WebNavigation.this.b.fireStatusChanged(nsIWebProgress2, nsIRequest2, l2, string);
        }

        @Override
        public nsISupports queryInterface(String string) {
            return XPCOMJavaProxyManager.queryInterface(this, string);
        }

        public void a(RequestListener requestListener) {
            WebNavigation.this.b.addRequestListener(requestListener);
        }

        public void b(RequestListener requestListener) {
            WebNavigation.this.b.removeRequestListener(requestListener);
        }

        public List<RequestListener> a() {
            return WebNavigation.this.b.getRequestListeners();
        }
    }
}

