/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.gecko15.events.impl;

import com.teamdev.jxbrowser.gecko15.dom.DomProxyFactory;
import com.teamdev.jxbrowser.gecko15.events.ContextMenuEvent;
import com.teamdev.jxbrowser.gecko15.events.ContextMenuListener;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIContextMenuInfo;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDOMEvent;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDOMNode;
import com.teamdev.jxbrowser.gecko15.xpcom.util.FlagUtil;
import com.teamdev.jxbrowser.gecko15.xpcom.util.URIFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.events.MouseEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextMenuListeners {
    private final Set<ContextMenuListener> a = new HashSet<ContextMenuListener>();

    public void addContextMenuListener(ContextMenuListener contextMenuListener) {
        this.a.add(contextMenuListener);
    }

    public void removeContextMenuListener(ContextMenuListener contextMenuListener) {
        this.a.remove(contextMenuListener);
    }

    public List<ContextMenuListener> getContextMenuListeners() {
        return new ArrayList<ContextMenuListener>(this.a);
    }

    public void fireContextMenuEvent(long l2, nsIContextMenuInfo nsIContextMenuInfo2) {
        MouseEvent mouseEvent = null;
        nsIDOMEvent nsIDOMEvent2 = nsIContextMenuInfo2.getMouseEvent();
        if (nsIDOMEvent2 != null) {
            mouseEvent = (MouseEvent)DomProxyFactory.createDomObjectProxy(nsIDOMEvent2);
        }
        Node node = null;
        nsIDOMNode nsIDOMNode2 = nsIContextMenuInfo2.getTargetNode();
        if (nsIDOMNode2 != null) {
            node = (Node)DomProxyFactory.createDomObjectProxy(nsIDOMNode2);
        }
        URI uRI = null;
        if (FlagUtil.checkFlag(l2, 2L)) {
            uRI = URIFactory.newURI(nsIContextMenuInfo2.getImageSrc());
        }
        URI uRI2 = null;
        if (FlagUtil.checkFlag(l2, 32L)) {
            uRI2 = URIFactory.newURI(nsIContextMenuInfo2.getBackgroundImageSrc());
        }
        String string = null;
        if (FlagUtil.checkFlag(l2, 1L)) {
            string = nsIContextMenuInfo2.getAssociatedLink();
        }
        ContextMenuEvent contextMenuEvent = new ContextMenuEvent(this, l2, mouseEvent, node, string, uRI, uRI2, mouseEvent.getClientX(), mouseEvent.getClientY());
        List<ContextMenuListener> list = this.getContextMenuListeners();
        for (ContextMenuListener contextMenuListener : list) {
            contextMenuListener.contextMenuRequested(contextMenuEvent);
        }
    }

    public void dispose() {
        this.a.clear();
    }
}

