/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.gecko15.prompt;

import com.teamdev.jxbrowser.gecko15.prompt.CloseStatus;
import com.teamdev.jxbrowser.gecko15.prompt.ConfirmationBoxCloseStatus;
import com.teamdev.jxbrowser.gecko15.prompt.LoginResult;
import com.teamdev.jxbrowser.gecko15.prompt.PromptHandler;
import com.teamdev.jxbrowser.gecko15.prompt.PromptHandlerProvider;
import com.teamdev.jxbrowser.gecko15.prompt.PromptResult;
import com.teamdev.jxbrowser.gecko15.prompt.SelectResult;
import com.teamdev.jxbrowser.gecko15.prompt.SilentPromptHandler;
import com.teamdev.jxbrowser.gecko15.xpcom.Mozilla;
import com.teamdev.jxbrowser.gecko15.xpcom.XPCOM;
import com.teamdev.jxbrowser.gecko15.xpcom.XPCOMJavaProxyManager;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIComponentRegistrar;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDOMWindow;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIFactory;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIPrompt;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIPromptFactory;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsISupports;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PromptWatcher
implements nsIFactory,
nsIPrompt,
nsIPromptFactory {
    public static PromptWatcher instance;
    private PromptHandler a;
    private final PromptHandler b = new SilentPromptHandler();
    private final List<PromptHandlerProvider> c = new ArrayList<PromptHandlerProvider>();

    public static PromptWatcher getInstance() {
        return instance == null ? (instance = new PromptWatcher()) : instance;
    }

    private PromptWatcher() {
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                PromptWatcher.this.a();
            }
        });
    }

    private void a() {
        nsIComponentRegistrar nsIComponentRegistrar2 = Mozilla.GetComponentRegistrar();
        String string = UUID.randomUUID().toString();
        nsIComponentRegistrar2.registerFactory(string, "PromptService", "@mozilla.org/prompter;1", this);
    }

    @Override
    public nsISupports createInstance(nsISupports nsISupports2, String string) {
        return this;
    }

    @Override
    public void lockFactory(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public nsISupports queryInterface(String string) {
        return XPCOMJavaProxyManager.queryInterface(this, string);
    }

    public void addPromptHandlerProvider(PromptHandlerProvider promptHandlerProvider) {
        this.c.add(promptHandlerProvider);
    }

    public void removePromptHandlerProvider(PromptHandlerProvider promptHandlerProvider) {
        this.c.remove(promptHandlerProvider);
    }

    public List<PromptHandlerProvider> getPromptHandlerProviders() {
        return new ArrayList<PromptHandlerProvider>(this.c);
    }

    @Override
    public nsISupports getPrompt(nsIDOMWindow nsIDOMWindow2, String string) {
        this.b();
        List<PromptHandlerProvider> list = this.getPromptHandlerProviders();
        for (PromptHandlerProvider promptHandlerProvider : list) {
            PromptHandler promptHandler = promptHandlerProvider.getHandler(nsIDOMWindow2);
            if (promptHandler == null) continue;
            this.a = promptHandler;
            return this;
        }
        return this;
    }

    private void b() {
        this.a = this.b;
    }

    @Override
    public void alert(final String string, final String string2) {
        XPCOM.invokeInAWTThreadAndWait(new Runnable(){

            public void run() {
                PromptWatcher.this.a.alertRequested(string2, string);
            }
        });
    }

    @Override
    public void alertCheck(String string, String string2, String string3, boolean[] blArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean confirm(final String string, final String string2) {
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        XPCOM.invokeInAWTThreadAndWait(new Runnable(){

            public void run() {
                atomicBoolean.set(PromptWatcher.this.a.confirmationRequested(string2, string) == CloseStatus.OK);
            }
        });
        return atomicBoolean.get();
    }

    @Override
    public boolean confirmCheck(String string, String string2, String string3, boolean[] blArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int confirmEx(final String string, final String string2, long l2, String string3, String string4, String string5, String string6, boolean[] blArray) {
        final List<String> list = this.a(l2, string3, string4, string5);
        ConfirmationBoxCloseStatus confirmationBoxCloseStatus = null;
        if (!list.isEmpty()) {
            confirmationBoxCloseStatus = this.a(l2);
        }
        final AtomicInteger atomicInteger = new AtomicInteger();
        final ConfirmationBoxCloseStatus confirmationBoxCloseStatus2 = confirmationBoxCloseStatus;
        XPCOM.invokeInAWTThreadAndWait(new Runnable(){

            public void run() {
                ConfirmationBoxCloseStatus confirmationBoxCloseStatus = PromptWatcher.this.a.confirmationBoxRequested(string2, string, list, confirmationBoxCloseStatus2);
                atomicInteger.set(confirmationBoxCloseStatus.getValue());
            }
        });
        return atomicInteger.get();
    }

    private List<String> a(long l2, String string, String string2, String string3) {
        long l3;
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        hashMap.put(1L, "OK");
        hashMap.put(2L, "Cancel");
        hashMap.put(3L, "Yes");
        hashMap.put(4L, "No");
        hashMap.put(5L, "Save");
        hashMap.put(6L, "Don't Save");
        hashMap.put(7L, "Revert");
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = new String[]{string, string2, string3};
        for (int i2 = 0; i2 < stringArray.length && (l3 = l2 >> 8 * i2 & 0xFFL) != 0L; ++i2) {
            if (127L == l3) {
                arrayList.add(stringArray[i2]);
                continue;
            }
            if (!hashMap.containsKey(l3)) continue;
            arrayList.add((String)hashMap.get(l3));
        }
        return arrayList;
    }

    private ConfirmationBoxCloseStatus a(long l2) {
        long l3 = 0x3000000L;
        int n2 = (int)((l2 & l3) >> 24);
        return ConfirmationBoxCloseStatus.getConfirmationBoxCloseStatusByIndex(n2);
    }

    @Override
    public boolean prompt(final String string, final String string2, final String[] stringArray, String string3, boolean[] blArray) {
        final AtomicReference atomicReference = new AtomicReference();
        XPCOM.invokeInAWTThreadAndWait(new Runnable(){

            public void run() {
                atomicReference.set(PromptWatcher.this.a.promptRequested(string2, string, stringArray[0]));
            }
        });
        PromptResult promptResult = (PromptResult)atomicReference.get();
        if (promptResult == null) {
            return false;
        }
        if (promptResult.getCloseStatus() == CloseStatus.OK) {
            stringArray[0] = promptResult.getValue();
        }
        return promptResult.getCloseStatus() == CloseStatus.OK;
    }

    @Override
    public boolean promptPassword(final String string, final String string2, final String[] stringArray, final String string3, final boolean[] blArray) {
        final AtomicReference atomicReference = new AtomicReference();
        XPCOM.invokeInAWTThreadAndWait(new Runnable(){

            public void run() {
                atomicReference.set(PromptWatcher.this.a.passwordRequested(string2, string, stringArray[0], string3, blArray[0]));
            }
        });
        LoginResult loginResult = (LoginResult)atomicReference.get();
        if (loginResult != null && loginResult.getCloseStatus() == CloseStatus.OK) {
            stringArray[0] = loginResult.getPassword();
            blArray[0] = loginResult.isCheckValue();
            return true;
        }
        return false;
    }

    @Override
    public boolean promptUsernameAndPassword(final String string, final String string2, final String[] stringArray, final String[] stringArray2, final String string3, final boolean[] blArray) {
        final AtomicReference atomicReference = new AtomicReference();
        XPCOM.invokeInAWTThreadAndWait(new Runnable(){

            public void run() {
                atomicReference.set(PromptWatcher.this.a.loginRequested(string2, string, "", stringArray[0], stringArray2[0], string3, blArray[0]));
            }
        });
        LoginResult loginResult = (LoginResult)atomicReference.get();
        if (loginResult != null && loginResult.getCloseStatus() == CloseStatus.OK) {
            stringArray[0] = loginResult.getUserName();
            stringArray2[0] = loginResult.getPassword();
            blArray[0] = loginResult.isCheckValue();
            return true;
        }
        return false;
    }

    @Override
    public boolean select(final String string, final String string2, long l2, final String[] stringArray, int[] nArray) {
        final AtomicReference atomicReference = new AtomicReference();
        XPCOM.invokeInAWTThreadAndWait(new Runnable(){

            public void run() {
                atomicReference.set(PromptWatcher.this.a.selectRequested(string2, string, Arrays.asList(stringArray)));
            }
        });
        SelectResult selectResult = (SelectResult)atomicReference.get();
        if (selectResult != null && selectResult.getCloseStatus() == CloseStatus.OK) {
            nArray[0] = Arrays.binarySearch(stringArray, selectResult.getSelectedValue());
            return true;
        }
        return false;
    }
}

