/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.gecko15.xpcom;

import com.jniwrapper.PlatformContext;
import com.teamdev.jxbrowser.gecko15.xpcom.XPCOM;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIThread;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIThreadManager;
import com.teamdev.jxbrowser.gecko15.xpcom.linux.LinuxMozillaThread;
import com.teamdev.jxbrowser.gecko15.xpcom.mac.MacMozillaThread;
import com.teamdev.jxbrowser.gecko15.xpcom.windows.WindowsMozillaThread;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;

public abstract class MozillaThread {
    private static final String a = "AWT-AppKit";
    private static final String b = "AppKit Thread";
    public static final String WINDOWS_LINUX_THREAD_NAME = "XPCOM";

    public static MozillaThread create() {
        if (PlatformContext.isWindows()) {
            return new WindowsMozillaThread();
        }
        if (PlatformContext.isLinux()) {
            return new LinuxMozillaThread();
        }
        if (PlatformContext.isMacOS()) {
            return new MacMozillaThread();
        }
        throw new IllegalStateException("Unsupported operating system.");
    }

    public static boolean isMozillaThread() {
        return Thread.currentThread().getName().equals(MozillaThread.a());
    }

    private static String a() {
        String string = WINDOWS_LINUX_THREAD_NAME;
        if (PlatformContext.isMacOS()) {
            string = MozillaThread.b() ? b : a;
        }
        return string;
    }

    private static boolean b() {
        return MozillaThread.c().floatValue() >= 1.7f;
    }

    private static Float c() {
        return Float.valueOf(System.getProperty("java.specification.version"));
    }

    public abstract void dispatchToMainThreadAndWait(Runnable var1);

    public abstract void dispatchToMainThread(Runnable var1);

    public void dispatchToAWTThreadAndWait(final Runnable runnable) {
        final AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    runnable.run();
                }
                finally {
                    atomicBoolean.set(false);
                }
            }
        });
        nsIThread nsIThread2 = this.d();
        while (atomicBoolean.get()) {
            nsIThread2.processNextEvent(true);
        }
    }

    private nsIThread d() {
        nsIThreadManager nsIThreadManager2 = XPCOM.getService("@mozilla.org/thread-manager;1", nsIThreadManager.class);
        return nsIThreadManager2.getMainThread();
    }
}

