/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.gecko15.xpcom;

import com.teamdev.jxbrowser.gecko15.xpcom.Mozilla;
import com.teamdev.jxbrowser.gecko15.xpcom.MozillaThread;
import com.teamdev.jxbrowser.gecko15.xpcom.XPCOMException;
import com.teamdev.jxbrowser.gecko15.xpcom.XPCOMJavaProxyManager;
import com.teamdev.jxbrowser.gecko15.xpcom.XULRunnerExtractor;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIComponentManager;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIServiceManager;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsISupports;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPCOM {
    private static final Logger a = LoggerFactory.getLogger(XPCOM.class);
    private static final XPCOM b = new XPCOM();
    private final MozillaThread c;

    public static void invokeAndWait(Runnable runnable) {
        b.c().dispatchToMainThreadAndWait(runnable);
    }

    public static void invokeLater(Runnable runnable) {
        b.c().dispatchToMainThread(runnable);
    }

    public static void invokeInAWTThreadAndWait(Runnable runnable) {
        if (!XPCOM.isMozillaThread()) {
            throw new IllegalStateException("The invokeInAWTThreadAndWait can be used only in Mozilla Thread.");
        }
        b.c().dispatchToAWTThreadAndWait(runnable);
    }

    public static boolean isMozillaThread() {
        return MozillaThread.isMozillaThread();
    }

    public static <T extends nsISupports> T getService(String string, Class<T> clazz) {
        try {
            nsIServiceManager nsIServiceManager2 = Mozilla.GetServiceManager();
            String string2 = XPCOMJavaProxyManager.getInterfaceIID(clazz);
            nsISupports nsISupports2 = nsIServiceManager2.getServiceByContractID(string, string2);
            return (T)((nsISupports)clazz.cast(nsISupports2));
        }
        catch (XPCOMException xPCOMException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(clazz.getName());
            stringBuilder.append(" not implemented by ");
            stringBuilder.append(string);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
    }

    public static <T extends nsISupports> T queryInterface(nsISupports nsISupports2, Class<T> clazz) {
        try {
            String string = XPCOMJavaProxyManager.getInterfaceIID(clazz);
            nsISupports nsISupports3 = nsISupports2.queryInterface(string);
            return (T)((nsISupports)clazz.cast(nsISupports3));
        }
        catch (XPCOMException xPCOMException) {
            throw new ClassCastException(nsISupports2 + " not extends " + clazz.getName());
        }
    }

    public static <T extends nsISupports> T createComponent(String string, Class<T> clazz) {
        nsIComponentManager nsIComponentManager2 = Mozilla.GetComponentManager();
        String string2 = XPCOMJavaProxyManager.getInterfaceIID(clazz);
        nsISupports nsISupports2 = nsIComponentManager2.createInstanceByContractID(string, null, string2);
        return (T)((nsISupports)clazz.cast(nsISupports2));
    }

    public static <T extends nsISupports> boolean isInstanceOf(nsISupports nsISupports2, Class<T> clazz) {
        try {
            T t = XPCOM.queryInterface(nsISupports2, clazz);
            Mozilla.release(t);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private XPCOM() {
        this.d();
        this.a();
        this.c = MozillaThread.create();
    }

    private void a() {
        if (this.b()) {
            XULRunnerExtractor.create().extract();
        }
    }

    private boolean b() {
        String string = System.getProperty("GRE_HOME");
        return string == null || string.length() == 0;
    }

    private MozillaThread c() {
        return this.c;
    }

    private void d() {
        if (this.e()) {
            a.debug("JxBrowser is used in Java Web Start");
            System.setSecurityManager(null);
        } else if (this.f()) {
            a.debug("JxBrowser is used in Java Applet");
            System.setSecurityManager(null);
        } else {
            System.setProperty("jxbrowser.run.applets", "true");
        }
    }

    private boolean e() {
        try {
            Class<?> clazz = Class.forName("javax.jnlp.ServiceManager");
            if (clazz == null) {
                return false;
            }
            Method method = clazz.getMethod("lookup", String.class);
            if (method == null) {
                return false;
            }
            Object object = method.invoke(null, "javax.jnlp.BasicService");
            return object != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean f() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return false;
        }
        String string = securityManager.getClass().getName();
        return "sun.plugin2.applet.Applet2SecurityManager".equals(string) || "sun.plugin.security.ActivatorSecurityManager".equals(string);
    }
}

