/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.gecko15.xpcom;

import com.teamdev.jxbrowser.gecko15.xpcom.XPCOMJavaProxy;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsISupports;
import com.teamdev.jxbrowser.gecko15.xpcom.nsID;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class XPCOMJavaProxyManager {
    private static final Map<String, Object> a = new HashMap<String, Object>();
    private static final Map<Object, Long> b = new HashMap<Object, Long>();

    public static boolean isSameXPCOMObjects(XPCOMJavaProxy xPCOMJavaProxy, XPCOMJavaProxy xPCOMJavaProxy2) {
        return xPCOMJavaProxy.nsISupportPtr() == xPCOMJavaProxy2.nsISupportPtr();
    }

    public static boolean proxyEquals(XPCOMJavaProxy xPCOMJavaProxy, XPCOMJavaProxy xPCOMJavaProxy2) {
        if (xPCOMJavaProxy == xPCOMJavaProxy2) {
            return Boolean.TRUE;
        }
        return XPCOMJavaProxyManager.isSameXPCOMObjects(xPCOMJavaProxy, xPCOMJavaProxy2);
    }

    public static boolean isXPCOMJavaProxy(Object object) {
        if (object != null && Proxy.isProxyClass(object.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
            return invocationHandler instanceof XPCOMJavaProxy;
        }
        return false;
    }

    public static XPCOMJavaProxy toXPCOMJavaProxy(Object object) {
        if (XPCOMJavaProxyManager.isXPCOMJavaProxy(object)) {
            return (XPCOMJavaProxy)Proxy.getInvocationHandler(object);
        }
        throw new IllegalArgumentException();
    }

    public static Class findClassInLoader(Object object, String string) {
        try {
            if (object == null) {
                return Class.forName(string);
            }
            return Class.forName(string, true, object.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    public static String nsIDToString(int n2, short s, short s2, byte by, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8) {
        nsID nsID2 = new nsID(n2, s, s2, by, by2, by3, by4, by5, by6, by7, by8);
        return nsID2.toString();
    }

    public static Object findProxy(long l2, String string) {
        for (String string2 : a.keySet()) {
            Object object;
            XPCOMJavaProxy xPCOMJavaProxy;
            if (!string.equalsIgnoreCase(string2) || (xPCOMJavaProxy = XPCOMJavaProxyManager.toXPCOMJavaProxy(object = a.get(string2))).nsISupportPtr() != l2) continue;
            return object;
        }
        return null;
    }

    public static Object createProxy(Class clazz, long l2, long l3) {
        ClassLoader classLoader = XPCOMJavaProxy.class.getClassLoader();
        String string = XPCOMJavaProxyManager.getInterfaceIID(clazz);
        XPCOMJavaProxy xPCOMJavaProxy = new XPCOMJavaProxy(string, l2, l3, clazz.getSimpleName());
        Object object = Proxy.newProxyInstance(classLoader, new Class[]{clazz}, (InvocationHandler)xPCOMJavaProxy);
        a.put(string, object);
        return object;
    }

    public static void registerXPTCStub(Object object, long l2) {
        if (!XPCOMJavaProxyManager.isXPTCStubRegistered(object)) {
            b.put(object, l2);
        }
    }

    public static void unregisterXPTCStub(Object object) {
        if (XPCOMJavaProxyManager.isXPTCStubRegistered(object)) {
            b.remove(object);
        }
    }

    public static boolean isXPTCStubRegistered(Object object) {
        return b.containsKey(object);
    }

    public static long getXPTCStubPtr(Object object) {
        return b.get(object);
    }

    public static String getInterfaceIID(Class clazz) {
        Field[] fieldArray;
        for (Field field : fieldArray = clazz.getFields()) {
            if (!field.getName().endsWith("_IID")) continue;
            try {
                return (String)field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }
        throw new IllegalArgumentException();
    }

    public static nsISupports queryInterface(nsISupports nsISupports2, String string) {
        ArrayList arrayList = new ArrayList();
        arrayList.add(nsISupports2.getClass());
        while (!arrayList.isEmpty()) {
            Object object;
            Class clazz = (Class)arrayList.remove(0);
            String string2 = clazz.getName();
            if (string2.startsWith("java.") || string2.startsWith("javax.")) continue;
            if (clazz.isInterface() && string2.startsWith("com.teamdev.jxbrowser.gecko15.xpcom.interfaces") && (object = XPCOMJavaProxyManager.getInterfaceIID(clazz)) != null && string.equals(object)) {
                return nsISupports2;
            }
            object = clazz.getInterfaces();
            Collections.addAll(arrayList, object);
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 == null) continue;
            arrayList.add(clazz2);
        }
        return null;
    }
}

