/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.gecko15.xpcom;

import com.jniwrapper.PlatformContext;
import com.teamdev.jxbrowser.gecko15.xpcom.mac.MacXULRunnerExtractor;
import com.teamdev.jxbrowser.gecko15.xpcom.windows.WindowsXULRunnerExtractor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public abstract class XULRunnerExtractor {
    public static final String XULRUNNER_UNKNOWN_VERSION = "unknown";

    public static XULRunnerExtractor create() {
        if (PlatformContext.isWindows()) {
            return new WindowsXULRunnerExtractor();
        }
        if (PlatformContext.isMacOS()) {
            return new MacXULRunnerExtractor();
        }
        throw new IllegalStateException("Unsupported operating system.");
    }

    public void extract() {
        if (this.isOSValid()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                public Void a() {
                    File file = XULRunnerExtractor.this.b();
                    if (XULRunnerExtractor.this.a(file)) {
                        XULRunnerExtractor.this.extract(file);
                    }
                    return null;
                }
            });
        } else {
            this.a();
        }
    }

    private boolean a(File file) {
        return !file.isDirectory() || !file.exists() || !new File(file, this.getXPCOMNativeLibraryName()).exists();
    }

    protected abstract boolean isOSValid();

    protected abstract String getXPCOMNativeLibraryName();

    protected abstract String getXULRunnerInfoFileName();

    protected abstract void extract(File var1);

    private void a() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("JxBrowser library doesn't support current operating system: \n").append("\tOS: ").append(System.getProperty("os.name")).append("\n").append("\tOS architecture: ").append(System.getProperty("os.arch")).append("\n").append("\tJava vendor: ").append(System.getProperty("java.vendor")).append("\n").append("\tJava version: ").append(System.getProperty("java.version")).append("\n").append("\tExecution data model: ").append(System.getProperty("sun.arch.data.model")).append("-bit").append("\n");
        throw new Error(stringBuilder.toString());
    }

    protected String getUserHome() {
        return System.getProperty("user.home");
    }

    protected static void throwErrorMessage(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("JxBrowser cannot find XULRunner library in class path.\n");
        stringBuilder.append("\tXULRunner is expected to be in <any-jar-in-your-application-class-path>").append(string).append("\n");
        stringBuilder.append("\tCurrent class path: ").append(System.getProperty("java.class.path")).append("\n");
        throw new Error(stringBuilder.toString());
    }

    private File b() {
        String string = this.c();
        String string2 = this.getXULRunnerVersion();
        String string3 = "xulrunner-" + string2;
        File file = new File(string, string3);
        System.setProperty("GRE_HOME", file.getAbsolutePath());
        System.setProperty("jxbrowser.home.dir", string);
        System.setProperty("jxbrowser.xulrunner.version", string2);
        return file;
    }

    private String c() {
        String string = this.getUserHome() + File.separator + ".JxBrowser";
        return System.getProperty("jxbrowser.home.dir", string);
    }

    public String getXULRunnerVersion() {
        if (this.d()) {
            try {
                Properties properties = new Properties();
                properties.load(this.e());
                return properties.getProperty("xulrunner.version", XULRUNNER_UNKNOWN_VERSION);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return XULRUNNER_UNKNOWN_VERSION;
    }

    private boolean d() {
        return this.e() != null;
    }

    private InputStream e() {
        return XULRunnerExtractor.class.getResourceAsStream(this.getXULRunnerInfoFileName());
    }
}

