/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.mozilla15;

import com.teamdev.jxbrowser.AbstractBrowser;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.BrowserFunction;
import com.teamdev.jxbrowser.BrowserServices;
import com.teamdev.jxbrowser.BrowserType;
import com.teamdev.jxbrowser.Configurable;
import com.teamdev.jxbrowser.ContextMenuHandler;
import com.teamdev.jxbrowser.NewWindowContainer;
import com.teamdev.jxbrowser.NewWindowManager;
import com.teamdev.jxbrowser.NewWindowParams;
import com.teamdev.jxbrowser.VisualWindowContainer;
import com.teamdev.jxbrowser.WebPolicyDelegate;
import com.teamdev.jxbrowser.dom.DOMFactory;
import com.teamdev.jxbrowser.events.DisposeEvent;
import com.teamdev.jxbrowser.events.HistoryChangeEvent;
import com.teamdev.jxbrowser.events.HistoryChangeListener;
import com.teamdev.jxbrowser.events.NavigationEvent;
import com.teamdev.jxbrowser.events.NavigationFinishedEvent;
import com.teamdev.jxbrowser.events.NavigationStatusCode;
import com.teamdev.jxbrowser.events.NavigationType;
import com.teamdev.jxbrowser.events.ProgressChangedEvent;
import com.teamdev.jxbrowser.events.StatusChangedEvent;
import com.teamdev.jxbrowser.events.TitleChangedEvent;
import com.teamdev.jxbrowser.gecko15.MozillaHttpObserverService;
import com.teamdev.jxbrowser.gecko15.SearchParams;
import com.teamdev.jxbrowser.gecko15.WebBrowser;
import com.teamdev.jxbrowser.gecko15.download.DefaultDownloadHandler;
import com.teamdev.jxbrowser.gecko15.download.DownloadHandler;
import com.teamdev.jxbrowser.gecko15.events.BrowserHttpObserver;
import com.teamdev.jxbrowser.gecko15.events.BrowserWindowAdapter;
import com.teamdev.jxbrowser.gecko15.events.BrowserWindowEvent;
import com.teamdev.jxbrowser.gecko15.events.ContextMenuEvent;
import com.teamdev.jxbrowser.gecko15.events.ContextMenuListener;
import com.teamdev.jxbrowser.gecko15.events.DisposeListener;
import com.teamdev.jxbrowser.gecko15.events.HttpObserver;
import com.teamdev.jxbrowser.gecko15.events.LocationEvent;
import com.teamdev.jxbrowser.gecko15.events.ProgressEvent;
import com.teamdev.jxbrowser.gecko15.events.RequestAdapter;
import com.teamdev.jxbrowser.gecko15.events.RequestListener;
import com.teamdev.jxbrowser.gecko15.events.SecurityEvent;
import com.teamdev.jxbrowser.gecko15.events.StateEvent;
import com.teamdev.jxbrowser.gecko15.events.StatusChangeEvent;
import com.teamdev.jxbrowser.gecko15.events.StatusChangeListener;
import com.teamdev.jxbrowser.gecko15.events.StatusEvent;
import com.teamdev.jxbrowser.gecko15.events.TitleChangeEvent;
import com.teamdev.jxbrowser.gecko15.events.TitleChangeListener;
import com.teamdev.jxbrowser.gecko15.popup.PopupHandler;
import com.teamdev.jxbrowser.gecko15.popup.PopupWindow;
import com.teamdev.jxbrowser.gecko15.prompt.CloseStatus;
import com.teamdev.jxbrowser.gecko15.prompt.ConfirmationBoxCloseStatus;
import com.teamdev.jxbrowser.gecko15.prompt.LoginResult;
import com.teamdev.jxbrowser.gecko15.prompt.PromptHandler;
import com.teamdev.jxbrowser.gecko15.prompt.PromptResult;
import com.teamdev.jxbrowser.gecko15.prompt.SelectResult;
import com.teamdev.jxbrowser.gecko15.script.JavaScriptExecutor;
import com.teamdev.jxbrowser.gecko15.xpcom.XPCOM;
import com.teamdev.jxbrowser.gecko15.xpcom.XPCOMError;
import com.teamdev.jxbrowser.gecko15.xpcom.XPCOMException;
import com.teamdev.jxbrowser.gecko15.xpcom.XPCOMJavaProxyManager;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsICertOverrideService;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIChannel;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIHttpChannel;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIInterfaceRequestor;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIPrefBranch;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIPrefService;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIRecentBadCertsService;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIRequest;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsISSLStatus;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIStreamListener;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsISupports;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIURI;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIURIContentListener;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIWebBrowserFind;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIWebBrowserFindInFrames;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIX509Cert;
import com.teamdev.jxbrowser.mozilla15.MozillaConfigurable;
import com.teamdev.jxbrowser.mozilla15.MozillaJavaScriptJavaBridge;
import com.teamdev.jxbrowser.mozilla15.b;
import com.teamdev.jxbrowser.mozilla15.dom.MozillaDOMFactory;
import com.teamdev.jxbrowser.mozilla15.print.MozillaPrinting;
import com.teamdev.jxbrowser.print.PrintAdapter;
import com.teamdev.jxbrowser.print.PrintEvent;
import com.teamdev.jxbrowser.print.PrintListener;
import com.teamdev.jxbrowser.prompt.DialogParams;
import com.teamdev.jxbrowser.prompt.PromptDialogParams;
import com.teamdev.jxbrowser.prompt.PromptService;
import com.teamdev.jxbrowser.script.JavaScriptException;
import com.teamdev.jxbrowser.security.HttpSecurityAction;
import com.teamdev.jxbrowser.security.HttpSecurityHandler;
import com.teamdev.jxbrowser.security.SecurityProblem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MozillaBrowser
extends AbstractBrowser<WebBrowser> {
    private final com.teamdev.jxbrowser.gecko15.Browser a;
    private final DOMFactory b;
    private final b c;
    private final Configurable d;
    private final MozillaHttpObserverService e;
    private final MozillaJavaScriptJavaBridge f;
    private String g;
    private boolean h;
    private HttpSecurityHandler i;
    private ContextMenuHandler j;
    private boolean k;

    MozillaBrowser(com.teamdev.jxbrowser.gecko15.Browser browser) {
        this.a = browser;
        this.e = new MozillaHttpObserverService();
        this.c = new b(browser.getNsIWebBrowser());
        this.d = new MozillaConfigurable(this.a);
        this.b = new MozillaDOMFactory(browser.getNsIWebBrowser());
        this.f = new MozillaJavaScriptJavaBridge();
        this.g();
        this.j();
        this.i();
        this.h();
        this.k();
        this.f();
        this.d();
        this.c();
        this.b();
        this.a();
        this.e();
    }

    private void a() {
        this.a.addRequestListener(new RequestAdapter(){

            @Override
            public void stateChanged(StateEvent stateEvent) {
                boolean bl;
                boolean bl2 = bl = MozillaBrowser.this.i != null;
                if (((stateEvent.getStateFlags() ^ 0xFFFFFFFFFFFFFFFFL) & 0x20010L) == 0L && bl) {
                    this.a(stateEvent.getRequest(), stateEvent.getStatus());
                }
            }

            private void a(nsIRequest nsIRequest2, long l2) {
                if (XPCOMError.getModule(l2) == 21L) {
                    nsIChannel nsIChannel2 = XPCOM.queryInterface(nsIRequest2, nsIChannel.class);
                    nsIURI nsIURI2 = nsIChannel2.getURI();
                    String string = nsIURI2.getHostPort();
                    nsIRecentBadCertsService nsIRecentBadCertsService2 = XPCOM.getService("@mozilla.org/security/recentbadcerts;1", nsIRecentBadCertsService.class);
                    nsISSLStatus nsISSLStatus2 = nsIRecentBadCertsService2.getRecentBadCert(string);
                    List<SecurityProblem> list = this.a(nsISSLStatus2);
                    HttpSecurityAction httpSecurityAction = MozillaBrowser.this.i.onSecurityProblem(new HashSet<SecurityProblem>(list));
                    if (httpSecurityAction == HttpSecurityAction.ABORT) {
                        MozillaBrowser.this.stop();
                    } else if (httpSecurityAction == HttpSecurityAction.CONTINUE) {
                        nsIX509Cert nsIX509Cert4 = nsISSLStatus2.getServerCert();
                        this.a(nsIX509Cert4, nsIURI2.getHost(), nsIURI2.getPort(), list);
                        MozillaBrowser.this.k = true;
                        MozillaBrowser.this.navigate(nsIURI2.getSpec());
                    }
                }
            }

            private List<SecurityProblem> a(nsISSLStatus nsISSLStatus2) {
                ArrayList<SecurityProblem> arrayList = new ArrayList<SecurityProblem>();
                if (nsISSLStatus2.getIsUntrusted()) {
                    arrayList.add(SecurityProblem.NOT_TRUSTED_CERTIFICATE);
                }
                if (nsISSLStatus2.getIsDomainMismatch()) {
                    arrayList.add(SecurityProblem.INVALID_CERTIFICATE_NAME);
                }
                if (nsISSLStatus2.getIsNotValidAtThisTime()) {
                    arrayList.add(SecurityProblem.INVALID_CERTIFICATE_DATE);
                }
                return arrayList;
            }

            private void a(nsIX509Cert nsIX509Cert4, String string, int n2, List<SecurityProblem> list) {
                nsICertOverrideService nsICertOverrideService2 = XPCOM.getService("@mozilla.org/security/certoverride;1", nsICertOverrideService.class);
                nsICertOverrideService2.rememberValidityOverride(string, n2, nsIX509Cert4, this.a(list), true);
            }

            private long a(List<SecurityProblem> list) {
                long l2 = 0L;
                if (list.contains(SecurityProblem.NOT_TRUSTED_CERTIFICATE)) {
                    l2 |= 1L;
                }
                if (list.contains(SecurityProblem.INVALID_CERTIFICATE_DATE)) {
                    l2 |= 4L;
                }
                if (list.contains(SecurityProblem.INVALID_CERTIFICATE_NAME)) {
                    l2 |= 2L;
                }
                return l2;
            }
        });
    }

    private void b() {
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                MozillaBrowser.this.a.getNsIWebBrowser().setParentURIContentListener(new nsIURIContentListener(){

                    public boolean onStartURIOpen(nsIURI nsIURI2) {
                        NavigationEvent navigationEvent = new NavigationEvent((Browser)MozillaBrowser.this, nsIURI2.getSpec());
                        WebPolicyDelegate webPolicyDelegate = MozillaBrowser.this.getServices().getWebPolicyDelegate();
                        boolean bl = webPolicyDelegate.allowNavigation(navigationEvent);
                        if (!bl) {
                            MozillaBrowser.this.setNavigationFinished(true);
                        }
                        return !bl;
                    }

                    public boolean isPreferred(String string, String[] stringArray) {
                        NavigationEvent navigationEvent = new NavigationEvent((Browser)MozillaBrowser.this, null);
                        WebPolicyDelegate webPolicyDelegate = MozillaBrowser.this.getServices().getWebPolicyDelegate();
                        boolean bl = webPolicyDelegate.allowMimeType(string, navigationEvent);
                        if (!bl) {
                            MozillaBrowser.this.setNavigationFinished(true);
                        }
                        boolean bl2 = MozillaBrowser.this.isMimeTypeSupported(string);
                        return bl && bl2;
                    }

                    public boolean canHandleContent(String string, boolean bl, String[] stringArray) {
                        return true;
                    }

                    public boolean doContent(String string, boolean bl, nsIRequest nsIRequest2, nsIStreamListener[] nsIStreamListenerArray) {
                        throw new XPCOMException(2147500033L);
                    }

                    public nsISupports getLoadCookie() {
                        throw new XPCOMException(2147500033L);
                    }

                    public void setLoadCookie(nsISupports nsISupports2) {
                        throw new XPCOMException(2147500033L);
                    }

                    public nsIURIContentListener getParentContentListener() {
                        throw new XPCOMException(2147500033L);
                    }

                    public void setParentContentListener(nsIURIContentListener nsIURIContentListener2) {
                        throw new XPCOMException(2147500033L);
                    }

                    public nsISupports queryInterface(String string) {
                        return XPCOMJavaProxyManager.queryInterface(this, string);
                    }
                });
            }
        });
    }

    private void c() {
        this.a.addRequestListener(new RequestListener(){

            public void locationChanged(LocationEvent locationEvent) {
                if (MozillaBrowser.this.isNavigationFinished()) {
                    String string = locationEvent.getLocation();
                    this.a(string, NavigationType.NAVIGATE);
                    this.a(NavigationStatusCode.OK, string);
                }
            }

            public void stateChanged(StateEvent stateEvent) {
                String string;
                if (stateEvent.isRedirecting()) {
                    string = stateEvent.getRequestUrlName();
                    this.a(string, NavigationType.REDIRECT);
                }
                if (stateEvent.isLoadingStarted()) {
                    string = stateEvent.getRequestUrlName();
                    this.a(string, NavigationType.NAVIGATE);
                }
                if (stateEvent.isLoadingCompleted()) {
                    string = stateEvent.getRequestUrlName();
                    NavigationStatusCode navigationStatusCode = this.a(stateEvent);
                    this.a(navigationStatusCode, string);
                }
                if (stateEvent.isStoped()) {
                    MozillaBrowser.this.notifyListeners(new StatusChangedEvent((Browser)MozillaBrowser.this, ""));
                }
            }

            private void a(NavigationStatusCode navigationStatusCode, String string) {
                if (MozillaBrowser.this.k) {
                    MozillaBrowser.this.k = false;
                    return;
                }
                MozillaBrowser.this.setNavigationFinished(true);
                MozillaBrowser.this.notifyListeners(new NavigationFinishedEvent((Browser)MozillaBrowser.this, navigationStatusCode, string));
            }

            private void a(String string, NavigationType navigationType) {
                MozillaBrowser.this.setNavigationFinished(false);
                MozillaBrowser.this.notifyListeners(new NavigationEvent((Browser)MozillaBrowser.this, string, null, navigationType));
            }

            public void progressChanged(ProgressEvent progressEvent) {
                long l2 = progressEvent.getCurTotalProgress();
                long l3 = progressEvent.getMaxTotalProgress();
                if (l3 == -1L) {
                    return;
                }
                if (l2 > l3) {
                    l2 = l3;
                }
                MozillaBrowser.this.notifyListeners(new ProgressChangedEvent((Browser)MozillaBrowser.this, l2, l3));
            }

            public void statusChanged(StatusEvent statusEvent) {
                MozillaBrowser.this.notifyListeners(new StatusChangedEvent((Browser)MozillaBrowser.this, statusEvent.getMessage()));
            }

            public void securityChanged(SecurityEvent securityEvent) {
            }

            private NavigationStatusCode a(StateEvent stateEvent) {
                try {
                    nsIRequest nsIRequest2 = stateEvent.getRequest();
                    nsIHttpChannel nsIHttpChannel2 = XPCOM.queryInterface(nsIRequest2, nsIHttpChannel.class);
                    if (nsIHttpChannel2 == null) {
                        return NavigationStatusCode.UNKNOWN;
                    }
                    if (nsIHttpChannel2.getRequestSucceeded()) {
                        return NavigationStatusCode.OK;
                    }
                    long l2 = nsIHttpChannel2.getResponseStatus();
                    String string = nsIHttpChannel2.getResponseStatusText();
                    return new NavigationStatusCode(l2, string);
                }
                catch (Exception exception) {
                    return NavigationStatusCode.UNKNOWN;
                }
            }
        });
    }

    private void d() {
        this.a.addStatusChangeListener(new StatusChangeListener(){

            public void statusChanged(StatusChangeEvent statusChangeEvent) {
                String string = MozillaBrowser.this.getStatusMessage();
                String string2 = statusChangeEvent.getStatus();
                if (string2.equals(string) && string.equals("Done")) {
                    return;
                }
                MozillaBrowser.this.a(string2);
                MozillaBrowser.this.notifyListeners(new StatusChangedEvent((Browser)MozillaBrowser.this, string2));
            }
        });
    }

    private void e() {
        this.a.addDisposeListener(new DisposeListener(){

            public void disposed() {
                MozillaBrowser.this.notifyListeners(new DisposeEvent((Browser)MozillaBrowser.this));
            }
        });
    }

    private void f() {
        this.a.addTitleChangeListener(new TitleChangeListener(){

            public void titleChanged(TitleChangeEvent titleChangeEvent) {
                MozillaBrowser.this.notifyListeners(new TitleChangedEvent((Browser)MozillaBrowser.this, titleChangeEvent.getTitle()));
            }
        });
    }

    private void g() {
        this.c.a(new HistoryChangeListener(){

            public void a(HistoryChangeEvent historyChangeEvent) {
                HistoryChangeEvent historyChangeEvent2 = new HistoryChangeEvent((Browser)MozillaBrowser.this, historyChangeEvent.getIndex(), historyChangeEvent.getCurrentLocation(), historyChangeEvent.getType());
                List list = MozillaBrowser.this.getHistoryChangeListeners();
                for (HistoryChangeListener historyChangeListener : list) {
                    historyChangeListener.historyChanged(historyChangeEvent2);
                }
            }
        });
    }

    private void h() {
        this.a.setDownloadHandler(new DefaultDownloadHandler(this.getComponent()));
    }

    private void i() {
        this.a.setPopupHandler(new k());
    }

    private void j() {
        this.a.setPromptHandler(new j());
    }

    private void k() {
        this.a.addContextMenuListener(new l());
    }

    public void dispose() {
        super.dispose();
        if (!this.isDisposed()) {
            this.l();
            this.a.dispose();
        }
    }

    private void l() {
        List<HttpObserver> list = this.e.getHttpObservers();
        for (HttpObserver httpObserver : list) {
            this.e.removeHttpObserver(httpObserver);
        }
    }

    public Configurable getConfigurable() {
        return this.d;
    }

    public void setUserAgent(final String string) {
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                nsIPrefService nsIPrefService2 = XPCOM.getService("@mozilla.org/preferences-service;1", nsIPrefService.class);
                nsIPrefBranch nsIPrefBranch3 = nsIPrefService2.getBranch("general.useragent.");
                if (string == null || string.length() == 0) {
                    int n2 = nsIPrefBranch3.getPrefType("override");
                    if (n2 != 0) {
                        nsIPrefBranch3.clearUserPref("override");
                    }
                } else {
                    nsIPrefBranch3.setCharPref("override", string);
                }
            }
        });
    }

    public String executeScript(String string) {
        String string2 = null;
        try {
            string2 = this.a.evaluateScript(string);
        }
        catch (Exception exception) {
            throw new JavaScriptException(exception.getMessage());
        }
        return string2;
    }

    public Component getComponent() {
        return this.a.getComponent();
    }

    public String getContent() {
        return this.getContent("text/html");
    }

    public String getContent(String string) {
        return this.a.getDocumentContent(string);
    }

    public Document getDocument() {
        return this.b.createDocument(this.a.getDocument());
    }

    public String getStatusMessage() {
        return this.g;
    }

    private void a(String string) {
        this.g = string;
    }

    public void setContextMenuHandler(ContextMenuHandler contextMenuHandler) {
        this.j = contextMenuHandler;
    }

    public ContextMenuHandler getContextMenuHandler() {
        return this.j;
    }

    public String getTitle() {
        return this.a.getTitle();
    }

    public BrowserType getType() {
        return BrowserType.Mozilla15;
    }

    public void goBack() {
        this.c.d();
    }

    public void goForward() {
        this.c.e();
    }

    public boolean isDisposed() {
        return this.a.isDisposed();
    }

    public boolean isNavigationFinished() {
        return this.h;
    }

    public void setNavigationFinished(boolean bl) {
        this.h = bl;
    }

    public void navigate(String string) {
        this.setNavigationFinished(false);
        this.a.navigate(string);
    }

    public void navigate(String string, String string2) {
        this.setNavigationFinished(false);
        this.a.navigate(string, string2);
    }

    public void navigate(String string, String string2, long l2) {
        this.setNavigationFinished(false);
        this.a.navigate(string, string2, l2);
    }

    public void refresh() {
        this.setNavigationFinished(false);
        this.a.refresh();
    }

    public void setContent(String string) {
        this.setNavigationFinished(false);
        this.a.setContent(string);
    }

    public void setContent(String string, String string2) {
        this.setNavigationFinished(false);
        this.a.setContent(string, "text/html", "UTF-8", string2);
    }

    public void stop() {
        this.a.stop();
    }

    public Image toImage(boolean bl) {
        return this.a.toImage();
    }

    public Image toImage(Dimension dimension) {
        return this.a.toImage(dimension);
    }

    public HttpSecurityHandler getHttpSecurityHandler() {
        return this.i;
    }

    public void setHttpSecurityHandler(HttpSecurityHandler httpSecurityHandler) {
        this.i = httpSecurityHandler;
    }

    public String getCurrentLocation() {
        return this.a.getLocationURL();
    }

    public boolean canGoBack() {
        return this.c.f();
    }

    public boolean canGoForward() {
        return this.c.g();
    }

    public List<String> getAllHistory() {
        return this.c.a();
    }

    public int getCurrentIndex() {
        return this.c.b();
    }

    public WebBrowser getPeer() {
        return this.a;
    }

    public void setHttpObserver(HttpObserver httpObserver) {
        this.e.addHttpObserver(new BrowserHttpObserver(httpObserver, this.getPeer().getNsIWebBrowser()));
    }

    public boolean isMimeTypeSupported(String string) {
        return this.a.isMimeTypeSupported(string);
    }

    public boolean isReady() {
        return this.isNavigationFinished();
    }

    public void registerFunction(String string, BrowserFunction browserFunction) {
        final StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("window.").append(string).append(" = function ").append(string).append("() {\n").append("    var javaScriptJavaBridge = Components.classes['").append(this.f.getContractID()).append("'].createInstance(Components.interfaces.nsIJavaScriptJavaBridge);\n").append("    var args = Components.classes['@mozilla.org/array;1'].createInstance(Components.interfaces.nsIMutableArray);\n").append("    for (var i = 0; i < arguments.length; i++) {\n").append("        var variant = Components.classes['@mozilla.org/variant;1'].createInstance(Components.interfaces.nsIWritableVariant);\n").append("        variant.setFromVariant(arguments[i]);\n").append("        args.appendElement(variant, false);\n").append("    }\n").append("    return javaScriptJavaBridge.callJavaFunction(\"").append(string).append("\", args);\n").append("}");
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                JavaScriptExecutor javaScriptExecutor = new JavaScriptExecutor();
                javaScriptExecutor.evaluateScript(stringBuilder.toString(), MozillaBrowser.this.a.getNsIWebBrowser());
            }
        });
        this.f.registerFunction(string, browserFunction);
    }

    public void print() {
        this.print(null);
    }

    public void print(final PrintListener printListener) {
        MozillaPrinting.create().print((PrintListener)new PrintAdapter(){

            public void a(PrintEvent printEvent) {
                if (printListener != null) {
                    printListener.finished(new PrintEvent((Browser)MozillaBrowser.this));
                }
            }

            public void b(PrintEvent printEvent) {
                if (printListener != null) {
                    printListener.started(new PrintEvent((Browser)MozillaBrowser.this));
                }
            }

            public void c(PrintEvent printEvent) {
                if (printListener != null) {
                    printListener.progressChanged(new PrintEvent((Browser)MozillaBrowser.this, printEvent.getCurrentProgress(), printEvent.getMaxProgress()));
                }
            }

            public void d(PrintEvent printEvent) {
                if (printListener != null) {
                    printListener.canceled(new PrintEvent((Browser)MozillaBrowser.this));
                }
            }
        }, this.a.getNsIWebBrowser());
    }

    public void saveWebPage(File file, String string) {
        this.a.saveWebPage(file, string);
    }

    public void setDownloadHandler(DownloadHandler downloadHandler) {
        this.a.setDownloadHandler(downloadHandler);
    }

    public DownloadHandler getDownloadHandler() {
        return this.a.getDownloadHandler();
    }

    public boolean find(String string) {
        return this.find(string, new SearchParams());
    }

    public boolean find(final String string, final SearchParams searchParams) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("text can't be null or empty.");
        }
        if (searchParams == null) {
            throw new NullPointerException("params can't be null.");
        }
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                nsIInterfaceRequestor nsIInterfaceRequestor2 = XPCOM.queryInterface(MozillaBrowser.this.getPeer().getNsIWebBrowser(), nsIInterfaceRequestor.class);
                nsIWebBrowserFind nsIWebBrowserFind2 = (nsIWebBrowserFind)nsIInterfaceRequestor2.getInterface("{2f977d44-5485-11d4-87e2-0010a4e75ef2}");
                nsIWebBrowserFind2.setSearchString(string);
                nsIWebBrowserFind2.setFindBackwards(searchParams.isBackward());
                nsIWebBrowserFind2.setMatchCase(searchParams.isCaseSensitive());
                nsIWebBrowserFind2.setEntireWord(searchParams.isEntireWords());
                nsIWebBrowserFind2.setWrapFind(searchParams.isWrapFind());
                nsIWebBrowserFind2.setSearchFrames(searchParams.isSearchInSubFrames());
                nsIWebBrowserFindInFrames nsIWebBrowserFindInFrames2 = XPCOM.queryInterface(nsIWebBrowserFind2, nsIWebBrowserFindInFrames.class);
                nsIWebBrowserFindInFrames2.setSearchSubframes(searchParams.isSearchInSubFrames());
                atomicBoolean.set(nsIWebBrowserFind2.findNext());
            }
        });
        return atomicBoolean.get();
    }

    private class l
    implements ContextMenuListener {
        private l() {
        }

        public void contextMenuRequested(ContextMenuEvent contextMenuEvent) {
            if (MozillaBrowser.this.j != null) {
                final Point point = new Point(contextMenuEvent.getX(), contextMenuEvent.getY());
                final Node node = contextMenuEvent.getTargetNode();
                MozillaBrowser.this.getEventsThread().invokeLater(new Runnable(){

                    public void run() {
                        MozillaBrowser.this.j.showContextMenu(new com.teamdev.jxbrowser.events.ContextMenuEvent((Browser)MozillaBrowser.this, node, point));
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class j
    implements PromptHandler {
        private j() {
        }

        @Override
        public void alertRequested(String string, String string2) {
            PromptService promptService = BrowserServices.getInstance().getPromptService();
            if (promptService != null) {
                promptService.alertRequested(new DialogParams((Browser)MozillaBrowser.this, string, string2, MozillaBrowser.this.getComponent()));
            }
        }

        @Override
        public PromptResult promptRequested(String string, String string2, String string3) {
            PromptService promptService = BrowserServices.getInstance().getPromptService();
            if (promptService != null) {
                PromptDialogParams promptDialogParams = new PromptDialogParams((Browser)MozillaBrowser.this, string, string2, string3, MozillaBrowser.this.getComponent());
                try {
                    com.teamdev.jxbrowser.prompt.CloseStatus closeStatus = promptService.promptRequested(promptDialogParams);
                    if (closeStatus != null) {
                        return new PromptResult(this.a(closeStatus), promptDialogParams.getValue());
                    }
                }
                catch (Exception exception) {
                    return new PromptResult(CloseStatus.OK, string3);
                }
            }
            return new PromptResult(CloseStatus.OK, string3);
        }

        @Override
        public CloseStatus confirmationRequested(String string, String string2) {
            PromptService promptService = BrowserServices.getInstance().getPromptService();
            if (promptService != null) {
                try {
                    com.teamdev.jxbrowser.prompt.CloseStatus closeStatus = promptService.confirmationRequested(new DialogParams((Browser)MozillaBrowser.this, string, string2, MozillaBrowser.this.getComponent()));
                    if (closeStatus != null) {
                        return this.a(closeStatus);
                    }
                }
                catch (Exception exception) {
                    return CloseStatus.OK;
                }
            }
            return CloseStatus.OK;
        }

        @Override
        public ConfirmationBoxCloseStatus confirmationBoxRequested(String string, String string2, List<String> list, ConfirmationBoxCloseStatus confirmationBoxCloseStatus) {
            return ConfirmationBoxCloseStatus.FIRST_BUTTON_PRESSED;
        }

        @Override
        public LoginResult loginRequested(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
            return new LoginResult(CloseStatus.CANCEL);
        }

        @Override
        public LoginResult passwordRequested(String string, String string2, String string3, String string4, boolean bl) {
            return new LoginResult(CloseStatus.CANCEL);
        }

        @Override
        public SelectResult selectRequested(String string, String string2, List<String> list) {
            return new SelectResult(CloseStatus.CANCEL);
        }

        private CloseStatus a(com.teamdev.jxbrowser.prompt.CloseStatus closeStatus) {
            switch (closeStatus) {
                case OK: 
                case YES: {
                    return CloseStatus.OK;
                }
            }
            return CloseStatus.CANCEL;
        }
    }

    private class k
    implements PopupHandler {
        private k() {
        }

        public PopupWindow popupRequested(String string, long l2) {
            Rectangle rectangle;
            NewWindowParams newWindowParams;
            NewWindowContainer newWindowContainer;
            BrowserServices browserServices = BrowserServices.getInstance();
            NewWindowManager newWindowManager = browserServices.getNewWindowManager();
            if (newWindowManager != null && (newWindowContainer = newWindowManager.evaluateWindow(newWindowParams = new NewWindowParams((Browser)MozillaBrowser.this, rectangle = MozillaBrowser.this.getComponent().getBounds(), "", string))) != null) {
                return new PopupWindow(){

                    public void setWebBrowser(com.teamdev.jxbrowser.gecko15.Browser browser) {
                        newWindowContainer.insertBrowser((Browser)new MozillaBrowser(browser));
                        if (newWindowContainer instanceof VisualWindowContainer) {
                            final VisualWindowContainer visualWindowContainer = (VisualWindowContainer)newWindowContainer;
                            browser.addBrowserWindowListener(new BrowserWindowAdapter(){

                                public void windowVisible(BrowserWindowEvent browserWindowEvent) {
                                    visualWindowContainer.setVisible(browserWindowEvent.isVisible());
                                }

                                public void windowSizeChanged(BrowserWindowEvent browserWindowEvent) {
                                    visualWindowContainer.setSize(browserWindowEvent.getSize());
                                }

                                public void windowLocationChanged(BrowserWindowEvent browserWindowEvent) {
                                    visualWindowContainer.setLocation(browserWindowEvent.getLocation());
                                }
                            });
                        }
                    }
                };
            }
            return null;
        }
    }
}

