/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import org.apache.axis.Constants;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class TypeMappingImpl
implements TypeMapping {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$encoding$TypeMappingImpl == null ? (class$org$apache$axis$encoding$TypeMappingImpl = TypeMappingImpl.class$("org.apache.axis.encoding.TypeMappingImpl")) : class$org$apache$axis$encoding$TypeMappingImpl).getName());
    private HashMap qName2Pair = new HashMap();
    private HashMap class2Pair = new HashMap();
    private HashMap pair2SF = new HashMap();
    private HashMap pair2DF = new HashMap();
    protected TypeMapping delegate;
    private ArrayList namespaces;
    private boolean doAutoTypes = false;
    static /* synthetic */ Class class$org$apache$axis$encoding$TypeMappingImpl;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public TypeMappingImpl(TypeMapping delegate) {
        this.delegate = delegate;
        this.namespaces = new ArrayList();
    }

    public void setDelegate(TypeMapping delegate) {
        this.delegate = delegate;
    }

    public TypeMapping getDelegate() {
        return this.delegate;
    }

    public String[] getSupportedEncodings() {
        String[] stringArray = new String[this.namespaces.size()];
        return this.namespaces.toArray(stringArray);
    }

    public void setSupportedEncodings(String[] namespaceURIs) {
        this.namespaces.clear();
        int i = 0;
        while (i < namespaceURIs.length) {
            if (!this.namespaces.contains(namespaceURIs[i])) {
                this.namespaces.add(namespaceURIs[i]);
            }
            ++i;
        }
    }

    public boolean isRegistered(Class javaType, QName xmlType) {
        if (javaType == null || xmlType == null) {
            throw new JAXRPCException(Messages.getMessage(javaType == null ? "badJavaType" : "badXmlType"));
        }
        if (this.pair2SF.keySet().contains(new Pair(javaType, xmlType))) {
            return true;
        }
        if (this.delegate != null) {
            return this.delegate.isRegistered(javaType, xmlType);
        }
        return false;
    }

    public void register(Class javaType, QName xmlType, SerializerFactory sf, DeserializerFactory dsf) throws JAXRPCException {
        if (sf == null && dsf == null) {
            throw new JAXRPCException(Messages.getMessage("badSerFac"));
        }
        this.internalRegister(javaType, xmlType, sf, dsf);
    }

    protected void internalRegister(Class javaType, QName xmlType, SerializerFactory sf, DeserializerFactory dsf) throws JAXRPCException {
        if (javaType == null || xmlType == null) {
            throw new JAXRPCException(Messages.getMessage(javaType == null ? "badJavaType" : "badXmlType"));
        }
        Pair pair = new Pair(javaType, xmlType);
        if (dsf != null || this.qName2Pair.get(xmlType) == null) {
            this.qName2Pair.put(xmlType, pair);
        }
        if (sf != null || this.class2Pair.get(javaType) == null) {
            this.class2Pair.put(javaType, pair);
        }
        if (sf != null) {
            this.pair2SF.put(pair, sf);
        }
        if (dsf != null) {
            this.pair2DF.put(pair, dsf);
        }
    }

    public SerializerFactory getSerializer(Class javaType, QName xmlType) throws JAXRPCException {
        Pair pair;
        SerializerFactory sf = null;
        if (xmlType == null) {
            xmlType = this.getTypeQName(javaType);
            if (xmlType == null) {
                return null;
            }
            if (this.doAutoTypes && xmlType.getNamespaceURI().equals("http://xml.apache.org/axis/java")) {
                return new BeanSerializerFactory(javaType, xmlType);
            }
        }
        if ((sf = (SerializerFactory)this.pair2SF.get(pair = new Pair(javaType, xmlType))) == null && (pair = javaType.isArray() ? (Pair)this.qName2Pair.get(Constants.SOAP_ARRAY) : (Pair)this.class2Pair.get(pair.javaType)) != null) {
            sf = (SerializerFactory)this.pair2SF.get(pair);
        }
        if (sf == null && this.delegate != null) {
            sf = this.delegate.getSerializer(javaType, xmlType);
        }
        return sf;
    }

    public QName getXMLType(Class javaType, QName xmlType) throws JAXRPCException {
        Pair pair;
        SerializerFactory sf = null;
        if (xmlType == null) {
            xmlType = this.getTypeQNameRecursive(javaType);
            if (xmlType == null) {
                return null;
            }
            if (this.doAutoTypes && xmlType.getNamespaceURI().equals("http://xml.apache.org/axis/java")) {
                return xmlType;
            }
        }
        if ((sf = (SerializerFactory)this.pair2SF.get(pair = new Pair(javaType, xmlType))) == null && (pair = javaType.isArray() ? (Pair)this.qName2Pair.get(pair.xmlType) : (Pair)this.class2Pair.get(pair.javaType)) != null) {
            sf = (SerializerFactory)this.pair2SF.get(pair);
        }
        if (sf == null && this.delegate != null) {
            return ((TypeMappingImpl)this.delegate).getXMLType(javaType, xmlType);
        }
        if (pair != null) {
            xmlType = pair.xmlType;
        }
        return xmlType;
    }

    public DeserializerFactory getDeserializer(Class javaType, QName xmlType) throws JAXRPCException {
        Pair pair;
        DeserializerFactory df = null;
        if (javaType == null) {
            javaType = this.getClassForQName(xmlType);
            if (javaType == null) {
                return null;
            }
            if (this.doAutoTypes && "http://xml.apache.org/axis/java".equals(xmlType.getNamespaceURI())) {
                try {
                    javaType = ClassUtils.forName(xmlType.getLocalPart());
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
                return new BeanDeserializerFactory(javaType, xmlType);
            }
        }
        if ((df = (DeserializerFactory)this.pair2DF.get(pair = new Pair(javaType, xmlType))) == null && this.delegate != null) {
            df = this.delegate.getDeserializer(javaType, xmlType);
        }
        return df;
    }

    public void removeSerializer(Class javaType, QName xmlType) throws JAXRPCException {
        if (javaType == null || xmlType == null) {
            throw new JAXRPCException(Messages.getMessage(javaType == null ? "badJavaType" : "badXmlType"));
        }
        Pair pair = new Pair(javaType, xmlType);
        this.pair2SF.remove(pair);
    }

    public void removeDeserializer(Class javaType, QName xmlType) throws JAXRPCException {
        if (javaType == null || xmlType == null) {
            throw new JAXRPCException(Messages.getMessage(javaType == null ? "badJavaType" : "badXmlType"));
        }
        Pair pair = new Pair(javaType, xmlType);
        this.pair2DF.remove(pair);
    }

    public QName getTypeQNameRecursive(Class javaType) {
        QName ret = null;
        while (javaType != null) {
            ret = this.getTypeQName(javaType);
            if (ret != null) {
                return ret;
            }
            Class<?>[] interfaces = javaType.getInterfaces();
            if (interfaces != null) {
                int i = 0;
                while (i < interfaces.length) {
                    Class<?> iface = interfaces[i];
                    ret = this.getTypeQName(iface);
                    if (ret != null) {
                        return ret;
                    }
                    ++i;
                }
            }
            javaType = javaType.getSuperclass();
        }
        return null;
    }

    public QName getTypeQName(Class javaType) {
        if (javaType == null) {
            return null;
        }
        QName xmlType = null;
        Pair pair = (Pair)this.class2Pair.get(javaType);
        if (pair == null && this.delegate != null) {
            xmlType = this.delegate.getTypeQName(javaType);
        } else if (pair != null) {
            xmlType = pair.xmlType;
        }
        if (xmlType == null && this.doAutoTypes) {
            xmlType = new QName("http://xml.apache.org/axis/java", javaType.getName());
        }
        if (xmlType == null && (javaType.isArray() || javaType == (class$java$util$List == null ? (class$java$util$List = TypeMappingImpl.class$("java.util.List")) : class$java$util$List) || (class$java$util$List == null ? (class$java$util$List = TypeMappingImpl.class$("java.util.List")) : class$java$util$List).isAssignableFrom(javaType))) {
            pair = (Pair)this.class2Pair.get(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = TypeMappingImpl.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object);
            xmlType = pair != null ? pair.xmlType : Constants.SOAP_ARRAY;
        }
        return xmlType;
    }

    public Class getClassForQName(QName xmlType) {
        Class javaType;
        block6: {
            if (xmlType == null) {
                return null;
            }
            javaType = null;
            Pair pair = (Pair)this.qName2Pair.get(xmlType);
            if (pair == null && this.delegate != null) {
                javaType = this.delegate.getClassForQName(xmlType);
            } else if (pair != null) {
                javaType = pair.javaType;
            }
            if (javaType != null || !this.doAutoTypes || !"http://xml.apache.org/axis/java".equals(xmlType.getNamespaceURI())) break block6;
            try {
                javaType = ClassUtils.forName(xmlType.getLocalPart());
            }
            catch (ClassNotFoundException e) {}
        }
        return javaType;
    }

    public SerializerFactory getSerializer(Class javaType) throws JAXRPCException {
        return this.getSerializer(javaType, null);
    }

    public DeserializerFactory getDeserializer(QName xmlType) throws JAXRPCException {
        return this.getDeserializer(null, xmlType);
    }

    public void setDoAutoTypes(boolean doAutoTypes) {
        this.doAutoTypes = doAutoTypes;
    }

    public Class[] getAllClasses() {
        HashSet<Class<Object>> temp = new HashSet<Class<Object>>();
        if (this.delegate != null) {
            temp.addAll(Arrays.asList(this.delegate.getAllClasses()));
        }
        temp.addAll(this.class2Pair.keySet());
        return temp.toArray(new Class[temp.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Pair {
        public Class javaType;
        public QName xmlType;

        public Pair(Class javaType, QName xmlType) {
            this.javaType = javaType;
            this.xmlType = xmlType;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            Pair p = (Pair)o;
            if (p.xmlType == this.xmlType && p.javaType == this.javaType) {
                return true;
            }
            return p.xmlType.equals(this.xmlType) && p.javaType.equals(this.javaType);
        }

        public int hashCode() {
            int hashcode = 0;
            if (this.javaType != null) {
                hashcode ^= this.javaType.hashCode();
            }
            if (this.xmlType != null) {
                hashcode ^= this.xmlType.hashCode();
            }
            return hashcode;
        }
    }
}

