/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkedOutputStream
extends FilterOutputStream {
    boolean eos = false;
    static final byte[] crlf = "\r\n".getBytes();

    private ChunkedOutputStream() {
        super(null);
    }

    public ChunkedOutputStream(OutputStream os) {
        super(os);
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        this.out.write(Integer.toHexString(len).getBytes());
        this.out.write(crlf);
        this.out.write(b, off, len);
        this.out.write(crlf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eos() throws IOException {
        ChunkedOutputStream chunkedOutputStream = this;
        synchronized (chunkedOutputStream) {
            if (this.eos) {
                return;
            }
            this.eos = true;
        }
        this.out.write("\r\n0\r\n".getBytes());
        this.out.flush();
    }

    public void close() throws IOException {
        this.eos();
        this.out.close();
    }
}

