/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.wsdl.Message;
import org.apache.axis.enum.Use;
import org.apache.axis.wsdl.symbolTable.FaultInfo;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaFaultWriter
extends JavaClassWriter {
    private Message faultMessage;
    private SymbolTable symbolTable;
    private boolean literal;
    private String faultName;

    protected JavaFaultWriter(Emitter emitter, SymbolTable symbolTable, FaultInfo faultInfo) {
        super(emitter, Utils.getFullExceptionName(faultInfo.getMessage(), symbolTable), "fault");
        this.literal = faultInfo.getUse().equals(Use.LITERAL);
        this.faultMessage = faultInfo.getMessage();
        this.symbolTable = symbolTable;
    }

    protected String getExtendsText() {
        return "extends org.apache.axis.AxisFault ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        Parameter param;
        String variable;
        Vector params = new Vector();
        this.symbolTable.getParametersFromParts(params, this.faultMessage.getOrderedParts(null), this.literal, this.faultName, null);
        int i = 0;
        while (i < params.size()) {
            Parameter param2 = (Parameter)params.get(i);
            String type = param2.getType().getName();
            variable = param2.getName();
            pw.println("    public " + type + " " + variable + ";");
            pw.println("    public " + type + " get" + Utils.capitalizeFirstChar(variable) + "() {");
            pw.println("        return this." + variable + ";");
            pw.println("    }");
            ++i;
        }
        pw.println();
        pw.println("    public " + this.className + "() {");
        pw.println("    }");
        pw.println();
        if (params.size() > 0) {
            String variable2;
            pw.print("      public " + this.className + "(");
            int i2 = 0;
            while (i2 < params.size()) {
                if (i2 != 0) {
                    pw.print(", ");
                }
                param = (Parameter)params.get(i2);
                String type = param.getType().getName();
                variable2 = param.getName();
                pw.print(type + " " + variable2);
                ++i2;
            }
            pw.println(") {");
            int i3 = 0;
            while (i3 < params.size()) {
                Parameter param3 = (Parameter)params.get(i3);
                variable2 = param3.getName();
                pw.println("        this." + variable2 + " = " + variable2 + ";");
                ++i3;
            }
            pw.println("    }");
        }
        pw.println();
        pw.println("    /**");
        pw.println("     * Writes the exception data to the faultDetails");
        pw.println("     */");
        pw.println("    public void writeDetails(javax.xml.namespace.QName qname, org.apache.axis.encoding.SerializationContext context) throws java.io.IOException {");
        int i4 = 0;
        while (i4 < params.size()) {
            param = (Parameter)params.get(i4);
            variable = param.getName();
            pw.println("        context.serialize(qname, null, " + Utils.wrapPrimitiveType(param.getType(), variable) + ");");
            ++i4;
        }
        pw.println("    }");
    }
}

