/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.impl;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.bouncycastle.util.encoders.Hex;
import org.opensaml.common.IdentifierGenerator;

public class SecureRandomIdentifierGenerator
implements IdentifierGenerator {
    private static SecureRandom random;

    public SecureRandomIdentifierGenerator() throws NoSuchAlgorithmException {
        random = SecureRandom.getInstance("SHA1PRNG");
    }

    public SecureRandomIdentifierGenerator(String algorithm) throws NoSuchAlgorithmException {
        random = SecureRandom.getInstance(algorithm);
    }

    public String generateIdentifier() {
        return this.generateIdentifier(16);
    }

    public String generateIdentifier(int size) {
        byte[] buf = new byte[size];
        random.nextBytes(buf);
        return "_".concat(new String(Hex.encode((byte[])buf)));
    }
}

